/*
**	Copyright (c) 2003-2004 National Institute of Multimedia Education. All rights reserved.
**	2-12 Wakaba, Mihama, Chiba, 261-0014 JAPAN
**	http://www.nime.ac.jp/
*/
//------------------------------------------------------------------------------
#include "Stdafx.h"
#define WIN32_LEAN_AND_MEAN
#include <streams.h>
#include <flFilterCommon/flMediaSample.h>
//------------------------------------------------------------------------------
// flMediaSample
flMediaSample::flMediaSample()
{
	_refCount = 0;

	// Property
	_mediaType.InitMediaType();
	_absoluteTime		= 0;
	// Media Sample Property
	_dataLength			= 0;
	_data				= NULL;
	_streamTimeStart	= NULL;
	_streamTimeEnd		= NULL;
	_mediaTimeStart		= NULL;
	_mediaTimeEnd		= NULL;
	_isDiscontinuity	= false;
	_isSyncPoint		= false;
	_isPreroll			= false;
}
//------------------------------------------------------------------------------
flMediaSample::~flMediaSample()
{
	delete _data;

	if (_streamTimeStart)	delete _streamTimeStart;
	if (_streamTimeEnd)		delete _streamTimeEnd;
	if (_mediaTimeStart)	delete _mediaTimeStart;
	if (_mediaTimeEnd)		delete _mediaTimeEnd;
}
//------------------------------------------------------------------------------
flInt
flMediaSample::addRef()
{
	return ++_refCount;
}
//------------------------------------------------------------------------------
flInt
flMediaSample::release()
{
	return --_refCount;
}
//------------------------------------------------------------------------------
void
flMediaSample::setMediaType(const CMediaType& mediaType)
{
	_mediaType = mediaType;
}
//------------------------------------------------------------------------------
const CMediaType&
flMediaSample::getMediaType() const
{
	return _mediaType;
}
//------------------------------------------------------------------------------
void
flMediaSample::setAbsoluteTime(flInt64 time)
{
	_absoluteTime = time;
}
//------------------------------------------------------------------------------
flInt64
flMediaSample::getAbsoluteTime() const
{
	return _absoluteTime;
}
//------------------------------------------------------------------------------
void
flMediaSample::setDataLength(flUInt dataLength)
{
	if (_dataLength < dataLength)
	{
		delete _data;
		_data = new flByte[dataLength];
	}
	_dataLength = dataLength;
}
//------------------------------------------------------------------------------
flUInt
flMediaSample::getDataLength() const
{
    return _dataLength;
}
//------------------------------------------------------------------------------
flByte*
flMediaSample::getDataPointer() const
{
	return _data;
}
//------------------------------------------------------------------------------
void
flMediaSample::setStreamTimeStart(REFERENCE_TIME* start)
{
	if (start == NULL)
	{
		delete _streamTimeStart;
		_streamTimeStart = NULL;
	}
	else
	{
		if (_streamTimeStart == NULL)
			_streamTimeStart = new REFERENCE_TIME;
		*_streamTimeStart = *start;
	}
}
//------------------------------------------------------------------------------
REFERENCE_TIME*
flMediaSample::getStreamTimeStart() const
{
	return _streamTimeStart;
}
//------------------------------------------------------------------------------
void
flMediaSample::setStreamTimeEnd(REFERENCE_TIME* end)
{
	if (end == NULL)
	{
		delete _streamTimeEnd;
		_streamTimeEnd = NULL;
	}
	else
	{
		if (_streamTimeEnd == NULL)
			_streamTimeEnd = new REFERENCE_TIME;
		*_streamTimeEnd = *end;
	}
}
//------------------------------------------------------------------------------
REFERENCE_TIME*
flMediaSample::getStreamTimeEnd() const
{
	return _streamTimeEnd;
}
//------------------------------------------------------------------------------
void
flMediaSample::setMediaTimeStart(LONGLONG* start)
{
	if (start == NULL)
	{
		delete _mediaTimeStart;
		_mediaTimeStart = NULL;
	}
	else
	{
		if (_mediaTimeStart == NULL)
			_mediaTimeStart = new LONGLONG;
		*_mediaTimeStart = *start;
	}
}
//------------------------------------------------------------------------------
LONGLONG*
flMediaSample::getMediaTimeStart() const
{
	return _mediaTimeStart;
}
//------------------------------------------------------------------------------
void
flMediaSample::setMediaTimeEnd(LONGLONG* end)
{
	if (end == NULL)
	{
		delete _mediaTimeEnd;
		_mediaTimeEnd = NULL;
	}
	else
	{
		if (_mediaTimeEnd == NULL)
			_mediaTimeEnd= new LONGLONG;
		*_mediaTimeEnd = *end;
	}
}
//------------------------------------------------------------------------------
LONGLONG*
flMediaSample::getMediaTimeEnd() const
{
	return _mediaTimeEnd;
}
//------------------------------------------------------------------------------
void
flMediaSample::setDiscontinuity(flBool flag)
{
	_isDiscontinuity = flag;
}
//------------------------------------------------------------------------------
flBool
flMediaSample::getDiscontinuity() const
{
	return _isDiscontinuity;
}
//------------------------------------------------------------------------------
void
flMediaSample::setSyncPoint(flBool flag)
{
	_isSyncPoint = flag;
}
//------------------------------------------------------------------------------
flBool
flMediaSample::getSyncPoint() const
{
	return _isSyncPoint;
}
//------------------------------------------------------------------------------
void
flMediaSample::setPreroll(flBool flag)
{
	_isPreroll = flag;
}
//------------------------------------------------------------------------------
flBool
flMediaSample::getPreroll() const
{
	return _isPreroll;
}
//------------------------------------------------------------------------------

//------------------------------------------------------------------------------
flMediaSamples::flMediaSamples()
{
	_array.setGrowSize(256);
}
//------------------------------------------------------------------------------
flMediaSamples::~flMediaSamples()
{
	for(flUInt i = 0; i < _array.getSize(); i++)
		_array[i]->release();
}
//------------------------------------------------------------------------------
flUInt
flMediaSamples::getSize() const
{
	return _array.getSize();
}
//------------------------------------------------------------------------------
flMediaSample*
flMediaSamples::get(flUInt index)
{
	if (_array.getSize() <= index)
		return NULL;
	return _array[index];
}
//------------------------------------------------------------------------------
const flMediaSample*
flMediaSamples::get(flUInt index) const
{
	if (_array.getSize() <= index)
		return NULL;
	return _array[index];
}
//------------------------------------------------------------------------------
void
flMediaSamples::add(flMediaSample* sample)
{
	if (sample == NULL)
		return ;
	_array.add(sample);
	sample->addRef();
}
//------------------------------------------------------------------------------
flMediaSample*
flMediaSamples::removeIndex(flUInt index)
{
	if (_array.getSize() <= index)
		return NULL;

	_array[index]->release();
	flMediaSample* sample = _array[index];
	_array.removeIndex(index);

	return sample;
}
//------------------------------------------------------------------------------
void
flMediaSamples::copy(const flMediaSamples& samples)
{
	for(flUInt i = 0; i < _array.getSize(); i++)
		_array[i]->release();
	_array.clear();

	for(flUInt i = 0; i < samples._array.getSize(); i++)
	{
		samples._array[i]->addRef();
		_array.add(samples._array[i]);
	}
}
//------------------------------------------------------------------------------
void
flMediaSamples::clear()
{
	for(flUInt i = 0; i < _array.getSize(); i++)
		_array[i]->release();
	_array.clear();
}
//------------------------------------------------------------------------------
flMediaSamples&
flMediaSamples::operator=(const flMediaSamples& samples)
{
	copy(samples);
	return (*this);
}
//------------------------------------------------------------------------------
flMediaSample*
flMediaSamples::operator [](flUInt i)
{
	return _array[i];
}
//------------------------------------------------------------------------------
const flMediaSample*
flMediaSamples::operator [](flUInt i) const
{
	return _array[i];
}
//------------------------------------------------------------------------------

#ifdef _DEBUG
#include <flBase/flNotify.h>
#endif

//------------------------------------------------------------------------------
flMediaSamplePool::flMediaSamplePool()
{
	_buffer.setGrowSize(256);
}
//------------------------------------------------------------------------------
flMediaSamplePool::~flMediaSamplePool()
{
	_bufferCS.enter();
	for(flUInt i = 0; i < _buffer.getSize(); i++)
	{
#ifdef _DEBUG
		if (_buffer[i]->_refCount != 0)
			flNotify::post(flNotify::L_INFO, "flMediaSamplePool::~() Ref : [%d][%d]", i, _buffer[i]->_refCount);
#endif
		delete _buffer[i];
	}
	_bufferCS.leave();
}
//------------------------------------------------------------------------------
void
flMediaSamplePool::init()
{
	_bufferCS.enter();
	for(flUInt i = 0; i < _buffer.getSize(); i++)
	{
		if (_buffer[i]->_refCount == 0)
		{
			delete _buffer[i];
			_buffer.removeIndex(i--);
		}
	}
	_bufferCS.leave();
}
//------------------------------------------------------------------------------
flMediaSample*
flMediaSamplePool::getFreeMediaSample()
{
	_bufferCS.enter();
	for(flUInt i = 0; i < _buffer.getSize(); i++)
	{
		if (_buffer[i]->_refCount == 0)
		{
			_buffer[i]->addRef();
			flMediaSample *sample = _buffer[i];
			_bufferCS.leave();
			return sample;
		}
	}

	flMediaSample *sample = new flMediaSample();
	sample->addRef();
	_buffer.add(sample);

#ifdef _DEBUG
/*
	flNotify::post(flNotify::L_INFO , "flMediaSamplePool::Create New MediaSample. [%d]",
					_buffer.getSize());
*/
#endif

	_bufferCS.leave();

	return sample;
}
//------------------------------------------------------------------------------


/*
//------------------------------------------------------------------------------
#include "Stdafx.h"
#define WIN32_LEAN_AND_MEAN
#include <streams.h>
#include <flFilterCommon/flMediaSample.h>
//------------------------------------------------------------------------------
// flMediaSample
flMediaSample::flMediaSample()
{
	_absoluteTime		= 0;

	// Media Sample Property
	_dataLength			= 0;
	_data				= NULL;
	_streamTimeStart	= NULL;
	_streamTimeEnd		= NULL;
	_mediaTimeStart		= NULL;
	_mediaTimeEnd		= NULL;
	_isDiscontinuity	= false;
	_isSyncPoint		= false;
	_isPreroll			= false;
}
//------------------------------------------------------------------------------
flMediaSample::~flMediaSample()
{
	delete _data;

	if (_streamTimeStart)	delete _streamTimeStart;
	if (_streamTimeEnd)		delete _streamTimeEnd;
	if (_mediaTimeStart)	delete _mediaTimeStart;
	if (_mediaTimeEnd)		delete _mediaTimeEnd;
}
//------------------------------------------------------------------------------
void
flMediaSample::setAbsoluteTime(flInt64 time)
{
	_absoluteTime = time;
}
//------------------------------------------------------------------------------
flInt64
flMediaSample::getAbsoluteTime() const
{
	return _absoluteTime;
}
//------------------------------------------------------------------------------
void
flMediaSample::setDataLength(flUInt dataLength)
{
	if (_dataLength < dataLength)
	{
		delete _data;
		_data = new flByte[dataLength];
	}
	_dataLength = dataLength;
}
//------------------------------------------------------------------------------
flUInt
flMediaSample::getDataLength() const
{
    return _dataLength;
}
//------------------------------------------------------------------------------
flByte*
flMediaSample::getDataPointer() const
{
	return _data;
}
//------------------------------------------------------------------------------
void
flMediaSample::setStreamTimeStart(REFERENCE_TIME* start)
{
	if (start == NULL)
	{
		delete _streamTimeStart;
		_streamTimeStart = NULL;
	}
	else
	{
		if (_streamTimeStart == NULL)
			_streamTimeStart = new REFERENCE_TIME;
		*_streamTimeStart = *start;
	}
}
//------------------------------------------------------------------------------
REFERENCE_TIME*
flMediaSample::getStreamTimeStart() const
{
	return _streamTimeStart;
}
//------------------------------------------------------------------------------
void
flMediaSample::setStreamTimeEnd(REFERENCE_TIME* end)
{
	if (end == NULL)
	{
		delete _streamTimeEnd;
		_streamTimeEnd = NULL;
	}
	else
	{
		if (_streamTimeEnd == NULL)
			_streamTimeEnd = new REFERENCE_TIME;
		*_streamTimeEnd = *end;
	}
}
//------------------------------------------------------------------------------
REFERENCE_TIME*
flMediaSample::getStreamTimeEnd() const
{
	return _streamTimeEnd;
}
//------------------------------------------------------------------------------
void
flMediaSample::setMediaTimeStart(LONGLONG* start)
{
	if (start == NULL)
	{
		delete _mediaTimeStart;
		_mediaTimeStart = NULL;
	}
	else
	{
		if (_mediaTimeStart == NULL)
			_mediaTimeStart = new LONGLONG;
		*_mediaTimeStart = *start;
	}
}
//------------------------------------------------------------------------------
LONGLONG*
flMediaSample::getMediaTimeStart() const
{
	return _mediaTimeStart;
}
//------------------------------------------------------------------------------
void
flMediaSample::setMediaTimeEnd(LONGLONG* end)
{
	if (end == NULL)
	{
		delete _mediaTimeEnd;
		_mediaTimeEnd = NULL;
	}
	else
	{
		if (_mediaTimeEnd == NULL)
			_mediaTimeEnd= new LONGLONG;
		*_mediaTimeEnd = *end;
	}
}
//------------------------------------------------------------------------------
LONGLONG*
flMediaSample::getMediaTimeEnd() const
{
	return _mediaTimeEnd;
}
//------------------------------------------------------------------------------
void
flMediaSample::setDiscontinuity(flBool flag)
{
	_isDiscontinuity = flag;
}
//------------------------------------------------------------------------------
flBool
flMediaSample::getDiscontinuity() const
{
	return _isDiscontinuity;
}
//------------------------------------------------------------------------------
void
flMediaSample::setSyncPoint(flBool flag)
{
	_isSyncPoint = flag;
}
//------------------------------------------------------------------------------
flBool
flMediaSample::getSyncPoint() const
{
	return _isSyncPoint;
}
//------------------------------------------------------------------------------
void
flMediaSample::setPreroll(flBool flag)
{
	_isPreroll = flag;
}
//------------------------------------------------------------------------------
flBool
flMediaSample::getPreroll() const
{
	return _isPreroll;
}
//------------------------------------------------------------------------------

#define DEF_BUFFER_SIZE		4
//------------------------------------------------------------------------------
// flMediaSample
flMediaSamples::flMediaSamples()
{
	_array.setBufferSize(DEF_BUFFER_SIZE);
	_array.setSize(0);
}
//------------------------------------------------------------------------------
flMediaSamples::~flMediaSamples()
{
	_arrayCS.enter();
	for(flUInt i = 0; i < _array.getSize(); i++)
	{
		delete _array[i];
		_array.removeIndex(i--);
	}
	_arrayCS.leave();
}
//------------------------------------------------------------------------------
void
flMediaSamples::setMaxSize(flUInt size)
{
	_arrayCS.enter();
	for(flUInt i = 0; i < _array.getSize(); i++)
	{
		delete _array[i];
		_array.removeIndex(i--);
	}
	ASSERT(_array.getSize() == 0);
	_array.setBufferSize(size);
	_arrayCS.leave();
	Sleep(0);
}
//------------------------------------------------------------------------------
flUInt
flMediaSamples::getMaxSize() const
{
	_arrayCS.enter();
	flUInt bufferSize = _array.getBufferSize();
	_arrayCS.leave();
	Sleep(0);
	return bufferSize;
}
//------------------------------------------------------------------------------
flUInt
flMediaSamples::getSize() const
{
	_arrayCS.enter();
	flUInt size = _array.getSize();
	_arrayCS.leave();
	Sleep(0);
	return size;
}
//------------------------------------------------------------------------------
const flMediaSample*
flMediaSamples::get(flUInt index) const
{
	assert(index < _array.getSize());
	_arrayCS.enter();
	const flMediaSample* sample = _array[index];
	_arrayCS.leave();
	Sleep(0);
	return sample;
}
//------------------------------------------------------------------------------
void
flMediaSamples::clear()
{
	_arrayCS.enter();
	for(flUInt i = 0; i < _array.getSize(); i++)
	{
		delete _array[i];
		_array.removeIndex(i--);
	}
	_arrayCS.leave();
	Sleep(0);
}
//------------------------------------------------------------------------------
flBool
flMediaSamples::add(flMediaSample *sample)
{
	_arrayCS.enter();

	flBool overwrite = false;

	if (_array.getBufferSize() <= _array.getSize())
	{
		delete _array[0];
		_array.removeIndex(0);
		overwrite = true;
	}

	_array.add(sample);

	_arrayCS.leave();
	Sleep(0);

	return overwrite;
}
//------------------------------------------------------------------------------
flMediaSample*
flMediaSamples::remove()
{
	_arrayCS.enter();

	if (_array.getSize() == 0)
	{
		_arrayCS.leave();
		Sleep(0);
		return NULL;
	}

	flMediaSample* sample = _array[0];
	_array.removeIndex(0);

	_arrayCS.leave();
	Sleep(0);

	return sample;
}
//------------------------------------------------------------------------------
*/