/*
**	Copyright (c) 2003-2004 National Institute of Multimedia Education. All rights reserved.
**	2-12 Wakaba, Mihama, Chiba, 261-0014 JAPAN
**	http://www.nime.ac.jp/
*/
//------------------------------------------------------------------------------
#ifndef __flMediaSample_h__
#define __flMediaSample_h__
//------------------------------------------------------------------------------
#include <flBase/flArray.h>
#include <flBase/flCriticalSection.h>
#include <flBase/flBase.h>
//------------------------------------------------------------------------------
class flMediaSamplePool;
class flMediaSample;
typedef flArray<flMediaSample *>	flMediaSamplePArray;
//------------------------------------------------------------------------------
class flMediaSample 
{
	friend class flMediaSamplePool;

private:
	flMediaSample();
	~flMediaSample();

public:
	flInt				addRef();
	flInt				release();

public:
	void				setMediaType(const CMediaType& mediaType);
	const CMediaType&	getMediaType() const;

	void				setAbsoluteTime(flInt64 time);
	flInt64				getAbsoluteTime() const;

	void				setDataLength(flUInt dataLength);
	flUInt				getDataLength() const;
	flByte*				getDataPointer() const;

	void				setStreamTimeStart(REFERENCE_TIME* start);
	REFERENCE_TIME*		getStreamTimeStart() const;

	void				setStreamTimeEnd(REFERENCE_TIME* end);
	REFERENCE_TIME*		getStreamTimeEnd() const;

	void				setMediaTimeStart(LONGLONG* start);
	LONGLONG*			getMediaTimeStart() const;

	void				setMediaTimeEnd(LONGLONG* end);
	LONGLONG*			getMediaTimeEnd() const;

	void				setDiscontinuity(flBool flag);
	flBool				getDiscontinuity() const;

	void				setSyncPoint(flBool flag);
	flBool				getSyncPoint() const;

	void				setPreroll(flBool flag);
	flBool				getPreroll() const;

private:
	flInt			_refCount;

	// Property
	CMediaType		_mediaType;
	flInt64			_absoluteTime;
	// Media Sample Property
	flUInt			_dataLength;
	flByte*			_data;
	REFERENCE_TIME*	_streamTimeStart;
	REFERENCE_TIME*	_streamTimeEnd;
	LONGLONG*		_mediaTimeStart;
	LONGLONG*		_mediaTimeEnd;
	flBool			_isDiscontinuity;
	flBool			_isSyncPoint;
	flBool			_isPreroll;
};
//------------------------------------------------------------------------------

//------------------------------------------------------------------------------
class flMediaSamples
{
public:
	flMediaSamples();
	~flMediaSamples();

public:
	flUInt					getSize() const;

	flMediaSample*			get(flUInt index);
	const flMediaSample*	get(flUInt index) const;

	void					add(flMediaSample* sample);
	flMediaSample*			removeIndex(flUInt index);

	void					copy(const flMediaSamples& samples);
	void					clear();

public:
	flMediaSamples&			operator=(const flMediaSamples& samples);

	flMediaSample*			operator [](flUInt i);
	const flMediaSample*	operator [](flUInt i) const;

private:
	flMediaSamplePArray		_array;
};

//------------------------------------------------------------------------------

#include <flBase/flCriticalSection.h>

//------------------------------------------------------------------------------
class flMediaSamplePool
{
public:
	flMediaSamplePool();
	~flMediaSamplePool();

public:
	void			init();
	flMediaSample*	getFreeMediaSample();

private:
	flCriticalSection	_bufferCS;
	flMediaSamplePArray	_buffer;
};
//------------------------------------------------------------------------------
#endif //__flMediaSample_h__








/*//------------------------------------------------------------------------------
#ifndef __flMediaSample_h__
#define __flMediaSample_h__
//------------------------------------------------------------------------------
#include <flBase/flArray.h>
#include <flBase/flCriticalSection.h>
#include <flBase/flBase.h>
//------------------------------------------------------------------------------
class flMediaSample;
typedef flArray<flMediaSample *>	flMediaSamplePArray;
//------------------------------------------------------------------------------
class flMediaSample 
{
public:
	flMediaSample();
	~flMediaSample();

public:
	void			setAbsoluteTime(flInt64 time);
	flInt64			getAbsoluteTime() const;

	void			setDataLength(flUInt dataLength);
	flUInt			getDataLength() const;
	flByte*			getDataPointer() const;

	void			setStreamTimeStart(REFERENCE_TIME* start);
	REFERENCE_TIME*	getStreamTimeStart() const;

	void			setStreamTimeEnd(REFERENCE_TIME* end);
	REFERENCE_TIME*	getStreamTimeEnd() const;

	void			setMediaTimeStart(LONGLONG* start);
	LONGLONG*		getMediaTimeStart() const;

	void			setMediaTimeEnd(LONGLONG* end);
	LONGLONG*		getMediaTimeEnd() const;

	void			setDiscontinuity(flBool flag);
	flBool			getDiscontinuity() const;

	void			setSyncPoint(flBool flag);
	flBool			getSyncPoint() const;

	void			setPreroll(flBool flag);
	flBool			getPreroll() const;

private:
	flInt64			_absoluteTime;

	// Media Sample Property
	flUInt			_dataLength;
	flByte*			_data;
	REFERENCE_TIME*	_streamTimeStart;
	REFERENCE_TIME*	_streamTimeEnd;
	LONGLONG*		_mediaTimeStart;
	LONGLONG*		_mediaTimeEnd;
	flBool			_isDiscontinuity;
	flBool			_isSyncPoint;
	flBool			_isPreroll;
};
//------------------------------------------------------------------------------
class flMediaSamples
{
public:
	flMediaSamples();
	~flMediaSamples();

public:
	void					setMaxSize(flUInt size);
	flUInt					getMaxSize() const;

	flUInt					getSize() const;
	const flMediaSample*	get(flUInt index) const;

public:
	void					clear();

	flBool					add(flMediaSample *sample);
	flMediaSample*			remove();

private:
	flCriticalSection			_arrayCS;
	flMediaSamplePArray			_array;
};
//------------------------------------------------------------------------------
#endif //__flMediaSample_h__
*/
