/*
**	Copyright (c) 2003-2004 National Institute of Multimedia Education. All rights reserved.
**	2-12 Wakaba, Mihama, Chiba, 261-0014 JAPAN
**	http://www.nime.ac.jp/
*/
//------------------------------------------------------------------------------
#ifndef __flMediaType_h__
#define __flMediaType_h__
//------------------------------------------------------------------------------
class flMediaType : public CMediaType
{
public:
	flMediaType();
	~flMediaType();

public:
	// Media Type
	enum MediaTypeEnum {
		MT_VIDEO,
		MT_AUDIO,
		MT_POINTER,
		MT_UNKNOWN,
		NUM_MT
	};
	void				setMediaType(MediaTypeEnum mediaType);
	MediaTypeEnum		getMediaType() const;

	// Video Format
	enum VideoFormatEnum {
		VF_RGB555,
		VF_RGB24,
		VF_MPEG4_2,
		VF_MPEG4_3,
		VF_DVSD,
		VF_H261,
		VF_H263,
		VF_MJPEG,
		VF_UNKNOWN,
		NUM_VF
	};
	void				setVideoFormat(VideoFormatEnum videoFormat);
	VideoFormatEnum		getVideoFormat() const;

	// Video Resolution
	enum VideoResolutionEnum {
		VR_SQCIF,
		VR_QCIF,
		VR_CIF,
		VR_160x120,
		VR_180x120,
		VR_320x240,
		VR_360x240,
		VR_640x480,
		VR_720x480,
		VR_800x600,
		VR_1024x768,
		VR_1280x1024,
		VR_1600x1200,
		VR_HDTV720P,
		VR_HDTV1080I,
		VR_SDTV480P,
		VR_SDTV480I,
		VR_UNKNOWN,
		NUM_VR
	};
	void				setVideoResolution(VideoResolutionEnum videoResolution);
	VideoResolutionEnum	getVideoResolution() const;

	// Audio Format
	enum AudioFormatEnum {
		AF_MP3,
		AF_PCM,
		AF_MPEG1,
		AF_UNKNOWN,
		NUM_AF
	};
	void				setAudioFormat(AudioFormatEnum audioFormat);
	AudioFormatEnum		getAudioFormat() const;

	// Audio Frequency
	enum AudioFrequencyEnum {
		AQ_8KHz,
		AQ_11KHz,
		AQ_16KHz,
		AQ_22KHz,
		AQ_44_1KHz,
		AQ_48KHz,
		AQ_UNKNOWN,
		NUM_AQ
	};
	void				setAudioFrequency(AudioFrequencyEnum audioFrequency);
	AudioFrequencyEnum	getAudioFrequency() const;

	// Audio Stereo
	enum AudioStereoEnum {
		AS_STEREO,
		AS_MONO,
		AS_UNKNOWN,
		NUM_AS
	};
	void				setAudioStereo(AudioStereoEnum audioStereo);
	AudioStereoEnum		getAudioStereo() const;

	// Audio Bit count
	enum AudioBitCountEnum {
		AB_0Bit,
		AB_8Bit,
		AB_16Bit,
		AB_UNKNOWN,
		NUM_AB
	};
	void				setAudioBitCount(AudioBitCountEnum audioBitCount);
	AudioBitCountEnum	getAudioBitCount() const;

public:
    flMediaType&		operator=(const CMediaType& mt);
    flMediaType&		operator=(const AM_MEDIA_TYPE& mt);

    BOOL				operator==(const flMediaType& mt) const;
    BOOL				operator!=(const flMediaType& mt) const;

	// overwrite
	HRESULT				Set(const AM_MEDIA_TYPE& mt);

private:
	void			setDefaultMediaType();

	void			configMediaType();
	void			_configVideoMediaType();
	void			_configAudioMediaType();
	void			_configPointerMediaType();
	void			_configUnknownMediaType();

	void			analyzeMediaType();
	void			_analyzeVideoMediaType();
	void			_analyzeAudioMediaType();
	void			_analyzePointerMediaType();

protected:
	MediaTypeEnum			_mediaType;
	VideoFormatEnum			_videoFormat;
	VideoResolutionEnum		_videoResolution;
	AudioFormatEnum			_audioFormat;
	AudioFrequencyEnum		_audioFrequency;
	AudioStereoEnum			_audioStereo;
	AudioBitCountEnum		_audioBitCount;
};
//------------------------------------------------------------------------------
#endif //__flMediaType_h__
