/*
**	Copyright (c) 2003-2004 National Institute of Multimedia Education. All rights reserved.
**	2-12 Wakaba, Mihama, Chiba, 261-0014 JAPAN
**	http://www.nime.ac.jp/
*/
//------------------------------------------------------------------------------
#include "Stdafx.h"

#define WIN32_LEAN_AND_MEAN
#include <windows.h>
#include <streams.h>

#include <flFilterCommon/flMultiBufferInputPin.h>
#include <flFilterCommon/flMultiBufferStream.h>
#include <flFilterCommon/flMultiBuffer.h>
//------------------------------------------------------------------------------
CFLMultiBuffer::CFLMultiBuffer(TCHAR *pName, LPUNKNOWN lpunk, REFCLSID clsid) :
CBaseFilter(pName, lpunk, &_csFilter, clsid)
{
	_bufferInputPins.setGrowSize(16);
	_bufferStream		= NULL;
}
//------------------------------------------------------------------------------
CFLMultiBuffer::~CFLMultiBuffer()
{
	flUInt numPins = _bufferInputPins.getSize();
	for(flUInt i = 0; i < numPins; i++)
		delete _bufferInputPins[0];
	delete _bufferStream;
}
//------------------------------------------------------------------------------
// obt@O
HRESULT
CFLMultiBuffer::Buffering(flUInt , IMediaSample *)
{
	return NOERROR;
}
//------------------------------------------------------------------------------
HRESULT
CFLMultiBuffer::Deliver(IMediaSample *)
{
	return NOERROR;
}
//------------------------------------------------------------------------------
void
CFLMultiBuffer::AdjustDeliverRate(flInt64 deliverProcTime)
{
}
//------------------------------------------------------------------------------
// s̑
flInt
CFLMultiBuffer::GetPinCount()
{
	CAutoLock lock(&_csFilter);
	return _bufferInputPins.getSize() + 1;
}
//------------------------------------------------------------------------------
CBasePin*
CFLMultiBuffer::GetPin(flInt n)
{
	CAutoLock lock(&_csFilter);

	flInt numPins = (flInt)_bufferInputPins.getSize();

	if (n < numPins)
	{
		return _bufferInputPins[n];
	}
	else if (n == numPins)
	{
		if (_bufferStream == NULL)
		{
			HRESULT hr = S_OK;

			_bufferStream = new CFLMultiBufferStream("Buffer Streamm", &hr, this, L"Out");
			ASSERT(SUCCEEDED(hr));
		}
		return _bufferStream;
	}
	else
	{
		return NULL;
	}
}
//------------------------------------------------------------------------------
STDMETHODIMP
CFLMultiBuffer::FindPin(LPCWSTR Id, IPin **ppPin)
{
	if (!lstrcmpW(Id, L"Out"))
	{
		*ppPin = GetPin(_bufferInputPins.getSize());
		if (*ppPin == NULL)
			return VFW_E_NOT_FOUND;

		(*ppPin)->AddRef();
		return NOERROR;
	}

	*ppPin = GetPin(WstrToInt(Id));
	if (*ppPin == NULL)
		return VFW_E_NOT_FOUND;

	(*ppPin)->AddRef();
	return NOERROR;
}
//------------------------------------------------------------------------------
flInt
CFLMultiBuffer::FindPinNumber(IPin *pPin)
{
	flUInt index;
	if (!_bufferInputPins.find((CFLMultiBufferInputPin *)pPin, index))
		return -1;
	else
		return index;
}
//------------------------------------------------------------------------------
HRESULT
CFLMultiBuffer::AddPin(CFLMultiBufferInputPin *pin)
{
	CAutoLock lock(&_csFilter);
	pin->_myIndex = _bufferInputPins.getSize();
	_bufferInputPins.add(pin);
	return S_OK;
}
//------------------------------------------------------------------------------
HRESULT
CFLMultiBuffer::RemovePin(CFLMultiBufferInputPin *pin)
{
	CAutoLock lock(&_csFilter);

	flUInt index;
	if (!_bufferInputPins.find(pin, index))
		return S_FALSE;

	_bufferInputPins.removeIndex(index);
	return S_OK;
}
//------------------------------------------------------------------------------
HRESULT
CFLMultiBuffer::OnStartDelivery()
{
	return NOERROR;
}
//------------------------------------------------------------------------------
HRESULT
CFLMultiBuffer::OnEndDelivery()
{
	return NOERROR;
}
//------------------------------------------------------------------------------
HRESULT
CFLMultiBuffer::Receive(flUInt pinIndex, IMediaSample *pSample)
{
	ASSERT(pinIndex < _bufferInputPins.getSize());

	AM_SAMPLE2_PROPERTIES * const pProps = _bufferInputPins[pinIndex]->SampleProps();
	if (pProps->dwStreamId != AM_STREAM_MEDIA)
		return NOERROR;

	ASSERT(pSample != NULL);
	ASSERT(_bufferStream != NULL);

	return Buffering(pinIndex, pSample);
}
//------------------------------------------------------------------------------
HRESULT
CFLMultiBuffer::EndOfStream(flUInt pinIndex)
{
	return NOERROR;
}
//------------------------------------------------------------------------------
// Input
HRESULT
CFLMultiBuffer::SetInputMediaType(flUInt , const CMediaType *)
{
	return NOERROR;
}
//------------------------------------------------------------------------------
HRESULT
CFLMultiBuffer::CheckInputConnect(flUInt , IPin *)
{
	return NOERROR;
}
//------------------------------------------------------------------------------
HRESULT
CFLMultiBuffer::BreakInputConnect(flUInt )
{
	return NOERROR;
}
//------------------------------------------------------------------------------
HRESULT
CFLMultiBuffer::CompleteInputConnect(flUInt , IPin *)
{
	return NOERROR;
}
//------------------------------------------------------------------------------
// Output
HRESULT
CFLMultiBuffer::SetOutputMediaType(const CMediaType *)
{
	return NOERROR;
}
//------------------------------------------------------------------------------
HRESULT
CFLMultiBuffer::CheckOutputConnect(IPin *)
{
	flBool isConnect = false;
	for(flUInt i = 0; i < _bufferInputPins.getSize(); i++)
	{
		if (_bufferInputPins[i]->IsConnected() == TRUE)
		{
			isConnect = true;
			break;
		}
	}

	if (!isConnect)
		return E_UNEXPECTED;

	return NOERROR;
}
//------------------------------------------------------------------------------
HRESULT
CFLMultiBuffer::BreakOutputConnect()
{
	return NOERROR;
}
//------------------------------------------------------------------------------
HRESULT
CFLMultiBuffer::CompleteOutputConnect(IPin *)
{
	return NOERROR;
}
//------------------------------------------------------------------------------
HRESULT
CFLMultiBuffer::InitializeOutputSample(IMediaSample **ppOutSample)
{
	ASSERT(_bufferStream->m_pAllocator != NULL);
	return _bufferStream->m_pAllocator->GetBuffer(ppOutSample, NULL, NULL, 0);
/*
	flBool _sampleSkipped = false;

	ASSERT(_bufferInputPins[0] != NULL);
	if (_bufferInputPins[0]->IsConnected() == FALSE)
		return E_FAIL;

	IMediaSample *pOutSample;

	AM_SAMPLE2_PROPERTIES * const pProps = _bufferInputPins[0]->SampleProps();
	DWORD dwFlags = _sampleSkipped ? AM_GBF_PREVFRAMESKIPPED : 0;

	if (!(pProps->dwSampleFlags & AM_SAMPLE_SPLICEPOINT))
		dwFlags |= AM_GBF_NOTASYNCPOINT;

	ASSERT(_bufferStream->m_pAllocator != NULL);
	HRESULT hr = _bufferStream->m_pAllocator->GetBuffer(
				&pOutSample,
				pProps->dwSampleFlags & AM_SAMPLE_TIMEVALID ? &pProps->tStart : NULL,
				pProps->dwSampleFlags & AM_SAMPLE_STOPVALID ? &pProps->tStop : NULL,
				dwFlags);

	*ppOutSample = pOutSample;
	if (FAILED(hr))
		return hr;

	ASSERT(pOutSample != NULL);
	IMediaSample2 *pOutSample2;

	if (SUCCEEDED(pOutSample->QueryInterface(IID_IMediaSample2, (void **)&pOutSample2)))
	{
		AM_SAMPLE2_PROPERTIES OutProps;
		EXECUTE_ASSERT(SUCCEEDED(pOutSample2->GetProperties(
			FIELD_OFFSET(AM_SAMPLE2_PROPERTIES, tStart), (PBYTE)&OutProps)
		));
		OutProps.dwTypeSpecificFlags = pProps->dwTypeSpecificFlags;
		OutProps.dwSampleFlags =
			(OutProps.dwSampleFlags & AM_SAMPLE_TYPECHANGED) |
			(pProps->dwSampleFlags & ~AM_SAMPLE_TYPECHANGED);
		OutProps.tStart = pProps->tStart;
		OutProps.tStop  = pProps->tStop;
		OutProps.cbData = FIELD_OFFSET(AM_SAMPLE2_PROPERTIES, dwStreamId);
		hr = pOutSample2->SetProperties(
			FIELD_OFFSET(AM_SAMPLE2_PROPERTIES, dwStreamId),
			(PBYTE)&OutProps
		);
		if (pProps->dwSampleFlags & AM_SAMPLE_DATADISCONTINUITY)
			_sampleSkipped = FALSE;

		pOutSample2->Release();
	}
	else
	{
		if (pProps->dwSampleFlags & AM_SAMPLE_TIMEVALID)
		{
			pOutSample->SetTime(&pProps->tStart, &pProps->tStop);
		}
		if (pProps->dwSampleFlags & AM_SAMPLE_SPLICEPOINT)
		{
			pOutSample->SetSyncPoint(TRUE);
		}
		if (pProps->dwSampleFlags & AM_SAMPLE_DATADISCONTINUITY)
		{
			pOutSample->SetDiscontinuity(TRUE);
			_sampleSkipped = FALSE;
		}
	}

	return S_OK;
*/
}
//------------------------------------------------------------------------------
