/*
**	Copyright (c) 2003-2004 National Institute of Multimedia Education. All rights reserved.
**	2-12 Wakaba, Mihama, Chiba, 261-0014 JAPAN
**	http://www.nime.ac.jp/
*/
//------------------------------------------------------------------------------
#ifndef __flMultiBuffer_h__
#define __flMultiBuffer_h__
//------------------------------------------------------------------------------
#include <flBase/flArray.h>
#include <flBase/flBase.h>
//------------------------------------------------------------------------------
class CFLMultiBufferInputPin;
class CFLMultiBufferStream;
//------------------------------------------------------------------------------
class AM_NOVTABLE CFLMultiBuffer : public CBaseFilter
{
	friend class CFLMultiBufferInputPin;
	friend class CFLMultiBufferStream;

public:
	CFLMultiBuffer(TCHAR *pName, LPUNKNOWN lpunk, REFCLSID clsid);
	~CFLMultiBuffer();

public:
	// obt@O
	virtual HRESULT		Buffering(flUInt pinIndex, IMediaSample *pSample);
	virtual HRESULT		Deliver(IMediaSample *pSample);

	virtual void		AdjustDeliverRate(flInt64 deliverProcTime);

public:
	// s̑
	virtual flInt		GetPinCount();
	virtual CBasePin*	GetPin(flInt n);
	STDMETHODIMP		FindPin(LPCWSTR Id, IPin **ppPin);
	flInt				FindPinNumber(IPin *pPin);

protected:
	HRESULT				AddPin(CFLMultiBufferInputPin *pin);
	HRESULT				RemovePin(CFLMultiBufferInputPin *pin);

public:
	// Xg[~O
	virtual HRESULT		OnStartDelivery();
	virtual HRESULT		OnEndDelivery();

protected:
	// Input
	virtual HRESULT		Receive(flUInt pinIndex, IMediaSample *pSample);
	virtual HRESULT		EndOfStream(flUInt pinIndex);

	virtual HRESULT		SetInputMediaType(flUInt pinIndex, const CMediaType *pmt);
	virtual HRESULT		CheckInputConnect(flUInt pinIndex, IPin *pPin);
	virtual HRESULT		BreakInputConnect(flUInt pinIndex);
	virtual HRESULT		CompleteInputConnect(flUInt pinIndex, IPin *pReceivePin);

	// Output
	virtual HRESULT		SetOutputMediaType(const CMediaType *pmt);
	virtual HRESULT		CheckOutputConnect(IPin *pPin);
	virtual HRESULT		BreakOutputConnect();
	virtual HRESULT		CompleteOutputConnect(IPin *pReceivePin);

	HRESULT				InitializeOutputSample(IMediaSample **ppOutSample);

protected:
	// Input
	virtual HRESULT		CheckInputMediaType(flUInt pinIndex, const CMediaType* mtIn) PURE;

	// Output
	virtual HRESULT		CheckOutputMediaType(const CMediaType* mtOut) PURE;
	virtual HRESULT		GetOutputMediaType(flInt position, CMediaType *pMediaType) PURE;

	virtual HRESULT		DecideBufferSize(IMemAllocator * pAllocator,
										ALLOCATOR_PROPERTIES *pprop) PURE;

protected:
	CCritSec							_csFilter;

	flArray<CFLMultiBufferInputPin *>	_bufferInputPins;
	CFLMultiBufferStream*				_bufferStream;
};
//------------------------------------------------------------------------------
#endif //__flMultiBuffer_h__
