/*
**	Copyright (c) 2003-2004 National Institute of Multimedia Education. All rights reserved.
**	2-12 Wakaba, Mihama, Chiba, 261-0014 JAPAN
**	http://www.nime.ac.jp/
*/
//------------------------------------------------------------------------------
#include "Stdafx.h"

#define WIN32_LEAN_AND_MEAN
#include <windows.h>
#include <streams.h>

#include <flFilterCommon/flMultiBufferInputPin.h>
#include <flFilterCommon/flMultiBufferStream.h>
#include <flFilterCommon/flMultiBuffer.h>
#include <flBase/flSystemTime.h>
//------------------------------------------------------------------------------
CFLMultiBufferInputPin::CFLMultiBufferInputPin(CFLMultiBuffer *filter,
											   HRESULT *phr,
											   LPCWSTR pName) :
CBaseInputPin(NAME("MultiBufferInputPin"), filter, &filter->_csFilter, phr, pName)
{
	_bufferFilter	= filter;
	_absTime		= new flSystemTime();
	_myIndex		= 0;
}
//------------------------------------------------------------------------------
CFLMultiBufferInputPin::~CFLMultiBufferInputPin()
{
	delete _absTime;
	_bufferFilter->RemovePin(this);
}
//------------------------------------------------------------------------------
STDMETHODIMP
CFLMultiBufferInputPin::QueryId(LPWSTR *Id)
{
	CheckPointer(Id, E_POINTER);
	ValidateReadWritePtr(Id, sizeof(LPWSTR));

	flInt i = _bufferFilter->FindPinNumber(this);
	if (i < 0)
		return VFW_E_NOT_FOUND;

	*Id = (LPWSTR)CoTaskMemAlloc(8);
	if (*Id == NULL)
		return E_OUTOFMEMORY;

	IntToWstr(i, *Id);

	return NOERROR;
}
//------------------------------------------------------------------------------
HRESULT
CFLMultiBufferInputPin::CheckConnect(IPin *pPin)
{
	HRESULT hr = _bufferFilter->CheckInputConnect(_myIndex, pPin);
	if (FAILED(hr))
		return hr;

	return CBaseInputPin::CheckConnect(pPin);
}
//------------------------------------------------------------------------------
HRESULT
CFLMultiBufferInputPin::BreakConnect()
{
	ASSERT(IsStopped());
	_bufferFilter->BreakInputConnect(_myIndex);
	return CBaseInputPin::BreakConnect();
}
//------------------------------------------------------------------------------
HRESULT
CFLMultiBufferInputPin::CompleteConnect(IPin *pReceivePin)
{
	HRESULT hr = _bufferFilter->CompleteInputConnect(_myIndex, pReceivePin);
	if (FAILED(hr))
		return hr;

	return CBaseInputPin::CompleteConnect(pReceivePin);
}
//------------------------------------------------------------------------------
HRESULT
CFLMultiBufferInputPin::CheckMediaType(const CMediaType* pmt)
{
	return _bufferFilter->CheckInputMediaType(_myIndex, pmt);
}
//------------------------------------------------------------------------------
HRESULT
CFLMultiBufferInputPin::SetMediaType(const CMediaType* mtIn)
{
	HRESULT hr = CBasePin::SetMediaType(mtIn);
	if (FAILED(hr))
		return hr;

	ASSERT(SUCCEEDED(_bufferFilter->CheckInputMediaType(_myIndex, mtIn)));

	return _bufferFilter->SetInputMediaType(_myIndex, mtIn);
}
//------------------------------------------------------------------------------
STDMETHODIMP
CFLMultiBufferInputPin::Receive(IMediaSample * pSample)
{
	ASSERT(pSample != NULL);

	HRESULT hr;
	CAutoLock lock(&_csReceive);

	hr = CBaseInputPin::Receive(pSample);
	if (hr != S_OK)
		return hr;

#if 0
	REFERENCE_TIME timeStart, timeEnd;
	hr = pSample->GetTime(&timeStart, &timeEnd);

	if (hr == S_OK)
	{
		// Xg[^Cݒ肳ĂꍇM^C~O̒sB
		_absTime->update();
		flInt64 procStartTime = _absTime->getTime();

		hr = _bufferFilter->Receive(_myIndex, pSample);

		_absTime->update();
		flInt64 procTime = _absTime->getTime() - procStartTime;
		flInt64 sleepTime = timeEnd - timeStart - procTime;

		if (0 < sleepTime)
			Sleep(flULong(sleepTime / 10000));
	}
	else
	{
		// M^C~O̒sȂB
		hr = _bufferFilter->Receive(_myIndex, pSample);
		Sleep(0);
	}
#else
	hr = _bufferFilter->Receive(_myIndex, pSample);
	Sleep(0);
#endif

	return hr;
}
//------------------------------------------------------------------------------
STDMETHODIMP
CFLMultiBufferInputPin::EndOfStream()
{
	CAutoLock lock(&_csReceive);
	HRESULT hr = CheckStreaming();
	if (hr == S_OK)
		hr = _bufferFilter->EndOfStream(_myIndex);
	return hr;
}
//------------------------------------------------------------------------------
HRESULT
CFLMultiBufferInputPin::CheckStreaming()
{
	ASSERT(_bufferFilter->_bufferStream != NULL);

	if (!_bufferFilter->_bufferStream->IsConnected())
	{
		return VFW_E_NOT_CONNECTED;
	}
	else
	{
		ASSERT(IsConnected());

		if (m_bFlushing)
			return S_FALSE;

		if (IsStopped())
			return VFW_E_WRONG_STATE;

		if (m_bRunTimeError)
    		return VFW_E_RUNTIME_ERROR;

		return S_OK;
	}
}
//------------------------------------------------------------------------------
CMediaType&
CFLMultiBufferInputPin::CurrentMediaType()
{
	return m_mt;
}
//------------------------------------------------------------------------------
