/*
**	Copyright (c) 2003-2004 National Institute of Multimedia Education. All rights reserved.
**	2-12 Wakaba, Mihama, Chiba, 261-0014 JAPAN
**	http://www.nime.ac.jp/
*/
//------------------------------------------------------------------------------
#ifndef __flMultiBufferInputPin_h__
#define __flMultiBufferInputPin_h__
//------------------------------------------------------------------------------
#include <flBase/flBase.h>
//------------------------------------------------------------------------------
class flAbsoluteTime;
//------------------------------------------------------------------------------
class CFLMultiBufferInputPin : public CBaseInputPin
{
    friend class CFLMultiBuffer;
public:
	CFLMultiBufferInputPin(CFLMultiBuffer *pFilter,
						HRESULT * phr,
						LPCWSTR pName);
	virtual ~CFLMultiBufferInputPin();

public:
	STDMETHODIMP	QueryId(LPWSTR * Id);

	HRESULT			CheckConnect(IPin *pPin);
	HRESULT			BreakConnect();
	HRESULT			CompleteConnect(IPin *pReceivePin);

	HRESULT			CheckMediaType(const CMediaType* mtIn);
	HRESULT			SetMediaType(const CMediaType* mt);

	STDMETHODIMP	Receive(IMediaSample * pSample);
	STDMETHODIMP	EndOfStream();

	virtual HRESULT	CheckStreaming();

public:
    CMediaType&		CurrentMediaType();

protected:
	CCritSec			_csReceive;

	CFLMultiBuffer*		_bufferFilter;
	flAbsoluteTime*		_absTime;
	flUInt				_myIndex;
};
//------------------------------------------------------------------------------
#endif //__flMultiBufferInputPin_h__
