/*
**	Copyright (c) 2003-2004 National Institute of Multimedia Education. All rights reserved.
**	2-12 Wakaba, Mihama, Chiba, 261-0014 JAPAN
**	http://www.nime.ac.jp/
*/
//------------------------------------------------------------------------------
#ifndef __flMultiBufferStream_h__
#define __flMultiBufferStream_h__
//------------------------------------------------------------------------------
#include <flBase/flBase.h>
//------------------------------------------------------------------------------
class flAbsoluteTime;
class CFLMultiBuffer;
//------------------------------------------------------------------------------
class CFLMultiBufferStream : public CAMThread, public CBaseOutputPin
{
	friend class CFLMultiBuffer;

public:
	CFLMultiBufferStream(TCHAR *pObjectName,
					HRESULT *phr,
					CFLMultiBuffer *pms,
					LPCWSTR pName);
	virtual ~CFLMultiBufferStream(void);

public:
	STDMETHODIMP		QueryId(LPWSTR * Id);

protected:
	HRESULT				Active(void);
	HRESULT				Inactive(void);

public:
	enum Command {
		CMD_INIT,
		CMD_PAUSE,
		CMD_RUN,
		CMD_STOP,
		CMD_EXIT
	};
	HRESULT				Init(void)	{ return CallWorker(CMD_INIT); }
	HRESULT				Exit(void)	{ return CallWorker(CMD_EXIT); }
	HRESULT				Run(void)	{ return CallWorker(CMD_RUN); }
	HRESULT				Pause(void)	{ return CallWorker(CMD_PAUSE); }
	HRESULT				Stop(void)	{ return CallWorker(CMD_STOP); }

protected:
	Command				GetRequest(void) { return (Command) CAMThread::GetRequest(); }
	BOOL				CheckRequest(Command *pCom) { return CAMThread::CheckRequest( (DWORD *) pCom); }

	virtual DWORD		ThreadProc(void);
	virtual HRESULT		DoBufferProcessingLoop(void);

public:
    HRESULT				CheckConnect(IPin *pPin);
    HRESULT				BreakConnect();
    HRESULT				CompleteConnect(IPin *pReceivePin);

    HRESULT				SetMediaType(const CMediaType *pmt);
	HRESULT				GetMediaType(int iPosition, CMediaType *pMediaType);
	HRESULT				CheckMediaType(const CMediaType *pMediaType);

	virtual HRESULT		DecideBufferSize(IMemAllocator *pAlloc, ALLOCATOR_PROPERTIES *pProp);

	STDMETHODIMP		Notify(IBaseFilter * pSender, Quality q);

public:
    CMediaType&			CurrentMediaType();

protected:
	CFLMultiBuffer*		_bufferFilter;
	flAbsoluteTime*		_absTime;
};
//------------------------------------------------------------------------------
#endif //__flMultiBufferStream_h__
