/*
**	Copyright (c) 2003-2004 National Institute of Multimedia Education. All rights reserved.
**	2-12 Wakaba, Mihama, Chiba, 261-0014 JAPAN
**	http://www.nime.ac.jp/
*/
//------------------------------------------------------------------------------
#ifndef __flPCMAudio_h__
#define __flPCMAudio_h__
//------------------------------------------------------------------------------
#include <flTypes/VolumeInfo.h>
#include <flBase/flArray.h>
#include <flBase/flBase.h>
#include <mmsystem.h>
//------------------------------------------------------------------------------
class flPCMAudioBuffer
{
public:
	flPCMAudioBuffer();
	~flPCMAudioBuffer();

public:
	void		setData(const flByte* data, flUInt dataLength);

public:
	flByte*		Buffer;
	flUInt		DataLength;
	flInt64		StartTime;
	flInt64		EndTime;

private:
	flUInt		BufferLength;
};
//------------------------------------------------------------------------------
class flPCMAudio
{
public:
	flPCMAudio();
	virtual ~flPCMAudio();

public:
	void				setFormat(const WAVEFORMATEX *format);
	const WAVEFORMATEX*	getFormat() const;

public:
	flUShort			getChannels() const;
	flUShort			getBitsPerSample() const;
	flUInt				getSamplesPerSec() const;

public:
	void				setBufferCount(flUInt count);
	flUInt				getBufferCount() const;
	void				resetBuffer();

public:
	void				setData(const flByte* data, flUInt dataLength, flInt64 timeStamp);
	void				getVolume(VolumeInfo& volume, flInt64 startTime, flInt64 endTime) const;

protected:
	WAVEFORMATEX				_format;

	flUInt						_bufferIndex;
	flArray<flPCMAudioBuffer>	_buffers;
};
//------------------------------------------------------------------------------
#endif //__flPCMAudio_h__
