/*
**	Copyright (c) 2003-2004 National Institute of Multimedia Education. All rights reserved.
**	2-12 Wakaba, Mihama, Chiba, 261-0014 JAPAN
**	http://www.nime.ac.jp/
*/
//------------------------------------------------------------------------------
#include "Stdafx.h"
#include <flFilterCommon/flPointerDraw.h>
#include <assert.h>
//------------------------------------------------------------------------------
flPointerDraw::flPointerDraw(flUInt videoWidth, flUInt videoHeight, 
		const flImage& image, const flString& name, flInt orgX, flInt orgY) :
flShapeDraw(videoWidth, videoHeight)
{
	_name		= name;
	_originX	= orgX;
	_originY	= orgY;

	_positionX	= 0;
	_positionY	= 0;
	memset(_color, 0xff, sizeof(_color));
	memset(_clearColor, 0x00, sizeof(_clearColor));

	setImage(image);
}
//------------------------------------------------------------------------------
flPointerDraw::flPointerDraw(
		const flImage& image, const flString& name, flInt orgX, flInt orgY) :
flShapeDraw()
{
	_name		= name;
	_originX	= orgX;
	_originY	= orgY;

	_positionX	= 0;
	_positionY	= 0;
	memset(_color, 0xff, sizeof(_color));
	memset(_clearColor, 0x00, sizeof(_clearColor));

	setImage(image);
}
//------------------------------------------------------------------------------
flPointerDraw::~flPointerDraw()
{
}
//------------------------------------------------------------------------------
void
flPointerDraw::draw(flByte* data)
{
	// Calculate Actual Pointer Coordinate
	flInt x = _positionX - _originX;
	flInt y = _positionY - _originY;

	flUInt bitmapWidth = _image.width();
	flUInt bitmapHeight = _image.height();
	const flByte *bitmap = _image.image();

	y = -y + _videoHeight - bitmapWidth;


	flByte pixel[3];
	flInt ix, jy;

	for(flInt i = 0; i < (flInt)bitmapWidth; i++)
	{
		ix = x + i;
		if (ix < 0 || (flInt)_videoWidth <= ix)
			continue;

		for(flInt j = 0; j < (flInt)bitmapHeight; j++)
		{
			jy = y + j;
			if (jy < 0 || (flInt)_videoHeight <= jy)
				continue;

			CopyMemory(pixel, bitmap + i * 3 + j * bitmapWidth * 3, 3);
			if (!memcmp(pixel, _clearColor, 3))
				continue;

			pixel[0] &= _color[2];
			pixel[1] &= _color[1];
			pixel[2] &= _color[0];

			CopyMemory(data + ix * 3 + jy * _videoWidth * 3, pixel, 3);
		}
	}
}
//------------------------------------------------------------------------------
const flImage&
flPointerDraw::getImage() const
{
	return _image;
}
//------------------------------------------------------------------------------
void
flPointerDraw::setImage(const flImage& image)
{
	_image = image;

	memset(_clearColor, 0x00, sizeof(_clearColor));
	if (_image.width() != 0 && _image.height() != 0)
	{
		const flByte *bitmap = _image.image();
		memcpy(_clearColor, bitmap, sizeof(_clearColor));
	}
}
//------------------------------------------------------------------------------
void
flPointerDraw::getOrigin(flInt& originX, flInt& originY) const
{
	originX = _originX;
	originY = _originY;
}
//------------------------------------------------------------------------------
void
flPointerDraw::setOrigin(flInt originX, flInt originY)
{
	_originX = originX;
	_originY = originY;
}
//------------------------------------------------------------------------------
const flString&
flPointerDraw::getName() const
{
	return _name;
}
//------------------------------------------------------------------------------
void
flPointerDraw::setName(const flString& name)
{
	_name = name;
}
//------------------------------------------------------------------------------
void
flPointerDraw::getPosition(flInt& x, flInt& y) const
{
	x = _positionX;
	y = _positionY;
}
//------------------------------------------------------------------------------
void
flPointerDraw::setPosition(flInt x, flInt y)
{
	_positionX = x;
	_positionY = y;
}
//------------------------------------------------------------------------------
const flByte*
flPointerDraw::getColor() const
{
	return _color;
}
//------------------------------------------------------------------------------
void
flPointerDraw::setColor(const flByte* color)
{
	memcpy(_color, color, sizeof(_color));
}
//------------------------------------------------------------------------------
