/*
**	Copyright (c) 2003-2004 National Institute of Multimedia Education. All rights reserved.
**	2-12 Wakaba, Mihama, Chiba, 261-0014 JAPAN
**	http://www.nime.ac.jp/
*/
//------------------------------------------------------------------------------
#ifndef __flPointerDraw_h__
#define __flPointerDraw_h__
//------------------------------------------------------------------------------
#include <flFilterCommon/flShapeDraw.h>
#include <flBase/flImage.h>
#include <flBase/flBase.h>
//------------------------------------------------------------------------------
class flPointerDraw : public flShapeDraw
{
public:
	flPointerDraw(flUInt videoWidth, flUInt videoHeight, 
				const flImage& image, const flString& name, flInt orgX, flInt orgY);
	flPointerDraw(const flImage& image, const flString& name, flInt orgX, flInt orgY);
	virtual ~flPointerDraw();

public:
	virtual void	draw(flByte* data);

public:
	const flImage&	getImage() const;
	void			setImage(const flImage& image);

	void			getOrigin(flInt& originX, flInt& originY) const;
	void			setOrigin(flInt originX, flInt originY);

	const flString&	getName() const;
	void			setName(const flString& name);

public:
	void			getPosition(flInt& x, flInt& y) const;
	void			setPosition(flInt x, flInt y);

	const flByte*	getColor() const;
	void			setColor(const flByte* color);

protected:
	flImage			_image;
	flString		_name;
	flInt			_originX;
	flInt			_originY;
	flInt			_positionX;
	flInt			_positionY;
	flByte			_color[3];
	flByte			_clearColor[3];
};
//------------------------------------------------------------------------------
DECLARE_SAFE_COPYFUNC(flPointerDraw);
DECLARE_SAFE_COMPFUNC(flPointerDraw);
//------------------------------------------------------------------------------
#endif //__flPointerDraw_h__
