/*
**	Copyright (c) 2003-2004 National Institute of Multimedia Education. All rights reserved.
**	2-12 Wakaba, Mihama, Chiba, 261-0014 JAPAN
**	http://www.nime.ac.jp/
*/
//------------------------------------------------------------------------------
#include "Stdafx.h"
#include <initguid.h>
#include <flFilterCommon/flPointerInfo.h>
//------------------------------------------------------------------------------
flPointerInfo::flPointerInfo()
{
	memset(this, 0, FIELD_OFFSET(flPointerInfo, _oStream));
}
//------------------------------------------------------------------------------
flPointerInfo::~flPointerInfo()
{
}
//------------------------------------------------------------------------------
void
flPointerInfo::get(const flByte*& byteArray, flUInt& size)
{
	_oStream.reset();

	_oStream.writeUShort(PIID_POINTERSHAPE);
	_oStream.writeShort(_pointerShape);

	_oStream.writeUShort(PIID_POINTERCOLOR);
	_oStream.writeByte(_pointerColor, 3);

	_oStream.writeUShort(PIID_SCREENSIZE);
	_oStream.writeUShort(_screenSize, 2);

	_oStream.writeUShort(PIID_POINTERPOSITION);
	_oStream.writeUShort(_pointerPosition, 2);

	_oStream.writeUShort(PIID_BUTTONSTATUS);
	_oStream.writeUShort(_buttonStatus);

	_oStream.writeUShort(PIID_WHEELSTATUS);
	_oStream.writeUShort(_wheelStatus);

	_oStream.writeUShort(PIID_DRAWSTATUS);
	_oStream.writeUShort(_drawStatus);

	_oStream.writeUShort(PIID_PHRASE);
	flUInt length = strlen(_phrase) + 1;
	_oStream.writeUInt(length);
	_oStream.writeChar(_phrase, length);

	_oStream.writeUShort(PIID_NORMALIZEDORIGIN);
	_oStream.writeFloat(_normalizedOrigin, 2);

	_oStream.writeUShort(PIID_NORMALIZEDSIZE);
	_oStream.writeFloat(_normalizedSize, 2);

	_oStream.writeUShort(PIID_NORMALIZEDPOINTERPOSITION);
	_oStream.writeFloat(_normalizedPointerPosition, 2);

	_oStream.writeUShort(PIID_USERDATA);
	_oStream.writeUInt(_userDataSize);
	_oStream.writeByte(_userData, _userDataSize);

	_changedId = 0;

	_oStream.get((const flChar *&)byteArray, size);
}
//------------------------------------------------------------------------------
void
flPointerInfo::setChanged(const flByte* byteArray, flUInt size)
{
	_changedId = 0;

	_iStream.reset();
	_iStream.set((const flChar *)byteArray, size);

	while(!_iStream.endOfStream())
	{
		flUShort id;
		_iStream.readUShort(id);

		switch(id)
		{
		case PIID_POINTERSHAPE:
			{
				flShort pointerShape;
				_iStream.readShort(pointerShape);
				setPointerShape(pointerShape);
			}
			break;
		case PIID_POINTERCOLOR:
			{
				flByte color[3];
				_iStream.readByte(color, 3);
				setPointerColor(color);
			}
			break;
		case PIID_SCREENSIZE:
			{
				flUShort size[2];
				_iStream.readUShort(size, 2);
				setScreenSize(size[0], size[1]);
			}
			break;
		case PIID_POINTERPOSITION:
			{
				flUShort pos[2];
				_iStream.readUShort(pos, 2);
				setPointerPosition(pos[0], pos[1]);
			}
			break;
		case PIID_BUTTONSTATUS:
			{
				flUShort status;
				_iStream.readUShort(status);
				setButtonStatus(status);
			}
			break;
		case PIID_WHEELSTATUS:
			{
				flUShort status;
				_iStream.readUShort(status);
				setWheelStatus(status);
			}
			break;
		case PIID_DRAWSTATUS:
			{
				flUShort status;
				_iStream.readUShort(status);
				setDrawStatus(status);
			}
			break;
		case PIID_PHRASE:
			{
				flUInt length;
				flChar str[PI_MAXIMUM_PHRASE_LENGTH];
				_iStream.readUInt(length);
				assert(length <= PI_MAXIMUM_PHRASE_LENGTH);
				_iStream.readChar(str, length);
				setPhrase(str);
			}
			break;
		case PIID_NORMALIZEDORIGIN:
			{
				flFloat pos[2];
				_iStream.readFloat(pos, 2);
				setNormalizedOrigin(pos[0], pos[1]);
			}
			break;
		case PIID_NORMALIZEDSIZE:
			{
				flFloat size[2];
				_iStream.readFloat(size, 2);
				setNormalizedSize(size[0], size[1]);
			}
			break;
		case PIID_NORMALIZEDPOINTERPOSITION:
			{
				flFloat pos[2];
				_iStream.readFloat(pos, 2);
				setNormalizedPointerPosition(pos[0], pos[1]);
			}
			break;
		case PIID_USERDATA:
			{
				flUInt size;
				flByte data[PI_MAXIMUM_USERDATA_SIZE];
				_iStream.readUInt(size);
				assert(size <= PI_MAXIMUM_USERDATA_SIZE);
				_iStream.readByte(data, size);
				setUserData(data, size);
			}
			break;
		}
	}
}
//------------------------------------------------------------------------------
void
flPointerInfo::getChanged(const flByte*& byteArray, flUInt& size)
{
	_oStream.reset();

	if (isChanged(PIID_POINTERSHAPE))
	{
		_oStream.writeUShort(PIID_POINTERSHAPE);
		_oStream.writeShort(_pointerShape);
	}
	if (isChanged(PIID_POINTERCOLOR))
	{
		_oStream.writeUShort(PIID_POINTERCOLOR);
		_oStream.writeByte(_pointerColor, 3);
	}
	if (isChanged(PIID_SCREENSIZE))
	{
		_oStream.writeUShort(PIID_SCREENSIZE);
		_oStream.writeUShort(_screenSize, 2);
	}
	if (isChanged(PIID_POINTERPOSITION))
	{
		_oStream.writeUShort(PIID_POINTERPOSITION);
		_oStream.writeUShort(_pointerPosition, 2);
	}
	if (isChanged(PIID_BUTTONSTATUS))
	{
		_oStream.writeUShort(PIID_BUTTONSTATUS);
		_oStream.writeUShort(_buttonStatus);
	}
	if (isChanged(PIID_WHEELSTATUS))
	{
		_oStream.writeUShort(PIID_WHEELSTATUS);
		_oStream.writeUShort(_wheelStatus);
	}
	if (isChanged(PIID_DRAWSTATUS))
	{
		_oStream.writeUShort(PIID_DRAWSTATUS);
		_oStream.writeUShort(_drawStatus);
	}
	if (isChanged(PIID_PHRASE))
	{
		_oStream.writeUShort(PIID_PHRASE);
		flUInt length = strlen(_phrase) + 1;
		_oStream.writeUInt(length);
		_oStream.writeChar(_phrase, length);

	}
	if (isChanged(PIID_NORMALIZEDORIGIN))
	{
		_oStream.writeUShort(PIID_NORMALIZEDORIGIN);
		_oStream.writeFloat(_normalizedOrigin, 2);
	}
	if (isChanged(PIID_NORMALIZEDSIZE))
	{
		_oStream.writeUShort(PIID_NORMALIZEDSIZE);
		_oStream.writeFloat(_normalizedSize, 2);
	}
	if (isChanged(PIID_NORMALIZEDPOINTERPOSITION))
	{
		_oStream.writeUShort(PIID_NORMALIZEDPOINTERPOSITION);
		_oStream.writeFloat(_normalizedPointerPosition, 2);
	}
	if (isChanged(PIID_USERDATA))
	{
		_oStream.writeUShort(PIID_USERDATA);
		_oStream.writeUInt(_userDataSize);
		_oStream.writeByte(_userData, _userDataSize);
	}
	_changedId = 0;

	_oStream.get((const flChar *&)byteArray, size);
}
//------------------------------------------------------------------------------
void
flPointerInfo::setPointerShape(flShort pointerShape)
{
	if (_pointerShape == pointerShape)
		return ;
	_pointerShape = pointerShape;
	_changedId |= PIID_POINTERSHAPE;
}
//------------------------------------------------------------------------------
flShort
flPointerInfo::getPointerShape() const
{
	return _pointerShape;
}
//------------------------------------------------------------------------------
void
flPointerInfo::setPointerColor(const flByte *color)
{
	if (!memcmp(_pointerColor, color, sizeof(_pointerColor)))
		return ;
	memcpy(_pointerColor, color, sizeof(_pointerColor));
	_changedId |= PIID_POINTERCOLOR;
}
//------------------------------------------------------------------------------
const flByte*
flPointerInfo::getPointerColor() const
{
	return _pointerColor;
}
//------------------------------------------------------------------------------
void
flPointerInfo::setScreenSize(flUShort width, flUShort height)
{
	if (_screenSize[0] == width && _screenSize[1] == height)
		return ;
	_screenSize[0] = width;
	_screenSize[1] = height;
	_changedId |= PIID_SCREENSIZE;
}
//------------------------------------------------------------------------------
void
flPointerInfo::getScreenSize(flUShort&width, flUShort&height) const
{
	width = _screenSize[0];
	height = _screenSize[1];
}
//------------------------------------------------------------------------------
void
flPointerInfo::setPointerPosition(flUShort x, flUShort y)
{
	if (_pointerPosition[0] == x && _pointerPosition[1] == y)
		return ;
	_pointerPosition[0] = x;
	_pointerPosition[1] = y;
	_changedId |= PIID_POINTERPOSITION;
}
//------------------------------------------------------------------------------
void
flPointerInfo::getPointerPosition(flUShort&x, flUShort&y) const
{
	x = _pointerPosition[0];
	y = _pointerPosition[1];
}
//------------------------------------------------------------------------------
void
flPointerInfo::setButtonStatus(flUShort status)
{
	if (_buttonStatus == status)
		return ;
	_buttonStatus = status;
	_changedId |= PIID_BUTTONSTATUS;
}
//------------------------------------------------------------------------------
flUShort
flPointerInfo::getButtonStatus() const
{
	return _buttonStatus;
}
//------------------------------------------------------------------------------
void
flPointerInfo::setWheelStatus(flUShort status)
{
	if (_wheelStatus == status)
		return ;
	_wheelStatus = status;
	_changedId |= PIID_WHEELSTATUS;
}
//------------------------------------------------------------------------------
flUShort
flPointerInfo::getWheelStatus() const
{
	return _wheelStatus;
}
//------------------------------------------------------------------------------
void
flPointerInfo::setDrawStatus(flUShort status)
{
	if (_drawStatus == status)
		return ;
	_drawStatus = status;
	_changedId |= PIID_DRAWSTATUS;
}
//------------------------------------------------------------------------------
flUShort
flPointerInfo::getDrawStatus() const
{
	return _drawStatus;
}
//------------------------------------------------------------------------------
void
flPointerInfo::setPhrase(const flChar* phrase)
{
	if (phrase == NULL)
		return ;
	if (!strcmp(_phrase, phrase))
		return ;
	strncpy(_phrase, phrase, PI_MAXIMUM_PHRASE_LENGTH);
	_phrase[PI_MAXIMUM_PHRASE_LENGTH - 1] = 0;
	_changedId |= PIID_PHRASE;
}
//------------------------------------------------------------------------------
const flChar*
flPointerInfo::getPhrase() const
{
	return _phrase;
}
//------------------------------------------------------------------------------
void
flPointerInfo::setNormalizedOrigin(flFloat ox, flFloat oy)
{
	if (_normalizedOrigin[0] == ox && _normalizedOrigin[1] == oy)
		return ;
	_normalizedOrigin[0] = ox;
	_normalizedOrigin[1] = oy;
	_changedId |= PIID_NORMALIZEDORIGIN;
}
//------------------------------------------------------------------------------
void
flPointerInfo::getNormalizedOrigin(flFloat&ox, flFloat&oy) const
{
	ox = _normalizedOrigin[0];
	oy = _normalizedOrigin[1];
}
//------------------------------------------------------------------------------
void
flPointerInfo::setNormalizedSize(flFloat ow, flFloat oh)
{
	if (_normalizedSize[0] == ow && _normalizedSize[1] == oh)
		return ;
	_normalizedSize[0] = ow;
	_normalizedSize[1] = oh;
	_changedId |= PIID_NORMALIZEDSIZE;
}
//------------------------------------------------------------------------------
void
flPointerInfo::getNormalizedSize(flFloat&ow, flFloat&oh) const
{
	ow = _normalizedSize[0];
	oh = _normalizedSize[1];
}
//------------------------------------------------------------------------------
void
flPointerInfo::setNormalizedPointerPosition(flFloat cx, flFloat cy)
{
	if (_normalizedPointerPosition[0] == cx &&
		_normalizedPointerPosition[1] == cy)
		return ;
	_normalizedPointerPosition[0] = cx;
	_normalizedPointerPosition[1] = cy;
	_changedId |= PIID_NORMALIZEDPOINTERPOSITION;
}
//------------------------------------------------------------------------------
void
flPointerInfo::getNormalizedPointerPosition(flFloat&cx, flFloat&cy) const
{
	cx = _normalizedPointerPosition[0];
	cy = _normalizedPointerPosition[1];
}
//------------------------------------------------------------------------------
void
flPointerInfo::setUserData(const flByte* userData, flUInt size)
{
	if (_userDataSize == size && !memcmp(_userData, userData, size))
		return ;
	if (PI_MAXIMUM_USERDATA_SIZE < size)
		size = PI_MAXIMUM_USERDATA_SIZE;
	_userDataSize = size;
	memcpy(_userData, userData, size);
	_changedId |= PIID_USERDATA;
}
//------------------------------------------------------------------------------
void
flPointerInfo::getUserData(const flByte*& userData, flUInt& size) const
{
	userData = _userData;
	size = _userDataSize;
}
//------------------------------------------------------------------------------
// Draw Status Access Function
void
flPointerInfo::setDrawStatusDrawLocusOn(flBool flag)
{
	flBool oldFlag;
	PI_GETDRAWLOCUSON(_drawStatus, oldFlag);
	if (oldFlag == flag)
		return ;
	PI_SETDRAWLOCUSON(_drawStatus, flag);
	_changedId |= PIID_DRAWSTATUS;
}
//------------------------------------------------------------------------------
flBool
flPointerInfo::getDrawStatusDrawLocusOn() const
{
	flBool flag;
	PI_GETDRAWLOCUSON(_drawStatus, flag);
	return flag;
}
//------------------------------------------------------------------------------
void
flPointerInfo::setDrawStatusShowPhraseOn(flBool flag)
{
	flBool oldFlag;
	PI_GETSHOWPHRASEON(_drawStatus, oldFlag);
	if (oldFlag == flag)
		return ;
	PI_SETSHOWPHRASEON(_drawStatus, flag);
	_changedId |= PIID_DRAWSTATUS;
}
//------------------------------------------------------------------------------
flBool
flPointerInfo::getDrawStatusShowPhraseOn() const
{
	flBool flag;
	PI_GETSHOWPHRASEON(_drawStatus, flag);
	return flag;
}
//------------------------------------------------------------------------------
void
flPointerInfo::setDrawStatusDrawLocus(flBool flag)
{
	flBool oldFlag;
	PI_GETDRAWLOCUS(_drawStatus, oldFlag);
	if (oldFlag == flag)
		return ;
	PI_SETDRAWLOCUS(_drawStatus, flag);
	_changedId |= PIID_DRAWSTATUS;
}
//------------------------------------------------------------------------------
flBool
flPointerInfo::getDrawStatusDrawLocus() const
{
	flBool flag;
	PI_GETDRAWLOCUS(_drawStatus, flag);
	return flag;
}
//------------------------------------------------------------------------------
void
flPointerInfo::setDrawStatusEraseLocus(flBool flag)
{
	flBool oldFlag;
	PI_GETERASELOCUS(_drawStatus, oldFlag);
	if (oldFlag == flag)
		return ;
	PI_SETERASELOCUS(_drawStatus, flag);
	_changedId |= PIID_DRAWSTATUS;
}
//------------------------------------------------------------------------------
flBool
flPointerInfo::getDrawStatusEraseLocus() const
{
	flBool flag;
	PI_GETERASELOCUS(_drawStatus, flag);
	return flag;
}
//------------------------------------------------------------------------------
void
flPointerInfo::setDrawStatusShowPhrase(flBool flag)
{
	flBool oldFlag;
	PI_GETSHOWPHRASE(_drawStatus, oldFlag);
	if (oldFlag == flag)
		return ;
	PI_SETSHOWPHRASE(_drawStatus, flag);
	_changedId |= PIID_DRAWSTATUS;
}
//------------------------------------------------------------------------------
flBool
flPointerInfo::getDrawStatusShowPhrase() const
{
	flBool flag;
	PI_GETSHOWPHRASE(_drawStatus, flag);
	return flag;
}
//------------------------------------------------------------------------------
void
flPointerInfo::setDrawStatusLocusEdgingOn(flBool flag)
{
	flBool oldFlag;
	PI_GETEDGINGON(_drawStatus, oldFlag);
	if (oldFlag == flag)
		return ;
	PI_SETEDGINGON(_drawStatus, flag);
	_changedId |= PIID_DRAWSTATUS;
}
//------------------------------------------------------------------------------
flBool
flPointerInfo::getDrawStatusLocusEdgingOn() const
{
	flBool flag;
	PI_GETEDGINGON(_drawStatus, flag);
	return flag;
}
//------------------------------------------------------------------------------
void
flPointerInfo::setDrawStatusLocusBrokenLineOn(flBool flag)
{
	flBool oldFlag;
	PI_GETBROKENLINEON(_drawStatus, oldFlag);
	if (oldFlag == flag)
		return ;
	PI_SETBROKENLINEON(_drawStatus, flag);
	_changedId |= PIID_DRAWSTATUS;
}
//------------------------------------------------------------------------------
flBool
flPointerInfo::getDrawStatusLocusBrokenLineOn() const
{
	flBool flag;
	PI_GETBROKENLINEON(_drawStatus, flag);
	return flag;
}
//------------------------------------------------------------------------------
void
flPointerInfo::setDrawStatusLocusWidth(flUInt width)
{
	flUInt oldWidth;
	PI_GETLOCUSWIDTH(_drawStatus, oldWidth);
	if (oldWidth == width)
		return ;
	PI_SETLOCUSWIDTH(_drawStatus, width);
	_changedId |= PIID_DRAWSTATUS;
}
//------------------------------------------------------------------------------
flUInt
flPointerInfo::getDrawStatusLocusWidth() const
{
	flUInt width;
	PI_GETLOCUSWIDTH(_drawStatus, width);
	return width;
}
//------------------------------------------------------------------------------
