/*
**	Copyright (c) 2003-2004 National Institute of Multimedia Education. All rights reserved.
**	2-12 Wakaba, Mihama, Chiba, 261-0014 JAPAN
**	http://www.nime.ac.jp/
*/
//------------------------------------------------------------------------------
#ifndef __flPointerInfo_h__
#define __flPointerInfo_h__
//------------------------------------------------------------------------------
#include <flTypes/PointerInfo.h>
#include <flBase/flByteStream.h>
#include <flBase/flBase.h>
//------------------------------------------------------------------------------
#pragma pack(push, for_pack_1)
#pragma pack(1)
//------------------------------------------------------------------------------
class flPointerInfo
{
public:
	flPointerInfo();
	~flPointerInfo();

public:
	flPointerInfo&	operator=(const flPointerInfo& pointerInfo);

public:
	void			get(const flByte*& byteArray, flUInt& size);

public:
	void			setChanged(const flByte* byteArray, flUInt size);
	void			getChanged(const flByte*& byteArray, flUInt& size);

	void			resetChanged();
	flBool			isChanged(flUShort id = PIID_ALL) const;

public:
	void			setPointerShape(flShort pointerShape);
	flShort			getPointerShape() const;

	void			setPointerColor(const flByte* color);
	const flByte*	getPointerColor() const;

	void			setScreenSize(flUShort width, flUShort height);
	void			getScreenSize(flUShort&width, flUShort&height) const;

	void			setPointerPosition(flUShort x, flUShort y);
	void			getPointerPosition(flUShort&x, flUShort&y) const;

	void			setButtonStatus(flUShort status);
	flUShort		getButtonStatus() const;

	void			setWheelStatus(flUShort status);
	flUShort		getWheelStatus() const;

	void			setDrawStatus(flUShort status);
	flUShort		getDrawStatus() const;

	void			setPhrase(const flChar* phrase);
	const flChar*	getPhrase() const;

	void			setNormalizedOrigin(flFloat ox, flFloat oy);
	void			getNormalizedOrigin(flFloat&ox, flFloat&oy) const;

	void			setNormalizedSize(flFloat ow, flFloat oh);
	void			getNormalizedSize(flFloat&ow, flFloat&oh) const;

	void			setNormalizedPointerPosition(flFloat cx, flFloat cy);
	void			getNormalizedPointerPosition(flFloat&cx, flFloat&cy) const;

	void			setUserData(const flByte* userData, flUInt size);
	void			getUserData(const flByte*& userData, flUInt& size) const;

public:
	// Draw Status Access Function
	void			setDrawStatusDrawLocusOn(flBool flag);
	flBool			getDrawStatusDrawLocusOn() const;
	void			setDrawStatusShowPhraseOn(flBool flag);
	flBool			getDrawStatusShowPhraseOn() const;
	void			setDrawStatusDrawLocus(flBool flag);
	flBool			getDrawStatusDrawLocus() const;
	void			setDrawStatusEraseLocus(flBool flag);
	flBool			getDrawStatusEraseLocus() const;
	void			setDrawStatusShowPhrase(flBool flag);
	flBool			getDrawStatusShowPhrase() const;
	void			setDrawStatusLocusEdgingOn(flBool flag);
	flBool			getDrawStatusLocusEdgingOn() const;
	void			setDrawStatusLocusBrokenLineOn(flBool flag);
	flBool			getDrawStatusLocusBrokenLineOn() const;
	void			setDrawStatusLocusWidth(flUInt width);
	flUInt			getDrawStatusLocusWidth() const;

private:
	flUShort			_changedId;

	flShort				_pointerShape;
	flByte				_pointerColor[3];
	flUShort			_screenSize[2];
	flUShort			_pointerPosition[2];
	flUShort			_buttonStatus;
	flUShort			_wheelStatus;
	flUShort			_drawStatus;
	flChar				_phrase[PI_MAXIMUM_PHRASE_LENGTH];
	flFloat				_normalizedOrigin[2];
	flFloat				_normalizedSize[2];
	flFloat				_normalizedPointerPosition[2];
	flUInt				_userDataSize;
	flByte				_userData[PI_MAXIMUM_USERDATA_SIZE];

private:
	flOutputByteStream	_oStream;
	flInputByteStream	_iStream;
};
//------------------------------------------------------------------------------
#include <flFilterCommon/flPointerInfo.inl>
//------------------------------------------------------------------------------
#pragma pack(pop, for_pack_1)
//------------------------------------------------------------------------------
#endif //__flPointerInfo_h__
//------------------------------------------------------------------------------
