/*
**	Copyright (c) 2003-2004 National Institute of Multimedia Education. All rights reserved.
**	2-12 Wakaba, Mihama, Chiba, 261-0014 JAPAN
**	http://www.nime.ac.jp/
*/
//------------------------------------------------------------------------------
#include "Stdafx.h"

#define WIN32_LEAN_AND_MEAN
#include <windows.h>
#include <streams.h>

#include <flFilterCommon/flSource.h>
#include <flFilterCommon/flSourceStream.h>
//------------------------------------------------------------------------------
CFLSource::CFLSource(TCHAR *pName, LPUNKNOWN lpunk, CLSID clsid)
: CBaseFilter(pName, lpunk, &_stateLock, clsid)
{
	_numPins	= 0;
	_streams	= NULL;
}
//------------------------------------------------------------------------------
CFLSource::CFLSource(TCHAR *pName, LPUNKNOWN lpunk, CLSID clsid, HRESULT *phr)
: CBaseFilter(pName, lpunk, &_stateLock, clsid)
{
	UNREFERENCED_PARAMETER(phr);
	_numPins	= 0;
	_streams	= NULL;
}
//------------------------------------------------------------------------------
CFLSource::~CFLSource()
{
	/*  Free our pins and pin array */
	while (_numPins != 0)
	{
		// deleting the pins causes them to be removed from the array...
		delete _streams[_numPins - 1];
	}

	ASSERT(_streams == NULL);
}
//------------------------------------------------------------------------------
HRESULT
CFLSource::AddPin(CFLSourceStream *pStream)
{
	CAutoLock lock(&_stateLock);

	/*  Allocate space for this pin and the old ones */
	CFLSourceStream **streams = new CFLSourceStream *[_numPins + 1];
	if (streams == NULL)
		return E_OUTOFMEMORY;

	if (_streams != NULL)
	{
		CopyMemory((PVOID)streams, (PVOID)_streams,
					_numPins * sizeof(_streams[0]));
		streams[_numPins] = pStream;
		delete [] _streams;
	}
	_streams = streams;
	_streams[_numPins] = pStream;
	_numPins++;
	
	return S_OK;
}
//------------------------------------------------------------------------------
HRESULT
CFLSource::RemovePin(CFLSourceStream *pStream)
{
	flInt i;
	for (i = 0; i < _numPins; i++)
	{
		if (_streams[i] == pStream)
		{
			if (_numPins == 1)
			{
				delete [] _streams;
				_streams = NULL;
			}
			else
			{
				/*  no need to reallocate */
				while (++i < _numPins)
				_streams[i - 1] = _streams[i];
			}
			_numPins--;
			return S_OK;
		}
	}
	return S_FALSE;
}
//------------------------------------------------------------------------------
STDMETHODIMP
CFLSource::FindPin(LPCWSTR Id, IPin **ppPin)
{
	CheckPointer(ppPin, E_POINTER);
	ValidateReadWritePtr(ppPin, sizeof(IPin *));

	// The -1 undoes the +1 in QueryId and ensures that totally invalid
	// strings (for which WstrToInt delivers 0) give a deliver a NULL pin.
	flInt i = WstrToInt(Id) -1;
	*ppPin = GetPin(i);
	if (*ppPin != NULL)
	{
		(*ppPin)->AddRef();
		return NOERROR;
	}
	else
	{
		return VFW_E_NOT_FOUND;
	}
}
//------------------------------------------------------------------------------
flInt
CFLSource::FindPinNumber(IPin *iPin)
{
	flInt i;
	for (i = 0; i < _numPins; ++i)
	{
		if ((IPin *)(_streams[i]) == iPin)
			return i;
	}
	return -1;
}
//------------------------------------------------------------------------------
int 
CFLSource::GetPinCount(void)
{
	CAutoLock lock(&_stateLock);
	return _numPins;
}
//------------------------------------------------------------------------------
CBasePin 
*CFLSource::GetPin(int n)
{
	CAutoLock lock(&_stateLock);

	// n must be in the range 0.._numPins-1
	// if _numPins>n  && n>=0 it follows that _numPins>0
	// which is what used to be checked (i.e. checking that we have a pin)
	if ((n >= 0) && (n < _numPins))
	{
		ASSERT(_streams[n]);
		return _streams[n];
	}
	return NULL;
}
//------------------------------------------------------------------------------
