/*
**	Copyright (c) 2003-2004 National Institute of Multimedia Education. All rights reserved.
**	2-12 Wakaba, Mihama, Chiba, 261-0014 JAPAN
**	http://www.nime.ac.jp/
*/
//------------------------------------------------------------------------------
#ifndef __flSource_h__
#define __flSource_h__
//------------------------------------------------------------------------------
#include <flBase/flBase.h>
//------------------------------------------------------------------------------
class CFLSourceStream;
//------------------------------------------------------------------------------
class CFLSource : public CBaseFilter
{

public:
	CFLSource(TCHAR *pName, LPUNKNOWN lpunk, CLSID clsid, HRESULT *phr);
	CFLSource(TCHAR *pName, LPUNKNOWN lpunk, CLSID clsid);
	~CFLSource();

	int				GetPinCount(void);
	CBasePin*		GetPin(int n);

	CCritSec*		pStateLock(void) { return &_stateLock; }

	HRESULT			AddPin(CFLSourceStream *);
	HRESULT			RemovePin(CFLSourceStream *);

	STDMETHODIMP	FindPin(LPCWSTR Id, IPin ** ppPin);
	flInt			FindPinNumber(IPin *iPin);

protected:
	flInt				_numPins;
	CFLSourceStream**	_streams;

	CCritSec			_stateLock;
};
//------------------------------------------------------------------------------
#endif //__flSource_h__
