/*
**	Copyright (c) 2003-2004 National Institute of Multimedia Education. All rights reserved.
**	2-12 Wakaba, Mihama, Chiba, 261-0014 JAPAN
**	http://www.nime.ac.jp/
*/
//------------------------------------------------------------------------------
#ifndef __flSourceStream_h__
#define __flSourceStream_h__
//------------------------------------------------------------------------------
#include <flBase/flBase.h>
//------------------------------------------------------------------------------
class flAbsoluteTime;
class CFLSource;
//------------------------------------------------------------------------------
class CFLSourceStream : public CAMThread, public CBaseOutputPin
{
public:
	CFLSourceStream(TCHAR *pObjectName,
					HRESULT *phr,
					CFLSource *source,
					LPCWSTR pName);
	virtual ~CFLSourceStream(void);

protected:
	virtual HRESULT	FillBuffer(IMediaSample *pSamp) PURE;
	virtual void	AdjustRate(flInt64 deliverProcTime) {};

protected:
	virtual HRESULT OnThreadCreate(void) {return NOERROR;};
	virtual HRESULT OnThreadDestroy(void) {return NOERROR;};
	virtual HRESULT OnThreadStartPlay(void) {return NOERROR;};

	HRESULT			Active(void);
	HRESULT			Inactive(void);

public:
	enum Command {
		CMD_INIT,
		CMD_PAUSE,
		CMD_RUN,
		CMD_STOP,
		CMD_EXIT
	};
	HRESULT			Init(void) { return CallWorker(CMD_INIT); }
	HRESULT			Exit(void) { return CallWorker(CMD_EXIT); }
	HRESULT			Run(void) { return CallWorker(CMD_RUN); }
	HRESULT			Pause(void) { return CallWorker(CMD_PAUSE); }
	HRESULT			Stop(void) { return CallWorker(CMD_STOP); }

protected:
	Command			GetRequest(void) { return (Command) CAMThread::GetRequest(); }
	BOOL			CheckRequest(Command *pCom) { return CAMThread::CheckRequest( (DWORD *) pCom); }

	virtual DWORD	ThreadProc(void);
	virtual HRESULT	DoBufferProcessingLoop(void);

	virtual HRESULT CheckMediaType(const CMediaType *pMediaType);
	virtual HRESULT GetMediaType(int iPosition, CMediaType *pMediaType);

	virtual HRESULT GetMediaType(CMediaType *pMediaType) { return E_UNEXPECTED; }

	STDMETHODIMP	QueryId(LPWSTR * Id);

protected:
	CFLSource*		_source;
	flAbsoluteTime*	_absTime;
};
//------------------------------------------------------------------------------
#endif //__flSourceStream_h__
