/*
**	Copyright (c) 2003-2004 National Institute of Multimedia Education. All rights reserved.
**	2-12 Wakaba, Mihama, Chiba, 261-0014 JAPAN
**	http://www.nime.ac.jp/
*/
//------------------------------------------------------------------------------
#include "Stdafx.h"
#include <flFilterCommon/flTextDraw.h>
//------------------------------------------------------------------------------
#define BACKGROUND_COLOR	RGB(255, 0, 255)
#define FOREGROUND_COLOR	RGB(255, 255, 255)
#define BASE_COLOR			RGB(0, 0, 0)
//------------------------------------------------------------------------------
flTextDraw::flTextDraw(flUInt videoWidth, flUInt videoHeight) :
flShapeDraw(videoWidth, videoHeight)
{
	_text				= "";
	_textAreaWidth		= 200;
	_textAreaHeight		= 64;
	_textFontSize		= 16;
	_textAlign			= TDTA_LEFT;
	_textBorderOn		= true;

	_positionX			= 0;
	_positionY			= 0;
	_color[0]			= 0xff;
	_color[1]			= 0xff;
	_color[2]			= 0xff;

	_textBits			= NULL;
}
//------------------------------------------------------------------------------
flTextDraw::flTextDraw() :
flShapeDraw()
{
	_text				= "";
	_textAreaWidth		= 200;
	_textAreaHeight		= 64;
	_textFontSize		= 16;
	_textAlign			= TDTA_LEFT;
	_textBorderOn		= true;

	_positionX			= 0;
	_positionY			= 0;
	_color[0]			= 0xff;
	_color[1]			= 0xff;
	_color[2]			= 0xff;

	_textBits			= NULL;
}
//------------------------------------------------------------------------------
flTextDraw::~flTextDraw()
{
	delete _textBits;
}
//------------------------------------------------------------------------------
void
flTextDraw::draw(flByte* data)
{
	const flByte BACKGROUND_PIXEL[3] = {
		GetRValue(BACKGROUND_COLOR),
		GetGValue(BACKGROUND_COLOR),
		GetBValue(BACKGROUND_COLOR)
	};

	if (_textBits == NULL)
		return ;

	// Calculate Actual Pointer Coordinate
	flInt x = _positionX;
	flInt y = _positionY;
	y = -y + _videoHeight - _textAreaHeight;


	flByte pixel[3];
	flInt ix, jy;

	for(flInt i = 0; i < (flInt)_textAreaWidth; i++)
	{
		ix = x + i;
		if (ix < 0 || (flInt)_videoWidth <= ix)
			continue;

		for(flInt j = 0; j < (flInt)_textAreaHeight; j++)
		{
			jy = y + j;
			if (jy < 0 || (flInt)_videoHeight <= jy)
				continue;

			CopyMemory(pixel, _textBits + i * 3 + j * _textAreaWidth * 3, 3);
			if (!memcmp(pixel, BACKGROUND_PIXEL, 3))
				continue;

			pixel[0] &= _color[2];
			pixel[1] &= _color[1];
			pixel[2] &= _color[0];

			CopyMemory(data + ix * 3 + jy * _videoWidth * 3, pixel, 3);
		}
	}
}
//------------------------------------------------------------------------------
const flString&
flTextDraw::getText() const
{
	return _text;
}
//------------------------------------------------------------------------------
void
flTextDraw::setText(const flString& text)
{
	if ((_text == text) ||
		(_text.length() == 0 && text.length() == 0))
		return ;

	_text = text;
	createTextBits();
}
//------------------------------------------------------------------------------
void
flTextDraw::getTextArea(flUInt& width, flUInt& height) const
{
	width = _textAreaWidth;
	height = _textAreaHeight;
}
//------------------------------------------------------------------------------
void
flTextDraw::setTextArea(flUInt width, flUInt height)
{
	if (_textAreaWidth == width && _textAreaHeight == height)
		return ;
	_textAreaWidth = width;
	_textAreaHeight = height;
	createTextBits();
}
//------------------------------------------------------------------------------
flUInt
flTextDraw::getTextFontSize() const
{
	return _textFontSize;
}
//------------------------------------------------------------------------------
void
flTextDraw::setTextFontSize(flUInt size)
{
	if (_textFontSize == size)
		return ;
	_textFontSize = size;
	createTextBits();
}
//------------------------------------------------------------------------------
flInt
flTextDraw::getTextAlign() const
{
	return _textAlign;
}
//------------------------------------------------------------------------------
void
flTextDraw::setTextAlign(flInt align)
{
	if (_textAlign == align)
		return ;
	_textAlign = align;
	createTextBits();
}
//------------------------------------------------------------------------------
void
flTextDraw::setTextBorderOn(flBool flag)
{
	if (_textBorderOn == flag)
		return ;
	_textBorderOn = flag;
	createTextBits();
}
//------------------------------------------------------------------------------
flBool
flTextDraw::getTextBorderOn() const
{
	return _textBorderOn;
}
//------------------------------------------------------------------------------
void
flTextDraw::getPosition(flInt& x, flInt& y) const
{
	x = _positionX;
	y = _positionY;
}
//------------------------------------------------------------------------------
void
flTextDraw::setPosition(flInt x, flInt y)
{
	_positionX = x;
	_positionY = y;
}
//------------------------------------------------------------------------------
const flByte*
flTextDraw::getColor() const
{
	return _color;
}
//------------------------------------------------------------------------------
void
flTextDraw::setColor(const flByte* color)
{
	memcpy(_color, color, sizeof(_color));
}
//------------------------------------------------------------------------------
void
flTextDraw::createTextBits()
{
	if (_text.length() == 0)
	{
		delete _textBits;
		_textBits = NULL;
		return ;
	}

/////////// Draw

	// Create DC
	HDC hdc = CreateDC("DISPLAY", NULL, NULL, NULL);
	HDC memDC = CreateCompatibleDC(hdc);

	// Create Objects
	HBITMAP bitmap = CreateCompatibleBitmap(hdc, _textAreaWidth, _textAreaHeight);
	HFONT font = CreateFont(_textFontSize, 0, 0, 0, FW_MEDIUM, FALSE, FALSE, FALSE,
							DEFAULT_CHARSET, OUT_DEFAULT_PRECIS, CLIP_DEFAULT_PRECIS, 
							DEFAULT_QUALITY, DEFAULT_PITCH | FF_DONTCARE, NULL);
	HBRUSH brush = CreateSolidBrush(BACKGROUND_COLOR);

	HGDIOBJ oldBitmap = SelectObject(memDC, bitmap);
	HGDIOBJ oldBrush = SelectObject(memDC, brush);
    HGDIOBJ oldFont = SelectObject(memDC, font);

	RECT rect, trect;
	SetRect(&rect, 0, 0, _textAreaWidth, _textAreaHeight);

	// Draw Background
	FillRect(memDC, &rect, brush);

	flInt align;
	switch(_textAlign)
	{
	case TDTA_LEFT:		align = DT_LEFT;	break;
	case TDTA_CENTER:	align = DT_CENTER;	break;
	case TDTA_RIGHT:	align = DT_RIGHT;	break;
	default:			align = DT_LEFT;	break;
	}

	// Draw Border Text
	SetBkMode(memDC, TRANSPARENT);

	if (_textBorderOn)
	{
		SetTextColor(memDC, BASE_COLOR);
		for(flInt i = 0; i <= 2; i++)
		{
			for(flInt j = 0; j <= 2; j++)
			{
				SetRect(&trect, rect.left + i, rect.top + j, rect.right + i, rect.bottom + j);
				DrawText(memDC, _text.c_str(), _text.length(), &trect, DT_WORDBREAK | align);
			}
		}
	}

	// Draw Foreground Text
	SetTextColor(memDC, FOREGROUND_COLOR);
	SetRect(&trect, rect.left + 1, rect.top + 1, rect.right + 1, rect.bottom + 1);
	DrawText(memDC, _text.c_str(), _text.length(), &trect, DT_WORDBREAK | align);

	SelectObject(memDC, oldBrush);
	SelectObject(memDC, oldBitmap);
    SelectObject(memDC, oldFont);

/////////// Create Bitmap

	BITMAPINFO bitmapInfo;
	memset(&bitmapInfo, 0, sizeof(BITMAPINFO));

	bitmapInfo.bmiHeader.biSize				= sizeof(BITMAPINFOHEADER);
	bitmapInfo.bmiHeader.biWidth			= _textAreaWidth;
	bitmapInfo.bmiHeader.biHeight			= _textAreaHeight;
	bitmapInfo.bmiHeader.biPlanes			= 1;
	bitmapInfo.bmiHeader.biBitCount			= 24;
	bitmapInfo.bmiHeader.biCompression		= BI_RGB;
	bitmapInfo.bmiHeader.biSizeImage		= 0;
	bitmapInfo.bmiHeader.biXPelsPerMeter	= 0;
	bitmapInfo.bmiHeader.biYPelsPerMeter	= 0;
	bitmapInfo.bmiHeader.biClrUsed			= 0;
	bitmapInfo.bmiHeader.biClrImportant		= 0;

	delete _textBits;
	_textBits = new flByte[_textAreaWidth * _textAreaHeight * 3];

	GetDIBits(memDC, bitmap, 0, _textAreaHeight, _textBits, &bitmapInfo, DIB_RGB_COLORS);

	// Delete Objects and DC
	DeleteObject(brush);
	DeleteObject(font);
	DeleteObject(bitmap);
	DeleteDC(memDC);
	DeleteDC(hdc);
}
//------------------------------------------------------------------------------
