/*
**	Copyright (c) 2003-2004 National Institute of Multimedia Education. All rights reserved.
**	2-12 Wakaba, Mihama, Chiba, 261-0014 JAPAN
**	http://www.nime.ac.jp/
*/
//------------------------------------------------------------------------------
#ifndef __flTextDraw_h__
#define __flTextDraw_h__
//------------------------------------------------------------------------------
#include <flFilterCommon/flShapeDraw.h>
#include <flBase/flString.h>
#include <flBase/flBase.h>
//------------------------------------------------------------------------------
class flTextDraw : public flShapeDraw
{
public:
	flTextDraw(flUInt videoWidth, flUInt videoHeight);
	flTextDraw();
	virtual ~flTextDraw();

public:
	virtual void	draw(flByte* data);

public:
	const flString&	getText() const;
	void			setText(const flString& text);

	void			getTextArea(flUInt& width, flUInt& height) const;
	void			setTextArea(flUInt width, flUInt height);

	flUInt			getTextFontSize() const;
	void			setTextFontSize(flUInt size);

	enum TextAlignEnum
	{
		TDTA_LEFT,
		TDTA_CENTER,
		TDTA_RIGHT
	};
	flInt			getTextAlign() const;
	void			setTextAlign(flInt align);

	void			setTextBorderOn(flBool flag);
	flBool			getTextBorderOn() const;

public:
	void			getPosition(flInt& x, flInt& y) const;
	void			setPosition(flInt x, flInt y);

	const flByte*	getColor() const;
	void			setColor(const flByte* color);

private:
	void			createTextBits();

protected:
	flString		_text;
	flUInt			_textAreaWidth;
	flUInt			_textAreaHeight;
	flUInt			_textFontSize;
	flInt			_textAlign;
	flBool			_textBorderOn;

	flInt			_positionX;
	flInt			_positionY;
	flByte			_color[3];

	flByte*			_textBits;
};
//------------------------------------------------------------------------------
DECLARE_SAFE_COPYFUNC(flTextDraw);
DECLARE_SAFE_COMPFUNC(flTextDraw);
//------------------------------------------------------------------------------
#endif //__flTextDraw_h__
