/*
**	Copyright (c) 2003-2004 National Institute of Multimedia Education. All rights reserved.
**	2-12 Wakaba, Mihama, Chiba, 261-0014 JAPAN
**	http://www.nime.ac.jp/
*/
//------------------------------------------------------------------------------
#include "Stdafx.h"
#include <streams.h>

#include <string.h>
#include <tchar.h>
#include <stdio.h>
#include <wchar.h>

#include <flFilterCommon/flTextMediaType.h>
//------------------------------------------------------------------------------
flTextMediaType::flTextMediaType(AM_MEDIA_TYPE mt)
: CMediaType(mt)
{
}
//------------------------------------------------------------------------------
void
flTextMediaType::AsText(LPTSTR szType,
                        flUInt iLen)
{
	ASSERT(szType);

	//
	// Convert Majortype to string
	//
	TCHAR szMajorType[100];
	UINT  iMajorType = 100;

	CLSID2String(szMajorType, iMajorType, &majortype);
	szMajorType[99] = 0;

	//
	// Convert Subtype to string
	//
	TCHAR szSubType[100];
	UINT  iSubType = 100;
	CLSID2String(szSubType, iSubType, &subtype);
	szSubType[99] = 0;

	//
	// Convert Format to string
	//
	TCHAR szFormat[300];
	UINT  iFormat = 300;
	Format2String(szFormat, iFormat, FormatType(), Format(), FormatLength());
	szFormat[299] = 0;

	//
	// Obtain the strings preceeding the Major Type, Sub Type and Format.
	//
	_sntprintf(szType, iLen, TEXT("MajorType:%s\nSubType:%s\nFormat:%s\0"),
								szMajorType, szSubType, szFormat);
}
//------------------------------------------------------------------------------
void
flTextMediaType::CLSID2String(LPTSTR szBuffer,
                                UINT iLength,
                                const GUID* pGuid)
{
    ASSERT(szBuffer);
    ASSERT(pGuid);

	_tcscpy(szBuffer, GuidNames[*pGuid]);
}
//------------------------------------------------------------------------------
void 
flTextMediaType::Format2String(LPTSTR szBuffer,
                                UINT iLength,
                                const GUID* pFormatType,
                                BYTE* pFormat,
                                ULONG lFormatLength)
{
    UNREFERENCED_PARAMETER(lFormatLength);
    ASSERT(szBuffer);
    ASSERT(pFormatType);

	//
	// Get the name of the format
	//
	TCHAR szName[50];
	UINT iName = 50;
	CLSID2String(szName, iName, pFormatType);
	szName[49] = 0;

	if (pFormat)
	{
		//
		// Video Format
		//
		if (IsEqualGUID(*pFormatType, FORMAT_VideoInfo) ||
			IsEqualGUID(*pFormatType, FORMAT_MPEGVideo)) 
		{
			VIDEOINFOHEADER * pVideoFormat = (VIDEOINFOHEADER *) pFormat;

			_sntprintf(szBuffer, iLength, TEXT("%4.4hs %dx%d, %d bits\0")
					, (pVideoFormat->bmiHeader.biCompression == 0) ? TEXT("RGB\0") :
							((pVideoFormat->bmiHeader.biCompression == BI_BITFIELDS) ? TEXT("BITF\0") :
								(LPTSTR) &pVideoFormat->bmiHeader.biCompression )
					, pVideoFormat->bmiHeader.biWidth
					, pVideoFormat->bmiHeader.biHeight
					, pVideoFormat->bmiHeader.biBitCount);

			return;
		}

		//
		// Audio Format
		//
		if (IsEqualGUID(*pFormatType, FORMAT_WaveFormatEx)) 
		{
			WAVEFORMATEX *pWaveFormat = (WAVEFORMATEX *) pFormat;

			// !!! use ACM to get format type name?
			_sntprintf(szBuffer, iLength, TEXT("%s: %.3f KHz %d bit %s \0")
					, szName
					, (double) pWaveFormat->nSamplesPerSec / 1000.0
					, pWaveFormat->wBitsPerSample
					, pWaveFormat->nChannels == 1 ? TEXT("mono\0") : TEXT("stereo\0")
					);

			return;
		}
	}

    _sntprintf(szBuffer, iLength, TEXT("%s\0"), szName);
}
//------------------------------------------------------------------------------
