/*
**	Copyright (c) 2003-2004 National Institute of Multimedia Education. All rights reserved.
**	2-12 Wakaba, Mihama, Chiba, 261-0014 JAPAN
**	http://www.nime.ac.jp/
*/
#ifndef __FORMATTRANS_H__
#define __FORMATTRANS_H__

class CFormatTrans : public CTransformNFilter,
		public CPersistStream, 
		public IFormatTrans,
		public ISpecifyPropertyPages
{

public:

    static CUnknown * WINAPI CreateInstance(LPUNKNOWN punk, HRESULT *phr);

	// Reveals IFormatTrans & ISpecifyPropertyPages
    STDMETHODIMP NonDelegatingQueryInterface(REFIID riid, void ** ppv);

    DECLARE_IUNKNOWN;

    HRESULT Transform(IMediaSample *pIn, IMediaSample *pOut);
    HRESULT CheckInputType(const CMediaType *mtIn);
	HRESULT CheckOutputType(const CMediaType *mtOut);

    virtual HRESULT SetMediaType(PIN_DIRECTION direction,const CMediaType *pmt);

	HRESULT GetMediaType(int iPosition, CMediaType *pMediaType);
    HRESULT DecideBufferSize(IMemAllocator *pAlloc,
                             ALLOCATOR_PROPERTIES *pProp);

    // IFormatTrans methods
	STDMETHODIMP get_InputVideoResolution(unsigned int *videoResolution);
	STDMETHODIMP put_InputVideoResolution(unsigned int videoResolution);
	STDMETHODIMP put_DefaultInputVideoResolution(void);
	STDMETHODIMP get_InputVideoColor(unsigned int *videoResolution);
	STDMETHODIMP put_InputVideoColor(unsigned int videoResolution);
	STDMETHODIMP put_DefaultInputVideoColor(void);
	STDMETHODIMP get_OutputVideoResolution(unsigned int *videoResolution);
	STDMETHODIMP put_OutputVideoResolution(unsigned int videoResolution);
	STDMETHODIMP put_DefaultOutputVideoResolution(void);
	STDMETHODIMP get_ActualInputVideoResolution(unsigned int *videoResolution);
	STDMETHODIMP get_ActualInputVideoColor(unsigned int *videoColor);
	STDMETHODIMP get_ActualOutputVideoResolution(unsigned int *videoResolution);


	// IPersistStream
    STDMETHODIMP GetClassID(CLSID *pClsid);
	HRESULT WriteToStream(IStream *pStream);
    HRESULT ReadFromStream(IStream *pStream);
	DWORD GetSoftwareVersion(void);
	int SizeMax ();


    // ISpecifyPropertyPages method
    STDMETHODIMP GetPages(CAUUID *pPages);

private:

    // Constructor
    CFormatTrans(TCHAR *tszName, LPUNKNOWN punk, HRESULT *phr);

	HRESULT ScalingCopy(IMediaSample *pSource, IMediaSample *pDest) const;

    // The number of buffers to request on the output allocator
    const long m_lBufferRequest;

    // Non interface locking critical section
    CCritSec m_FormatTransLock;


private:

	VideoResolutionEnum	_inVR;
	VideoColorEnum		_inVC;

	VideoResolutionEnum	_outVR;

}; // CFormatTrans

#endif
