/*
**	Copyright (c) 2003-2004 National Institute of Multimedia Education. All rights reserved.
**	2-12 Wakaba, Mihama, Chiba, 261-0014 JAPAN
**	http://www.nime.ac.jp/
*/
#include <streams.h>
#include <commctrl.h>
#include <olectl.h>
#include <memory.h>
#include "resource.h"

#include <stdio.h>
#include <stdlib.h>
#include <tchar.h>

#include "transfrmn.h"


#include <flTypes/flUIDs.h>
#include <flTypes/IFormatTrans.h>

#include "formattrans.h"
#include "formattransprop.h"


//
// CreateInstance
//
// This goes in the factory template table to create new filter instances
//
CUnknown * WINAPI CFormatTransProperties::CreateInstance(LPUNKNOWN lpunk, HRESULT *phr)
{
    CUnknown *punk = new CFormatTransProperties(lpunk, phr);
    if (punk == NULL) {
	*phr = E_OUTOFMEMORY;
    }
    return punk;

} // CreateInstance


//
// Constructor
//
CFormatTransProperties::CFormatTransProperties(LPUNKNOWN pUnk, HRESULT *phr) :
    CBasePropertyPage(NAME("FormatTransProp"),pUnk,
                      IDD_FORMATTRANSPROP,
                      IDS_TITLE),
    m_pFormatTrans(NULL)
{
    InitCommonControls();

} // (Constructor)


//
// SetDirty
//
// Sets m_bDirty and notifies the property page site of the change
//
void CFormatTransProperties::SetDirty()
{
    m_bDirty = TRUE;
    if (m_pPageSite) {
        m_pPageSite->OnStatusChange(PROPPAGESTATUS_DIRTY);
    }

} // SetDirty


//
// OnReceiveMessage
//
// Virtual method called by base class with Window messages
//
BOOL CFormatTransProperties::OnReceiveMessage(HWND hwnd,
                                           UINT uMsg,
                                           WPARAM wParam,
                                           LPARAM lParam)
{
    switch (uMsg)
    {
        case WM_INITDIALOG:
        {
			SetupComboBox();
			return (LRESULT) 1;
        }
        case WM_COMMAND:
        {
			switch(LOWORD(wParam))
			{
			case IDB_IN_DEFAULT:
				{
					pIFormatTrans()->put_DefaultInputVideoResolution();
					unsigned int sel;
					pIFormatTrans()->get_InputVideoResolution(&sel);
					ComboBox_SetCurSel(GetDlgItem(m_Dlg, IDC_IN_COMBO), sel);
					SetDirty();
				}
				break;
			case IDB_INC_DEFAULT:
				{
					pIFormatTrans()->put_DefaultInputVideoColor();
					unsigned int sel;
					pIFormatTrans()->get_InputVideoColor(&sel);
					ComboBox_SetCurSel(GetDlgItem(m_Dlg, IDC_INC_COMBO), sel);
					SetDirty();
				}
				break;
			case IDB_OUT_DEFAULT:
				{
					pIFormatTrans()->put_DefaultOutputVideoResolution();
					unsigned int sel;
					pIFormatTrans()->get_OutputVideoResolution(&sel);
					ComboBox_SetCurSel(GetDlgItem(m_Dlg, IDC_OUT_COMBO), sel);
					SetDirty();
				}
				break;
			case IDC_IN_COMBO:
				if (HIWORD(wParam) == CBN_SELCHANGE)
				{
					int sel = ComboBox_GetCurSel(GetDlgItem(m_Dlg, IDC_IN_COMBO));
					pIFormatTrans()->put_InputVideoResolution(sel);
					SetDirty();
				}
				break;
			case IDC_INC_COMBO:
				if (HIWORD(wParam) == CBN_SELCHANGE)
				{
					int sel = ComboBox_GetCurSel(GetDlgItem(m_Dlg, IDC_INC_COMBO));
					pIFormatTrans()->put_InputVideoColor(sel);
					SetDirty();
				}
				break;
			case IDC_OUT_COMBO:
				if (HIWORD(wParam) == CBN_SELCHANGE)
				{
					int sel = ComboBox_GetCurSel(GetDlgItem(m_Dlg, IDC_OUT_COMBO));
					pIFormatTrans()->put_OutputVideoResolution(sel);
					SetDirty();
				}
				break;
			}
			return (LRESULT) 1;
		}
        case WM_DESTROY:
        {
            return (LRESULT) 1;
        }

    }
    return CBasePropertyPage::OnReceiveMessage(hwnd,uMsg,wParam,lParam);

} // OnReceiveMessage


//
// OnConnect
//
// Called when the property page connects to a filter
//
HRESULT CFormatTransProperties::OnConnect(IUnknown *pUnknown)
{
    ASSERT(m_pFormatTrans == NULL);

    HRESULT hr = pUnknown->QueryInterface(IID_IFormatTrans, (void **) &m_pFormatTrans);
    if (FAILED(hr)) {
        return E_NOINTERFACE;
    }

    ASSERT(m_pFormatTrans);

	m_pFormatTrans->get_InputVideoResolution(&m_iInputVideoResolution);
	m_pFormatTrans->get_InputVideoColor(&m_iInputVideoColor);
	m_pFormatTrans->get_OutputVideoResolution(&m_iOutputVideoResolution);
	m_iInputVideoOnExit = m_iInputVideoResolution;
	m_iInputVideoFCOnExit = m_iInputVideoColor;
	m_iOutputVideoOnExit = m_iOutputVideoResolution;

    return NOERROR;

} // OnConnect


//
// OnDisconnect
//
// Called when we're disconnected from a filter
//
HRESULT CFormatTransProperties::OnDisconnect()
{
    if (m_pFormatTrans == NULL) {
        return E_UNEXPECTED;
    }

	m_pFormatTrans->put_InputVideoResolution(m_iInputVideoOnExit);
	m_pFormatTrans->put_InputVideoColor(m_iInputVideoFCOnExit);
	m_pFormatTrans->put_OutputVideoResolution(m_iOutputVideoOnExit);
    m_pFormatTrans->Release();
    m_pFormatTrans = NULL;
    return NOERROR;

} // OnDisconnect


//
// OnDeactivate
//
// We are being deactivated
//
HRESULT CFormatTransProperties::OnDeactivate(void)
{
	pIFormatTrans()->get_InputVideoResolution(&m_iInputVideoResolution);
	pIFormatTrans()->get_InputVideoColor(&m_iInputVideoColor);
	pIFormatTrans()->get_OutputVideoResolution(&m_iOutputVideoResolution);
	return NOERROR;

} // OnDeactivate


//
// OnApplyChanges
//
// Changes made should be kept. Change the m_cFormatTransOnExit variable
//
HRESULT CFormatTransProperties::OnApplyChanges()
{
	pIFormatTrans()->get_InputVideoResolution(&m_iInputVideoOnExit);
	pIFormatTrans()->get_InputVideoColor(&m_iInputVideoFCOnExit);
	pIFormatTrans()->get_OutputVideoResolution(&m_iOutputVideoOnExit);
    m_bDirty = FALSE;
    return(NOERROR);

} // OnApplyChanges

void
CFormatTransProperties::SetupComboBox()
{
	ComboBox_ResetContent(m_Dlg);
	ComboBox_AddString(GetDlgItem(m_Dlg, IDC_IN_COMBO), _T("SQCIF"));
	ComboBox_AddString(GetDlgItem(m_Dlg, IDC_IN_COMBO), _T("QCIF"));
	ComboBox_AddString(GetDlgItem(m_Dlg, IDC_IN_COMBO), _T("CIF"));
	ComboBox_AddString(GetDlgItem(m_Dlg, IDC_IN_COMBO), _T("160x120"));
	ComboBox_AddString(GetDlgItem(m_Dlg, IDC_IN_COMBO), _T("320x240"));
	ComboBox_AddString(GetDlgItem(m_Dlg, IDC_IN_COMBO), _T("360x240"));
	ComboBox_AddString(GetDlgItem(m_Dlg, IDC_IN_COMBO), _T("640x480"));
	ComboBox_AddString(GetDlgItem(m_Dlg, IDC_IN_COMBO), _T("720x480"));
	ComboBox_AddString(GetDlgItem(m_Dlg, IDC_IN_COMBO), _T("800x600"));
	ComboBox_AddString(GetDlgItem(m_Dlg, IDC_IN_COMBO), _T("1024x768"));
	ComboBox_AddString(GetDlgItem(m_Dlg, IDC_IN_COMBO), _T("1280x1024"));
	ComboBox_AddString(GetDlgItem(m_Dlg, IDC_IN_COMBO), _T("1600x1200"));
	ComboBox_AddString(GetDlgItem(m_Dlg, IDC_IN_COMBO), _T("HDTV 720p"));
	ComboBox_AddString(GetDlgItem(m_Dlg, IDC_IN_COMBO), _T("HDTV 1080i"));
	ComboBox_AddString(GetDlgItem(m_Dlg, IDC_IN_COMBO), _T("SDTV 480p"));
	ComboBox_AddString(GetDlgItem(m_Dlg, IDC_IN_COMBO), _T("SDTV 480i"));
	ComboBox_AddString(GetDlgItem(m_Dlg, IDC_IN_COMBO), _T(""));

	ComboBox_AddString(GetDlgItem(m_Dlg, IDC_INC_COMBO), _T("RGB 8"));
	ComboBox_AddString(GetDlgItem(m_Dlg, IDC_INC_COMBO), _T("RGB 555"));
	ComboBox_AddString(GetDlgItem(m_Dlg, IDC_INC_COMBO), _T("RGB 565"));
	ComboBox_AddString(GetDlgItem(m_Dlg, IDC_INC_COMBO), _T("RGB 24"));
	ComboBox_AddString(GetDlgItem(m_Dlg, IDC_INC_COMBO), _T(""));

	ComboBox_AddString(GetDlgItem(m_Dlg, IDC_OUT_COMBO), _T("SQCIF"));
	ComboBox_AddString(GetDlgItem(m_Dlg, IDC_OUT_COMBO), _T("QCIF"));
	ComboBox_AddString(GetDlgItem(m_Dlg, IDC_OUT_COMBO), _T("CIF"));
	ComboBox_AddString(GetDlgItem(m_Dlg, IDC_OUT_COMBO), _T("160x120"));
	ComboBox_AddString(GetDlgItem(m_Dlg, IDC_OUT_COMBO), _T("320x240"));
	ComboBox_AddString(GetDlgItem(m_Dlg, IDC_OUT_COMBO), _T("360x240"));
	ComboBox_AddString(GetDlgItem(m_Dlg, IDC_OUT_COMBO), _T("640x480"));
	ComboBox_AddString(GetDlgItem(m_Dlg, IDC_OUT_COMBO), _T("720x480"));
	ComboBox_AddString(GetDlgItem(m_Dlg, IDC_OUT_COMBO), _T("800x600"));
	ComboBox_AddString(GetDlgItem(m_Dlg, IDC_OUT_COMBO), _T("1024x768"));
	ComboBox_AddString(GetDlgItem(m_Dlg, IDC_OUT_COMBO), _T("1280x1024"));
	ComboBox_AddString(GetDlgItem(m_Dlg, IDC_OUT_COMBO), _T("1600x1200"));
	ComboBox_AddString(GetDlgItem(m_Dlg, IDC_OUT_COMBO), _T("HDTV 720p"));
	ComboBox_AddString(GetDlgItem(m_Dlg, IDC_OUT_COMBO), _T("HDTV 1080i"));
	ComboBox_AddString(GetDlgItem(m_Dlg, IDC_OUT_COMBO), _T("SDTV 480p"));
	ComboBox_AddString(GetDlgItem(m_Dlg, IDC_OUT_COMBO), _T("SDTV 480i"));
	ComboBox_AddString(GetDlgItem(m_Dlg, IDC_OUT_COMBO), _T("X["));

	ComboBox_SetCurSel(GetDlgItem(m_Dlg, IDC_IN_COMBO), m_iInputVideoResolution);
	ComboBox_SetCurSel(GetDlgItem(m_Dlg, IDC_INC_COMBO), m_iInputVideoColor);
	ComboBox_SetCurSel(GetDlgItem(m_Dlg, IDC_OUT_COMBO), m_iOutputVideoResolution);
}
