/*
**	Copyright (c) 2003-2004 National Institute of Multimedia Education. All rights reserved.
**	2-12 Wakaba, Mihama, Chiba, 261-0014 JAPAN
**	http://www.nime.ac.jp/
*/
class CFormatTransProperties : public CBasePropertyPage
{

public:

    static CUnknown * WINAPI CreateInstance(LPUNKNOWN lpunk, HRESULT *phr);

private:

    BOOL	OnReceiveMessage(HWND hwnd,UINT uMsg,WPARAM wParam,LPARAM lParam);
    HRESULT	OnConnect(IUnknown *pUnknown);
    HRESULT	OnDisconnect();
    HRESULT	OnDeactivate();
    HRESULT	OnApplyChanges();

    void	SetDirty();
	void	SetupComboBox();

    CFormatTransProperties(LPUNKNOWN lpunk, HRESULT *phr);
	
	unsigned int m_iInputVideoOnExit;
	unsigned int m_iInputVideoFCOnExit;
	unsigned int m_iOutputVideoOnExit;
	unsigned int m_iInputVideoResolution;
	unsigned int m_iInputVideoColor;
	unsigned int m_iOutputVideoResolution;

    IFormatTrans *m_pFormatTrans;

    IFormatTrans *pIFormatTrans() {
        ASSERT(m_pFormatTrans);
        return m_pFormatTrans;
    };

}; // CFormatTransProperties

