/*
**	Copyright (c) 2003-2004 National Institute of Multimedia Education. All rights reserved.
**	2-12 Wakaba, Mihama, Chiba, 261-0014 JAPAN
**	http://www.nime.ac.jp/
*/
//------------------------------------------------------------------------------
#ifndef __MulticastReceiver_h__
#define __MulticastReceiver_h__
//------------------------------------------------------------------------------
#include <initguid.h>
#include <olectl.h>
#if (1100 > _MSC_VER)
#include <olectlid.h>
#endif

#include <flFilterCommon/flSource.h>
#include <flFilterCommon/flMediaSample.h>
#include <flFilterCommon/flMediaType.h>
#include <flTypes/flUIDs.h>
#include <flTypes/flEventCode.h>
#include <flTypes/IMulticastReceiver.h>
#include <flBase/flByteStream.h>
#include <flBase/flBase.h>
//------------------------------------------------------------------------------
class flFMTReceiver;
class CMulticastReceiverStream;
//------------------------------------------------------------------------------
class CMulticastReceiver :
		public CFLSource,
		public CPersistStream, 
		public ISpecifyPropertyPages,
		public IMulticastReceiver
{
	friend class CMulticastReceiverStream;

public:
    static CUnknown * WINAPI CreateInstance(LPUNKNOWN punk, HRESULT *phr);

    DECLARE_IUNKNOWN;

private:
    CMulticastReceiver(TCHAR *tszName, LPUNKNOWN pUnk, HRESULT *phr);
    ~CMulticastReceiver();

public:
	// Reveals IMulticastReceiver & ISpecifyPropertyPages
    STDMETHODIMP	NonDelegatingQueryInterface(REFIID riid, void ** ppv);

public:
	// IMediaFilter
	STDMETHODIMP	Run(REFERENCE_TIME startTime);
	STDMETHODIMP	Pause();
	STDMETHODIMP	Stop();
	STDMETHODIMP	GetState(DWORD dwMSecs, FILTER_STATE *State);

	// IPersistStream
    STDMETHODIMP	GetClassID(CLSID *pClsid);
	HRESULT			WriteToStream(IStream *pStream);
    HRESULT			ReadFromStream(IStream *pStream);
	DWORD			GetSoftwareVersion(void);
	int				SizeMax();

    // ISpecifyPropertyPages method
    STDMETHODIMP	GetPages(CAUUID *pPages);

	// IMulticastReceiver
	STDMETHODIMP	is_SocketOpen(flBool *flag);
	STDMETHODIMP	is_Streaming(flBool *flag);
	STDMETHODIMP	is_OutputMediaTypeAgreement(flBool *flag);
	STDMETHODIMP	get_AbsoluteTime(flInt64 *absTime);
	STDMETHODIMP	get_ReceiveRate(flUInt *rate);
	STDMETHODIMP	get_FrameRate(flUInt *rate);
	STDMETHODIMP	get_PacketSize(flUInt *byte);
	STDMETHODIMP	get_NumTotalPackets(flUInt *numPackets);
	STDMETHODIMP	get_NumTotalFrames(flUInt *numFrames);
	STDMETHODIMP	get_NumDropPackets(flUInt *numPackets);
	STDMETHODIMP	get_NumDropFrames(flUInt *numFrames);
	STDMETHODIMP	get_NumOverwriteFrames(flUInt *numFrames);
	STDMETHODIMP	get_UserData(flByte *userData, flUInt* size);
	STDMETHODIMP	get_MediaTypeString(flChar *str);
	STDMETHODIMP	get_SenderAddress(flChar *address);
	STDMETHODIMP	get_Address(flChar *address);
	STDMETHODIMP	put_Address(const flChar *address);
	STDMETHODIMP	get_Port(flUShort *port);
	STDMETHODIMP	put_Port(flUShort port);
	STDMETHODIMP	get_TimeToLive(flULong *ttl);
	STDMETHODIMP	put_TimeToLive(flULong ttl);
	STDMETHODIMP	get_NumRejectionAddress(flUInt *num);
	STDMETHODIMP	get_RejectionAddress(flUInt index, flChar *address);
	STDMETHODIMP	add_RejectionAddress(const flChar *address);
	STDMETHODIMP	remove_RejectionAddress(flUInt index);
	STDMETHODIMP	remove_AllRejectionAddress();
	STDMETHODIMP	get_MediaType(flInt *type);
	STDMETHODIMP	put_MediaType(flInt type);
	STDMETHODIMP	get_VideoFormat(flInt *videoFormat);
	STDMETHODIMP	put_VideoFormat(flInt videoFormat);
	STDMETHODIMP	get_VideoResolution(flInt *videoResolution);
	STDMETHODIMP	put_VideoResolution(flInt videoResolution);
	STDMETHODIMP	get_AudioFormat(flInt *audioFormat);
	STDMETHODIMP	put_AudioFormat(flInt audioFormat);
	STDMETHODIMP	get_AudioFrequency(flInt *audioFrequency);
	STDMETHODIMP	put_AudioFrequency(flInt audioFrequency);
	STDMETHODIMP	get_AudioStereo(flInt *audioStereo);
	STDMETHODIMP	put_AudioStereo(flInt audioStereo);
	STDMETHODIMP	get_AudioBitCount(flInt *audioBitCount);
	STDMETHODIMP	put_AudioBitCount(flInt audioBitCount);
	STDMETHODIMP	get_EnableConnectReceiveMediaType(flBool *enable);
	STDMETHODIMP	put_EnableConnectReceiveMediaType(flBool enable);
	STDMETHODIMP	get_TimeStampMode(flInt *mode);
	STDMETHODIMP	put_TimeStampMode(flInt mode);
	STDMETHODIMP	get_VideoImageNormalizedPosition(flFloat *x, flFloat *y);
	STDMETHODIMP	put_VideoImageNormalizedPosition(flFloat x, flFloat y);
	STDMETHODIMP	get_VideoImageNormalizedSize(flFloat *width, flFloat *height);
	STDMETHODIMP	put_VideoImageNormalizedSize(flFloat width, flFloat height);

protected:
	static void __stdcall	receiveProc(flChar* data, flUInt dataSize, void* receiveParam);
	void			receive(flChar* data, flUInt dataSize);

private:
	flMediaSample*	createNewMediaSample(const CMediaType& mediaType, flInputByteStream& iStream);
	void			setupPrerollSamples();
	void			fireMediaTypeChangedEvent();

protected:
	// Ciritcal Section for filter
	CCritSec				_filterLock;

	// FMT Receiver
	flFMTReceiver*			_fmtReceiver;

	// InputByteStream
	flInputByteStream		_iStream;

	// Media Samples
	CCritSec				_receiveSampleLock;
	CCritSec				_prerollSampleLock;
	flMediaSamplePool*		_samplePool;
	flMediaSamples			_receiveSamples;
	flMediaSamples			_prerollSamples;
	flMediaSamples			_changingSamples;

	// Media Type
	flMediaType				_outputMediaType;
	CMediaType				_actualOutputMediaType;
	CMediaType				_receivedMediaType;
	
	// Other variables
	flBool					_isRunning;
	flBool					_isStreaming;
	flBool					_isSameMediaType;
	flInt					_curFrameId;
	flInt					_prevFrameId;
	flInt64					_absTime;
	flUInt					_numOverwriteFrames;
	flUInt					_userDataSize;
	flByte					_userData[MR_MAXIMUM_USERDATA_SIZE];
	CMediaType				_changingMediaType;

	// Property
	flBool					_enableConnectReceiveMediaType;
	flInt					_timeStampMode;
	flFloat					_videoImageNormalizedPositionX;
	flFloat					_videoImageNormalizedPositionY;
	flFloat					_videoImageNormalizedWidth;
	flFloat					_videoImageNormalizedHeight;

protected:
	// Output Stream pin
	CMulticastReceiverStream*	_multicastReceiverStream;
};
//------------------------------------------------------------------------------
#endif //__MulticastReceiver_h__
