/*
**	Copyright (c) 2003-2004 National Institute of Multimedia Education. All rights reserved.
**	2-12 Wakaba, Mihama, Chiba, 261-0014 JAPAN
**	http://www.nime.ac.jp/
*/
//------------------------------------------------------------------------------
#define WIN32_LEAN_AND_MEAN
#include <streams.h>

#include <flMulticastReceiver/MulticastReceiverAddInfoProp.h>
#include <commctrl.h>
#include <tchar.h>
#include "resource.h"
//------------------------------------------------------------------------------
CUnknown * WINAPI
CMulticastReceiverAddInfoProp::CreateInstance(LPUNKNOWN lpunk, HRESULT *phr)
{
    CUnknown *punk = new CMulticastReceiverAddInfoProp(lpunk, phr);
    if (punk == NULL)
	{
		*phr = E_OUTOFMEMORY;
    }
    return punk;
}
//------------------------------------------------------------------------------
CMulticastReceiverAddInfoProp::CMulticastReceiverAddInfoProp(LPUNKNOWN pUnk, HRESULT *phr) :
    CBasePropertyPage(NAME("MulticastReceiverAddInfoProp"),pUnk,
                      IDD_MULTICASTRECEIVERADDINFOPROP,
                      IDS_MULTICASTRECEIVERADDINFOPROPTITLE),
    _multicastReceiver(NULL)
{
    InitCommonControls();
}
//------------------------------------------------------------------------------
void
CMulticastReceiverAddInfoProp::SetDirty()
{
    m_bDirty = TRUE;
    if (m_pPageSite)
	{
        m_pPageSite->OnStatusChange(PROPPAGESTATUS_DIRTY);
    }
}
//------------------------------------------------------------------------------
BOOL
CMulticastReceiverAddInfoProp::OnReceiveMessage(HWND hwnd,
                                           UINT uMsg,
                                           WPARAM wParam,
                                           LPARAM lParam)
{
    switch (uMsg)
    {
        case WM_INITDIALOG:
        {
			setupControls();
			return (LRESULT) 1;
        }
        case WM_COMMAND:
        {
			switch(LOWORD(wParam))
			{
			case IDC_ADDINFO_XAXIS_EDIT:
				if (HIWORD(wParam) == EN_CHANGE)
				{
					TCHAR sz[STR_MAX_LENGTH];
					Edit_GetText(GetDlgItem(m_Dlg, IDC_ADDINFO_XAXIS_EDIT),
													sz, STR_MAX_LENGTH);
					_videoImageNormalizedPositionX = (flFloat)atof(sz);
					SetDirty();
				}
				break;
			case IDC_ADDINFO_YAXIS_EDIT:
				if (HIWORD(wParam) == EN_CHANGE)
				{
					TCHAR sz[STR_MAX_LENGTH];
					Edit_GetText(GetDlgItem(m_Dlg, IDC_ADDINFO_YAXIS_EDIT),
													sz, STR_MAX_LENGTH);
					_videoImageNormalizedPositionY = (flFloat)atof(sz);
					SetDirty();
				}
				break;
			case IDC_ADDINFO_WIDTH_EDIT:
				if (HIWORD(wParam) == EN_CHANGE)
				{
					TCHAR sz[STR_MAX_LENGTH];
					Edit_GetText(GetDlgItem(m_Dlg, IDC_ADDINFO_WIDTH_EDIT),
													sz, STR_MAX_LENGTH);
					_videoImageNormalizedWidth = (flFloat)atof(sz);
					SetDirty();
				}
				break;
			case IDC_ADDINFO_HEIGHT_EDIT:
				if (HIWORD(wParam) == EN_CHANGE)
				{
					TCHAR sz[STR_MAX_LENGTH];
					Edit_GetText(GetDlgItem(m_Dlg, IDC_ADDINFO_HEIGHT_EDIT),
													sz, STR_MAX_LENGTH);
					_videoImageNormalizedHeight = (flFloat)atof(sz);
					SetDirty();
				}
				break;
			}
			return (LRESULT) 1;
		}
        case WM_DESTROY:
        {
			shutdownControls();
            return (LRESULT) 1;
        }
		case WM_TIMER:
		{
			TCHAR userData[MR_MAXIMUM_USERDATA_SIZE + 1];
			flUInt userDataSize;

			_multicastReceiver->get_UserData((flByte *)userData, &userDataSize);
			if (MR_MAXIMUM_USERDATA_SIZE < userDataSize)
				userDataSize = MR_MAXIMUM_USERDATA_SIZE;
			userData[userDataSize] = 0;
			Edit_SetText(GetDlgItem(m_Dlg, IDC_ADDINFO_RECEIVEUSERDATA), userData);

			Sleep(0);

			return (LRESULT) 1;
		}

    }
    return CBasePropertyPage::OnReceiveMessage(hwnd,uMsg,wParam,lParam);
}
//------------------------------------------------------------------------------
HRESULT
CMulticastReceiverAddInfoProp::OnConnect(IUnknown *pUnknown)
{
    ASSERT(_multicastReceiver == NULL);

    HRESULT hr = pUnknown->QueryInterface(IID_IMulticastReceiver, (void **) &_multicastReceiver);
    if (FAILED(hr))
	{
        return E_NOINTERFACE;
    }

    ASSERT(_multicastReceiver);

	_multicastReceiver->get_VideoImageNormalizedPosition(
		&_videoImageNormalizedPositionX, &_videoImageNormalizedPositionY);
	_multicastReceiver->get_VideoImageNormalizedSize(
		&_videoImageNormalizedWidth, &_videoImageNormalizedHeight);

    return NOERROR;
}
//------------------------------------------------------------------------------
HRESULT
CMulticastReceiverAddInfoProp::OnDisconnect()
{
    if (_multicastReceiver == NULL)
	{
        return E_UNEXPECTED;
    }

    _multicastReceiver->Release();
    _multicastReceiver = NULL;

	return NOERROR;
}
//------------------------------------------------------------------------------
HRESULT
CMulticastReceiverAddInfoProp::OnDeactivate(void)
{
	return NOERROR;
}
//------------------------------------------------------------------------------
HRESULT
CMulticastReceiverAddInfoProp::OnApplyChanges()
{
	_multicastReceiver->put_VideoImageNormalizedPosition(
		_videoImageNormalizedPositionX,
		_videoImageNormalizedPositionY);

	_multicastReceiver->put_VideoImageNormalizedSize(
		_videoImageNormalizedWidth, 
		_videoImageNormalizedHeight);

    m_bDirty = FALSE;
    return NOERROR;
}
//------------------------------------------------------------------------------
void
CMulticastReceiverAddInfoProp::setupControls()
{
	// Setup Controls
	TCHAR   sz[32];
	
	_stprintf(sz, "%5.3f", _videoImageNormalizedPositionX);
	Edit_SetText(GetDlgItem(m_Dlg, IDC_ADDINFO_XAXIS_EDIT), sz);

	_stprintf(sz, "%5.3f", _videoImageNormalizedPositionY);
	Edit_SetText(GetDlgItem(m_Dlg, IDC_ADDINFO_YAXIS_EDIT), sz);

	_stprintf(sz, "%5.3f", _videoImageNormalizedWidth);
	Edit_SetText(GetDlgItem(m_Dlg, IDC_ADDINFO_WIDTH_EDIT), sz);

	_stprintf(sz, "%5.3f", _videoImageNormalizedHeight);
	Edit_SetText(GetDlgItem(m_Dlg, IDC_ADDINFO_HEIGHT_EDIT), sz);

	// Setup Timer
	_timer = SetTimer(m_Dlg, 0, 500, NULL);
}
//------------------------------------------------------------------------------
void
CMulticastReceiverAddInfoProp::shutdownControls()
{
	// Shutdown Timer
	KillTimer(m_Dlg, _timer);
}
//------------------------------------------------------------------------------
