/*
**	Copyright (c) 2003-2004 National Institute of Multimedia Education. All rights reserved.
**	2-12 Wakaba, Mihama, Chiba, 261-0014 JAPAN
**	http://www.nime.ac.jp/
*/
//------------------------------------------------------------------------------
#ifndef __MulticastReceiverAddInfoProp_h__
#define __MulticastReceiverAddInfoProp_h__
//------------------------------------------------------------------------------
#include <initguid.h>
#include <olectl.h>
#if (1100 > _MSC_VER)
#include <olectlid.h>
#endif
#include <flTypes/flUIDs.h>
#include <flTypes/IMulticastReceiver.h>
#include <flBase/flBase.h>
//------------------------------------------------------------------------------
class CMulticastReceiverAddInfoProp : public CBasePropertyPage
{

public:
    static CUnknown * WINAPI CreateInstance(LPUNKNOWN lpunk, HRESULT *phr);

private:
    CMulticastReceiverAddInfoProp(LPUNKNOWN lpunk, HRESULT *phr);

private:
    void		SetDirty();

    BOOL		OnReceiveMessage(HWND hwnd,UINT uMsg,WPARAM wParam,LPARAM lParam);
    HRESULT		OnConnect(IUnknown *pUnknown);
    HRESULT		OnDisconnect();
    HRESULT		OnDeactivate();
    HRESULT		OnApplyChanges();

private:
	void		setupControls();
	void		shutdownControls();

private:
    IMulticastReceiver*	_multicastReceiver;
	UINT_PTR			_timer;

	flFloat				_videoImageNormalizedPositionX;
	flFloat				_videoImageNormalizedPositionY;
	flFloat				_videoImageNormalizedWidth;
	flFloat				_videoImageNormalizedHeight;
};
//------------------------------------------------------------------------------
#endif //__MulticastReceiverAddInfoProp_h__
