/*
**	Copyright (c) 2003-2004 National Institute of Multimedia Education. All rights reserved.
**	2-12 Wakaba, Mihama, Chiba, 261-0014 JAPAN
**	http://www.nime.ac.jp/
*/
//------------------------------------------------------------------------------
#define WIN32_LEAN_AND_MEAN
#include <streams.h>

#include <flMulticastReceiver/MulticastReceiverComProp.h>
#include <commctrl.h>
#include <tchar.h>
#include "resource.h"
//------------------------------------------------------------------------------
CUnknown * WINAPI
CMulticastReceiverComProp::CreateInstance(LPUNKNOWN lpunk, HRESULT *phr)
{
    CUnknown *punk = new CMulticastReceiverComProp(lpunk, phr);
    if (punk == NULL)
	{
		*phr = E_OUTOFMEMORY;
    }
    return punk;
}
//------------------------------------------------------------------------------
CMulticastReceiverComProp::CMulticastReceiverComProp(LPUNKNOWN pUnk, HRESULT *phr) :
    CBasePropertyPage(NAME("MulticastReceiverComProp"),pUnk,
                      IDD_MULTICASTRECEIVERCOMPROP,
                      IDS_MULTICASTRECEIVERCOMPROPTITLE),
    _multicastReceiver(NULL)
{
    InitCommonControls();
}
//------------------------------------------------------------------------------
void
CMulticastReceiverComProp::SetDirty()
{
    m_bDirty = TRUE;
    if (m_pPageSite)
	{
        m_pPageSite->OnStatusChange(PROPPAGESTATUS_DIRTY);
    }
}
//------------------------------------------------------------------------------
BOOL
CMulticastReceiverComProp::OnReceiveMessage(HWND hwnd,
                                           UINT uMsg,
                                           WPARAM wParam,
                                           LPARAM lParam)
{
    switch (uMsg)
    {
        case WM_INITDIALOG:
        {
			setupControls();
			return (LRESULT) 1;
        }
        case WM_COMMAND:
        {
			switch(LOWORD(wParam))
			{
			case IDC_COM_ADDR_EDIT:
				if (HIWORD(wParam) == EN_CHANGE)
				{
					TCHAR sz[MR_MAXIMUM_ADDRESS_LENGTH];
					Edit_GetText(GetDlgItem(m_Dlg, IDC_COM_ADDR_EDIT), sz, MR_MAXIMUM_ADDRESS_LENGTH);
					strcpy(_address, sz);
					SetDirty();
				}
				break;
			case IDC_COM_PORT_EDIT:
				if (HIWORD(wParam) == EN_CHANGE)
				{
					TCHAR sz[STR_MAX_LENGTH];
					Edit_GetText(GetDlgItem(m_Dlg, IDC_COM_PORT_EDIT), sz, STR_MAX_LENGTH);
					_port = atoi(sz);
					SetDirty();
				}
				break;
			case IDC_COM_TTL_EDIT:
				if (HIWORD(wParam) == EN_CHANGE)
				{
					TCHAR sz[STR_MAX_LENGTH];
					Edit_GetText(GetDlgItem(m_Dlg, IDC_COM_TTL_EDIT), sz, STR_MAX_LENGTH);
					_ttl = atoi(sz);
					SetDirty();
				}
				break;
			}
			return (LRESULT) 1;
		}
        case WM_DESTROY:
        {
			shutdownControls();
            return (LRESULT) 1;
        }
		case WM_TIMER:
		{
			TCHAR sz[STR_MAX_LENGTH];
			bool flag = false;

			_multicastReceiver->is_SocketOpen(&flag);
			strcpy(sz, flag ? "" : "s");
			Edit_SetText(GetDlgItem(m_Dlg, IDC_COM_OPENSTATUS_VALUE), sz);

			_multicastReceiver->is_Streaming(&flag);
			strcpy(sz, flag ? "s" : "~");
			Edit_SetText(GetDlgItem(m_Dlg, IDC_COM_STREAMING_VALUE), sz);

			Sleep(0);

			return (LRESULT) 1;
		}
    }
    return CBasePropertyPage::OnReceiveMessage(hwnd,uMsg,wParam,lParam);
}
//------------------------------------------------------------------------------
HRESULT
CMulticastReceiverComProp::OnConnect(IUnknown *pUnknown)
{
    ASSERT(_multicastReceiver == NULL);

    HRESULT hr = pUnknown->QueryInterface(IID_IMulticastReceiver, (void **) &_multicastReceiver);
    if (FAILED(hr))
	{
        return E_NOINTERFACE;
    }

    ASSERT(_multicastReceiver);

	_multicastReceiver->get_Address(_address);
	_multicastReceiver->get_Port(&_port);
	_multicastReceiver->get_TimeToLive(&_ttl);

    return NOERROR;
}
//------------------------------------------------------------------------------
HRESULT
CMulticastReceiverComProp::OnDisconnect()
{
    if (_multicastReceiver == NULL)
	{
        return E_UNEXPECTED;
    }

    _multicastReceiver->Release();
    _multicastReceiver = NULL;

	return NOERROR;
}
//------------------------------------------------------------------------------
HRESULT
CMulticastReceiverComProp::OnDeactivate(void)
{
	return NOERROR;
}
//------------------------------------------------------------------------------
HRESULT
CMulticastReceiverComProp::OnApplyChanges()
{
	_multicastReceiver->put_Address(_address);
	_multicastReceiver->put_Port(_port);
	_multicastReceiver->put_TimeToLive(_ttl);

    m_bDirty = FALSE;
    return NOERROR;
}
//------------------------------------------------------------------------------
void
CMulticastReceiverComProp::setupControls()
{
	// Setup Controls
	TCHAR   sz[32];
	
	Edit_SetText(GetDlgItem(m_Dlg, IDC_COM_ADDR_EDIT), _address);
	_stprintf(sz, "%d", _port);
	Edit_SetText(GetDlgItem(m_Dlg, IDC_COM_PORT_EDIT), sz);
	_stprintf(sz, "%d", _ttl);
	Edit_SetText(GetDlgItem(m_Dlg, IDC_COM_TTL_EDIT), sz);

	// Setup Timer
	_timer = SetTimer(m_Dlg, 0, 100, NULL);
}
//------------------------------------------------------------------------------
void
CMulticastReceiverComProp::shutdownControls()
{
	// Shutdown Timer
	KillTimer(m_Dlg, _timer);
}
//------------------------------------------------------------------------------
