/*
**	Copyright (c) 2003-2004 National Institute of Multimedia Education. All rights reserved.
**	2-12 Wakaba, Mihama, Chiba, 261-0014 JAPAN
**	http://www.nime.ac.jp/
*/
//------------------------------------------------------------------------------
#define WIN32_LEAN_AND_MEAN
#include <streams.h>

#include <flMulticastReceiver/MulticastReceiverFrameProp.h>
#include <commctrl.h>
#include <tchar.h>
#include "resource.h"
//------------------------------------------------------------------------------
CUnknown * WINAPI CMulticastReceiverFrameProp::CreateInstance(LPUNKNOWN lpunk, HRESULT *phr)
{
    CUnknown *punk = new CMulticastReceiverFrameProp(lpunk, phr);
    if (punk == NULL)
	{
		*phr = E_OUTOFMEMORY;
    }
    return punk;
}
//------------------------------------------------------------------------------
CMulticastReceiverFrameProp::CMulticastReceiverFrameProp(LPUNKNOWN pUnk, HRESULT *phr) :
    CBasePropertyPage(NAME("MulticastReceiverFrameProp"),pUnk,
                      IDD_MULTICASTRECEIVERFRAMEPROP,
                      IDS_MULTICASTRECEIVERFRAMEPROPTITLE),
    _multicastReceiver(NULL)
{
    InitCommonControls();
}
//------------------------------------------------------------------------------
void
CMulticastReceiverFrameProp::SetDirty()
{
    m_bDirty = TRUE;
    if (m_pPageSite)
	{
        m_pPageSite->OnStatusChange(PROPPAGESTATUS_DIRTY);
    }
}
//------------------------------------------------------------------------------
BOOL
CMulticastReceiverFrameProp::OnReceiveMessage(HWND hwnd,
                                           UINT uMsg,
                                           WPARAM wParam,
                                           LPARAM lParam)
{
    switch (uMsg)
    {
        case WM_INITDIALOG:
        {
			setupControls();
			return (LRESULT) 1;
        }
        case WM_COMMAND:
        {
			switch(LOWORD(wParam))
			{
			case IDC_FRAME_TIMESTAMP_COMBO:
				if (HIWORD(wParam) == CBN_SELCHANGE)
				{
					_timeStampMode = ComboBox_GetCurSel(GetDlgItem(m_Dlg, 
												IDC_FRAME_TIMESTAMP_COMBO));
					SetDirty();
				}
				break;
			}
			return (LRESULT) 1;
		}
        case WM_DESTROY:
        {
			shutdownControls();
            return (LRESULT) 1;
        }
		case WM_TIMER:
		{
			TCHAR sz[STR_MAX_LENGTH];

			flBool flag;
			_multicastReceiver->is_Streaming(&flag);
			strcpy(sz, flag ? "s" : "~");
			Edit_SetText(GetDlgItem(m_Dlg, IDC_FRAME_STREAMING_VALUE), sz);

			flInt64 absTime;
			_multicastReceiver->get_AbsoluteTime(&absTime);
			_stprintf(sz, "%I64d", (absTime / 10000));
			Edit_SetText(GetDlgItem(m_Dlg, IDC_FRAME_ABSTIME_VALUE), sz);

			flUInt value;
			_multicastReceiver->get_ReceiveRate(&value);
			_stprintf(sz, "%d", (value / 1024));
			Edit_SetText(GetDlgItem(m_Dlg, IDC_FRAME_RECEIVERATE_VALUE), sz);

			_multicastReceiver->get_FrameRate(&value);
			_stprintf(sz, "%d", value);
			Edit_SetText(GetDlgItem(m_Dlg, IDC_FRAME_FRAMERATE_VALUE), sz);

			_multicastReceiver->get_PacketSize(&value);
			_stprintf(sz, "%d", value);
			Edit_SetText(GetDlgItem(m_Dlg, IDC_FRAME_RECEIVE_PACKETSIZE_VALUE), sz);

			_multicastReceiver->get_NumTotalPackets(&value);
			_stprintf(sz, "%d", value);
			Edit_SetText(GetDlgItem(m_Dlg, IDC_FRAME_RECEIVE_PACKET_VALUE), sz);

			_multicastReceiver->get_NumTotalFrames(&value);
			_stprintf(sz, "%d", value);
			Edit_SetText(GetDlgItem(m_Dlg, IDC_FRAME_RECEIVE_FRAME_VALUE), sz);

			_multicastReceiver->get_NumDropPackets(&value);
			_stprintf(sz, "%d", value);
			Edit_SetText(GetDlgItem(m_Dlg, IDC_FRAME_DROP_PACKET_VALUE), sz);

			_multicastReceiver->get_NumDropFrames(&value);
			_stprintf(sz, "%d", value);
			Edit_SetText(GetDlgItem(m_Dlg, IDC_FRAME_DROP_FRAME_VALUE), sz);

			_multicastReceiver->get_NumOverwriteFrames(&value);
			_stprintf(sz, "%d", value);
			Edit_SetText(GetDlgItem(m_Dlg, IDC_FRAME_OVERWRITE_FRAME_VALUE), sz);

			Sleep(0);

			return (LRESULT) 1;
		}
    }
    return CBasePropertyPage::OnReceiveMessage(hwnd,uMsg,wParam,lParam);
}
//------------------------------------------------------------------------------
HRESULT
CMulticastReceiverFrameProp::OnConnect(IUnknown *pUnknown)
{
    ASSERT(_multicastReceiver == NULL);

    HRESULT hr = pUnknown->QueryInterface(IID_IMulticastReceiver, (void **) &_multicastReceiver);
    if (FAILED(hr))
	{
        return E_NOINTERFACE;
    }

    ASSERT(_multicastReceiver);

	_multicastReceiver->get_TimeStampMode(&_timeStampMode);

    return NOERROR;
}
//------------------------------------------------------------------------------
HRESULT
CMulticastReceiverFrameProp::OnDisconnect()
{
    if (_multicastReceiver == NULL)
	{
        return E_UNEXPECTED;
    }

    _multicastReceiver->Release();
    _multicastReceiver = NULL;

	return NOERROR;
}
//------------------------------------------------------------------------------
HRESULT
CMulticastReceiverFrameProp::OnDeactivate(void)
{
	return NOERROR;
}
//------------------------------------------------------------------------------
HRESULT
CMulticastReceiverFrameProp::OnApplyChanges()
{
	_multicastReceiver->put_TimeStampMode(_timeStampMode);

    m_bDirty = FALSE;
    return NOERROR;
}
//------------------------------------------------------------------------------
void
CMulticastReceiverFrameProp::setupControls()
{
	HWND item = GetDlgItem(m_Dlg, IDC_FRAME_TIMESTAMP_COMBO);
	ComboBox_ResetContent(item);
	ComboBox_AddString(item, "ɂ");
	ComboBox_AddString(item, "MXg[^Cgp");
	ComboBox_AddString(item, "MΎgp");
	ComboBox_SetCurSel(item, _timeStampMode);

	// Setup Timer
	_timer = SetTimer(m_Dlg, 0, 200, NULL);
}
//------------------------------------------------------------------------------
void
CMulticastReceiverFrameProp::shutdownControls()
{
	// Shutdown Timer
	KillTimer(m_Dlg, _timer);
}
//------------------------------------------------------------------------------
