/*
**	Copyright (c) 2003-2004 National Institute of Multimedia Education. All rights reserved.
**	2-12 Wakaba, Mihama, Chiba, 261-0014 JAPAN
**	http://www.nime.ac.jp/
*/
//------------------------------------------------------------------------------
#define WIN32_LEAN_AND_MEAN
#include <streams.h>

#include <flMulticastReceiver/MulticastReceiverMediaProp.h>
#include <commctrl.h>
#include "resource.h"
//------------------------------------------------------------------------------
CUnknown * WINAPI
CMulticastReceiverMediaProp::CreateInstance(LPUNKNOWN lpunk, HRESULT *phr)
{
    CUnknown *punk = new CMulticastReceiverMediaProp(lpunk, phr);
    if (punk == NULL)
	{
		*phr = E_OUTOFMEMORY;
    }
    return punk;
}
//------------------------------------------------------------------------------
CMulticastReceiverMediaProp::CMulticastReceiverMediaProp(LPUNKNOWN pUnk, HRESULT *phr) :
    CBasePropertyPage(NAME("MulticastReceiverMediaProp"),pUnk,
                      IDD_MULTICASTRECEIVERMEDIAPROP,
                      IDS_MULTICASTRECEIVERMEDIAPROPTITLE),
    _multicastReceiver(NULL)
{
    InitCommonControls();
}
//------------------------------------------------------------------------------
void
CMulticastReceiverMediaProp::SetDirty()
{
    m_bDirty = TRUE;
    if (m_pPageSite)
	{
        m_pPageSite->OnStatusChange(PROPPAGESTATUS_DIRTY);
    }
}
//------------------------------------------------------------------------------
BOOL
CMulticastReceiverMediaProp::OnReceiveMessage(HWND hwnd,
                                           UINT uMsg,
                                           WPARAM wParam,
                                           LPARAM lParam)
{
    switch (uMsg)
    {
        case WM_INITDIALOG:
        {
			setupControls();
			return (LRESULT) 1;
        }
        case WM_COMMAND:
        {
			switch(LOWORD(wParam))
			{
			case IDC_ENABLECONNECTRECEIVEMEDIATYPE_CHECK:
				if (HIWORD(wParam) == BN_CLICKED)
				{
					flInt checked = Button_GetCheck(GetDlgItem(m_Dlg, 
										IDC_ENABLECONNECTRECEIVEMEDIATYPE_CHECK));
					_enableConnectReceiveMediaType = (checked ? true : false);
					updateControlsEnabled();
					SetDirty();
				}
				break;
			case IDC_MEDIA_VIDEOOUTPUT_RADIO:
				if(Button_GetCheck(GetDlgItem(m_Dlg, IDC_MEDIA_VIDEOOUTPUT_RADIO)))
				{
					_mediaType = IMulticastReceiver::MRMT_VIDEO;
					updateControlsEnabled();
					SetDirty();
				}
				break;
			case IDC_MEDIA_AUDIOOUTPUT_RADIO:
				if(Button_GetCheck(GetDlgItem(m_Dlg, IDC_MEDIA_AUDIOOUTPUT_RADIO)))
				{
					_mediaType = IMulticastReceiver::MRMT_AUDIO;
					updateControlsEnabled();
					SetDirty();
				}
				break;
			case IDC_MEDIA_POINTEROUTPUT_RADIO:
				if(Button_GetCheck(GetDlgItem(m_Dlg, IDC_MEDIA_POINTEROUTPUT_RADIO)))
				{
					_mediaType = IMulticastReceiver::MRMT_POINTER;
					updateControlsEnabled();
					SetDirty();
				}
				break;
			case IDC_MEDIA_VIDEOFORMAT_COMBO:
				if (HIWORD(wParam) == CBN_SELCHANGE)
				{
					_videoFormat = ComboBox_GetCurSel(GetDlgItem(m_Dlg, 
												IDC_MEDIA_VIDEOFORMAT_COMBO));
					SetDirty();
				}
				break;
			case IDC_MEDIA_VIDEORESOLUTION_COMBO:
				if (HIWORD(wParam) == CBN_SELCHANGE)
				{
					_videoResolution = ComboBox_GetCurSel(GetDlgItem(m_Dlg, 
												IDC_MEDIA_VIDEORESOLUTION_COMBO));
					SetDirty();
				}
				break;
			case IDC_MEDIA_AUDIOFORMAT_COMBO:
				if (HIWORD(wParam) == CBN_SELCHANGE)
				{
					_audioFormat = ComboBox_GetCurSel(GetDlgItem(m_Dlg, 
												IDC_MEDIA_AUDIOFORMAT_COMBO));
					SetDirty();
				}
				break;
			case IDC_MEDIA_AUDIOFREQ_COMBO:
				if (HIWORD(wParam) == CBN_SELCHANGE)
				{
					_audioFrequency = ComboBox_GetCurSel(GetDlgItem(m_Dlg, 
												IDC_MEDIA_AUDIOFREQ_COMBO));
					SetDirty();
				}
				break;
			case IDC_MEDIA_AUDIOSTEREO_COMBO:
				if (HIWORD(wParam) == CBN_SELCHANGE)
				{
					_audioStereo = ComboBox_GetCurSel(GetDlgItem(m_Dlg, 
												IDC_MEDIA_AUDIOSTEREO_COMBO));
					SetDirty();
				}
				break;
			case IDC_MEDIA_AUDIOBITCOUNT_COMBO:
				if (HIWORD(wParam) == CBN_SELCHANGE)
				{
					_audioBitCount = ComboBox_GetCurSel(GetDlgItem(m_Dlg, 
												IDC_MEDIA_AUDIOBITCOUNT_COMBO));
					SetDirty();
				}
				break;
			}
			return (LRESULT) 1;
		}
        case WM_DESTROY:
        {
			shutdownControls();
            return (LRESULT) 1;
        }
		case WM_TIMER:
		{
			flBool flag;
			_multicastReceiver->is_OutputMediaTypeAgreement(&flag);
			Edit_SetText(GetDlgItem(m_Dlg, IDC_MEDIA_TYPERECEIVESTATUS),
				flag ? "" : "MfBA^CvƏo̓s̃fBA^CvقȂ܂B");

			char mediaTypeStr[MR_MAXIMUM_MEDIATYPESTR_LENGTH];
			_multicastReceiver->get_MediaTypeString(mediaTypeStr);
			Edit_SetText(GetDlgItem(m_Dlg, IDC_MEDIA_RECEIVEDTYPE), mediaTypeStr);
		}

    }
    return CBasePropertyPage::OnReceiveMessage(hwnd,uMsg,wParam,lParam);
}
//------------------------------------------------------------------------------
HRESULT
CMulticastReceiverMediaProp::OnConnect(IUnknown *pUnknown)
{
    ASSERT(_multicastReceiver == NULL);

    HRESULT hr = pUnknown->QueryInterface(IID_IMulticastReceiver, (void **) &_multicastReceiver);
    if (FAILED(hr))
	{
        return E_NOINTERFACE;
    }

    ASSERT(_multicastReceiver);

	_multicastReceiver->get_EnableConnectReceiveMediaType(&_enableConnectReceiveMediaType);
	_multicastReceiver->get_MediaType(&_mediaType);
	_multicastReceiver->get_VideoFormat(&_videoFormat);
	_multicastReceiver->get_VideoResolution(&_videoResolution);
	_multicastReceiver->get_AudioFormat(&_audioFormat);
	_multicastReceiver->get_AudioFrequency(&_audioFrequency);
	_multicastReceiver->get_AudioStereo(&_audioStereo);
	_multicastReceiver->get_AudioBitCount(&_audioBitCount);

	return NOERROR;
}
//------------------------------------------------------------------------------
HRESULT
CMulticastReceiverMediaProp::OnDisconnect()
{
    if (_multicastReceiver == NULL)
	{
        return E_UNEXPECTED;
    }

    _multicastReceiver->Release();
    _multicastReceiver = NULL;

	return NOERROR;
}
//------------------------------------------------------------------------------
HRESULT
CMulticastReceiverMediaProp::OnDeactivate(void)
{
	return NOERROR;
}
//------------------------------------------------------------------------------
HRESULT
CMulticastReceiverMediaProp::OnApplyChanges()
{
	_multicastReceiver->put_EnableConnectReceiveMediaType(_enableConnectReceiveMediaType);

	_multicastReceiver->put_MediaType(_mediaType);

	_multicastReceiver->put_VideoFormat(_videoFormat);
	_multicastReceiver->put_VideoResolution(_videoResolution);

	_multicastReceiver->put_AudioFormat(_audioFormat);
	_multicastReceiver->put_AudioFrequency(_audioFrequency);
	_multicastReceiver->put_AudioStereo(_audioStereo);
	_multicastReceiver->put_AudioBitCount(_audioBitCount);

    m_bDirty = FALSE;
    return NOERROR;
}
//------------------------------------------------------------------------------
void
CMulticastReceiverMediaProp::setupControls()
{
	// Setup Combo Box
	HWND dlgItem = GetDlgItem(m_Dlg, IDC_MEDIA_VIDEOFORMAT_COMBO);
	ComboBox_ResetContent(dlgItem);
	ComboBox_AddString(dlgItem, "RGB555(16bit)");
	ComboBox_AddString(dlgItem, "RGB24");
	ComboBox_AddString(dlgItem, "MPEG4 v2");
	ComboBox_AddString(dlgItem, "MPEG4 v3");
	ComboBox_AddString(dlgItem, "dvsd");
	ComboBox_AddString(dlgItem, "H.261");
	ComboBox_AddString(dlgItem, "H.263");
	ComboBox_AddString(dlgItem, "MJPEG");
	ComboBox_SetCurSel(dlgItem, _videoFormat);

	dlgItem = GetDlgItem(m_Dlg, IDC_MEDIA_VIDEORESOLUTION_COMBO);
	ComboBox_ResetContent(dlgItem);
	ComboBox_AddString(dlgItem, "SQCIF(128x96)");
	ComboBox_AddString(dlgItem, "QCIF(176x144)");
	ComboBox_AddString(dlgItem, "CIF(352x288)");
	ComboBox_AddString(dlgItem, "160x120");
	ComboBox_AddString(dlgItem, "180x120");
	ComboBox_AddString(dlgItem, "320x240");
	ComboBox_AddString(dlgItem, "360x240");
	ComboBox_AddString(dlgItem, "640x480");
	ComboBox_AddString(dlgItem, "720x480");
	ComboBox_AddString(dlgItem, "800x600");
	ComboBox_AddString(dlgItem, "1024x768");
	ComboBox_AddString(dlgItem, "1280x1024");
	ComboBox_AddString(dlgItem, "1600x1200");
	ComboBox_AddString(dlgItem, "HDTV 720p");
	ComboBox_AddString(dlgItem, "HDTV 1080i");
	ComboBox_AddString(dlgItem, "SDTV 480p");
	ComboBox_AddString(dlgItem, "SDTV 480i");
	ComboBox_SetCurSel(dlgItem, _videoResolution);

	dlgItem = GetDlgItem(m_Dlg, IDC_MEDIA_AUDIOFORMAT_COMBO);
	ComboBox_ResetContent(dlgItem);
	ComboBox_AddString(dlgItem, "MP3");
	ComboBox_AddString(dlgItem, "PCM");
	ComboBox_AddString(dlgItem, "MPEG1");
	ComboBox_SetCurSel(dlgItem, _audioFormat);

	dlgItem = GetDlgItem(m_Dlg, IDC_MEDIA_AUDIOFREQ_COMBO);
	ComboBox_ResetContent(dlgItem);
	ComboBox_AddString(dlgItem, "8KHz");
	ComboBox_AddString(dlgItem, "11KHz");
	ComboBox_AddString(dlgItem, "16KHz");
	ComboBox_AddString(dlgItem, "22KHz");
	ComboBox_AddString(dlgItem, "44.1KHz");
	ComboBox_AddString(dlgItem, "48KHz");
	ComboBox_SetCurSel(dlgItem, _audioFrequency);

	dlgItem = GetDlgItem(m_Dlg, IDC_MEDIA_AUDIOSTEREO_COMBO);
	ComboBox_ResetContent(dlgItem);
	ComboBox_AddString(dlgItem, "Stereo");
	ComboBox_AddString(dlgItem, "Monaural");
	ComboBox_SetCurSel(dlgItem, _audioStereo);

	dlgItem = GetDlgItem(m_Dlg, IDC_MEDIA_AUDIOBITCOUNT_COMBO);
	ComboBox_ResetContent(dlgItem);
	ComboBox_AddString(dlgItem, "0bit");
	ComboBox_AddString(dlgItem, "8bit");
	ComboBox_AddString(dlgItem, "16bit");
	ComboBox_SetCurSel(dlgItem, _audioBitCount);

	// Setup ConnectReceiveMediaType check
	Button_SetCheck(GetDlgItem(m_Dlg, IDC_ENABLECONNECTRECEIVEMEDIATYPE_CHECK),
								_enableConnectReceiveMediaType);

	// Setup media type
	switch(_mediaType)
	{
	case IMulticastReceiver::MRMT_VIDEO:
		Button_SetCheck(GetDlgItem(m_Dlg, IDC_MEDIA_VIDEOOUTPUT_RADIO), true);
		break;
	case IMulticastReceiver::MRMT_AUDIO:
		Button_SetCheck(GetDlgItem(m_Dlg, IDC_MEDIA_AUDIOOUTPUT_RADIO), true);
		break;
	case IMulticastReceiver::MRMT_POINTER:
		Button_SetCheck(GetDlgItem(m_Dlg, IDC_MEDIA_POINTEROUTPUT_RADIO), true);
		break;
	};

	updateControlsEnabled();

	// Setup Timer
	_timer = SetTimer(m_Dlg, 0, 1000, NULL);
}
//------------------------------------------------------------------------------
void
CMulticastReceiverMediaProp::shutdownControls()
{
	// Shutdown Timer
	KillTimer(m_Dlg, _timer);
}
//------------------------------------------------------------------------------
void
CMulticastReceiverMediaProp::updateControlsEnabled()
{
	if (_enableConnectReceiveMediaType)
	{
		Button_Enable(GetDlgItem(m_Dlg, IDC_MEDIA_VIDEOOUTPUT_RADIO), false);
		Button_Enable(GetDlgItem(m_Dlg, IDC_MEDIA_AUDIOOUTPUT_RADIO), false);
		Button_Enable(GetDlgItem(m_Dlg, IDC_MEDIA_POINTEROUTPUT_RADIO), false);
		setEnableVideoControls(false);
		setEnableAudioControls(false);
		setEnablePointerInfoControls(false);
	}
	else
	{
		Button_Enable(GetDlgItem(m_Dlg, IDC_MEDIA_VIDEOOUTPUT_RADIO), true);
		Button_Enable(GetDlgItem(m_Dlg, IDC_MEDIA_AUDIOOUTPUT_RADIO), true);
		Button_Enable(GetDlgItem(m_Dlg, IDC_MEDIA_POINTEROUTPUT_RADIO), true);
		switch(_mediaType)
		{
		case IMulticastReceiver::MRMT_VIDEO:
			setEnableVideoControls(true);
			setEnableAudioControls(false);
			setEnablePointerInfoControls(false);
			break;
		case IMulticastReceiver::MRMT_AUDIO:
			setEnableVideoControls(false);
			setEnableAudioControls(true);
			setEnablePointerInfoControls(false);
			break;
		case IMulticastReceiver::MRMT_POINTER:
			setEnableVideoControls(false);
			setEnableAudioControls(false);
			setEnablePointerInfoControls(true);
			break;
		}
	}
}
//------------------------------------------------------------------------------
void
CMulticastReceiverMediaProp::setEnableVideoControls(flBool flag)
{
	ComboBox_Enable(GetDlgItem(m_Dlg, IDC_MEDIA_VIDEOFORMAT_COMBO), flag);
	ComboBox_Enable(GetDlgItem(m_Dlg, IDC_MEDIA_VIDEORESOLUTION_COMBO), flag);
	Static_Enable(GetDlgItem(m_Dlg, IDC_MEDIA_VIDEOFORMAT_LABEL), flag);
	Static_Enable(GetDlgItem(m_Dlg, IDC_MEDIA_VIDEORESOLUTION_LABEL), flag);
}
//------------------------------------------------------------------------------
void
CMulticastReceiverMediaProp::setEnableAudioControls(flBool flag)
{
	ComboBox_Enable(GetDlgItem(m_Dlg, IDC_MEDIA_AUDIOFORMAT_COMBO), flag);
	ComboBox_Enable(GetDlgItem(m_Dlg, IDC_MEDIA_AUDIOFREQ_COMBO), flag);
	ComboBox_Enable(GetDlgItem(m_Dlg, IDC_MEDIA_AUDIOSTEREO_COMBO), flag);
	ComboBox_Enable(GetDlgItem(m_Dlg, IDC_MEDIA_AUDIOBITCOUNT_COMBO), flag);
	Static_Enable(GetDlgItem(m_Dlg, IDC_MEDIA_AUDIOFORMAT_LABEL), flag);
	Static_Enable(GetDlgItem(m_Dlg, IDC_MEDIA_AUDIOFREQ_LABEL), flag);
	Static_Enable(GetDlgItem(m_Dlg, IDC_MEDIA_AUDIOSTEREO_LABEL), flag);
	Static_Enable(GetDlgItem(m_Dlg, IDC_MEDIA_AUDIOBITCOUNT_LABEL), flag);
}
//------------------------------------------------------------------------------
void
CMulticastReceiverMediaProp::setEnablePointerInfoControls(flBool flag)
{
}
//------------------------------------------------------------------------------

