/*
**	Copyright (c) 2003-2004 National Institute of Multimedia Education. All rights reserved.
**	2-12 Wakaba, Mihama, Chiba, 261-0014 JAPAN
**	http://www.nime.ac.jp/
*/
//------------------------------------------------------------------------------
#define WIN32_LEAN_AND_MEAN
#include <streams.h>

#include <flMulticastReceiver/MulticastReceiverRejectProp.h>
#include <commctrl.h>
#include <tchar.h>
#include "resource.h"
//------------------------------------------------------------------------------
CUnknown * WINAPI
CMulticastReceiverRejectProp::CreateInstance(LPUNKNOWN lpunk, HRESULT *phr)
{
    CUnknown *punk = new CMulticastReceiverRejectProp(lpunk, phr);
    if (punk == NULL)
	{
		*phr = E_OUTOFMEMORY;
    }
    return punk;
}
//------------------------------------------------------------------------------
CMulticastReceiverRejectProp::CMulticastReceiverRejectProp(LPUNKNOWN pUnk, HRESULT *phr) :
    CBasePropertyPage(NAME("MulticastReceiverRejectProp"),pUnk,
                      IDD_MULTICASTRECEIVERREJECTPROP,
                      IDS_MULTICASTRECEIVERREJECTPROPTITLE),
    _multicastReceiver(NULL)
{
    InitCommonControls();
}
//------------------------------------------------------------------------------
void
CMulticastReceiverRejectProp::SetDirty()
{
    m_bDirty = TRUE;
    if (m_pPageSite)
	{
        m_pPageSite->OnStatusChange(PROPPAGESTATUS_DIRTY);
    }
}
//------------------------------------------------------------------------------
BOOL
CMulticastReceiverRejectProp::OnReceiveMessage(HWND hwnd,
                                           UINT uMsg,
                                           WPARAM wParam,
                                           LPARAM lParam)
{
    switch (uMsg)
    {
        case WM_INITDIALOG:
        {
			setupControls();
			return (LRESULT) 1;
        }
        case WM_COMMAND:
        {
			switch(LOWORD(wParam))
			{
			case IDC_ADDREJECTADDRESS_BUTTON:

				addRejectAddress();
				resetRejectAddressList();
				writeRejectAddressList();

				break;

			case IDC_REMOVEREJECTADDRESS_BUTTON:

				removeRejectAddress();
				resetRejectAddressList();
				writeRejectAddressList();

				break;

			case IDC_REJECTADDRESS_LIST:

				if (HIWORD(wParam) == LBN_SELCHANGE)
					readRejectAddressList();

				break;
			}
			return (LRESULT) 1;
		}
        case WM_DESTROY:
        {
			shutdownControls();
            return (LRESULT) 1;
        }
		case WM_TIMER:
		{
			flChar address[MR_MAXIMUM_ADDRESS_LENGTH];
			_multicastReceiver->get_SenderAddress(address);
			Static_SetText(GetDlgItem(m_Dlg, IDC_RECEIVEADDRESS_VALUE), address);

			return (LRESULT) 1;
		}
    }
    return CBasePropertyPage::OnReceiveMessage(hwnd,uMsg,wParam,lParam);
}
//------------------------------------------------------------------------------
HRESULT
CMulticastReceiverRejectProp::OnConnect(IUnknown *pUnknown)
{
    ASSERT(_multicastReceiver == NULL);

    HRESULT hr = pUnknown->QueryInterface(IID_IMulticastReceiver, (void **) &_multicastReceiver);
    if (FAILED(hr))
	{
        return E_NOINTERFACE;
    }

    ASSERT(_multicastReceiver);

	flUInt numReject;
	flChar address[MR_MAXIMUM_ADDRESS_LENGTH];
	_multicastReceiver->get_NumRejectionAddress(&numReject);
	_rejectAddressList.clear();
	for(flUInt i = 0; i < numReject; i++)
	{
		_multicastReceiver->get_RejectionAddress(i, address);
		_rejectAddressList.add(flString(address));
	}

	_currentRejectAddress = 0;

    return NOERROR;
}
//------------------------------------------------------------------------------
HRESULT
CMulticastReceiverRejectProp::OnDisconnect()
{
    if (_multicastReceiver == NULL)
	{
        return E_UNEXPECTED;
    }

    _multicastReceiver->Release();
    _multicastReceiver = NULL;

	return NOERROR;
}
//------------------------------------------------------------------------------
HRESULT
CMulticastReceiverRejectProp::OnDeactivate(void)
{
	return NOERROR;
}
//------------------------------------------------------------------------------
HRESULT
CMulticastReceiverRejectProp::OnApplyChanges()
{
	_multicastReceiver->remove_AllRejectionAddress();
	for(flUInt i = 0; i < _rejectAddressList.getSize(); i++)
		_multicastReceiver->add_RejectionAddress(_rejectAddressList[i].c_str());

    m_bDirty = FALSE;
    return NOERROR;
}
//------------------------------------------------------------------------------
void
CMulticastReceiverRejectProp::setupControls()
{
	resetRejectAddressList();
	writeRejectAddressList();

	Button_Enable(GetDlgItem(m_Dlg, IDC_REMOVEREJECTADDRESS_BUTTON), (_rejectAddressList.getSize() != 0));

	// Setup Timer
	_timer = SetTimer(m_Dlg, 0, 1000, NULL);
}
//------------------------------------------------------------------------------
void
CMulticastReceiverRejectProp::shutdownControls()
{
	// Shutdown Timer
	KillTimer(m_Dlg, _timer);
}
//------------------------------------------------------------------------------
void
CMulticastReceiverRejectProp::writeRejectAddressList()
{
	if (_rejectAddressList.getSize() == 0)
		return ;
	ListBox_SetCurSel(GetDlgItem(m_Dlg, IDC_REJECTADDRESS_LIST), _currentRejectAddress);
}
//------------------------------------------------------------------------------
void
CMulticastReceiverRejectProp::readRejectAddressList()
{
	_currentRejectAddress = ListBox_GetCurSel(GetDlgItem(m_Dlg, IDC_REJECTADDRESS_LIST));
}
//------------------------------------------------------------------------------
void
CMulticastReceiverRejectProp::addRejectAddress()
{
	flChar address[MR_MAXIMUM_ADDRESS_LENGTH];
	Static_GetText(GetDlgItem(m_Dlg, IDC_RECEIVEADDRESS_VALUE), address, MR_MAXIMUM_ADDRESS_LENGTH);

	if (strlen(address) != 0 && !_rejectAddressList.find(address))
		_rejectAddressList.add(address);

	Button_Enable(GetDlgItem(m_Dlg, IDC_REMOVEREJECTADDRESS_BUTTON), (_rejectAddressList.getSize() != 0));
	SetDirty();
}
//------------------------------------------------------------------------------
void
CMulticastReceiverRejectProp::removeRejectAddress()
{
	_rejectAddressList.removeIndex(_currentRejectAddress);

	flUInt size = _rejectAddressList.getSize();

	if (size <= (flInt)_currentRejectAddress && _currentRejectAddress != 0)
		_currentRejectAddress = size - 1;

	Button_Enable(GetDlgItem(m_Dlg, IDC_REMOVEREJECTADDRESS_BUTTON), (size != 0));
	SetDirty();
}
//------------------------------------------------------------------------------
void
CMulticastReceiverRejectProp::resetRejectAddressList()
{
	ListBox_ResetContent(GetDlgItem(m_Dlg, IDC_REJECTADDRESS_LIST));

	for(flUInt i = 0; i < _rejectAddressList.getSize(); i++)
		ListBox_AddString(GetDlgItem(m_Dlg, IDC_REJECTADDRESS_LIST), _rejectAddressList[i].c_str());
}
//------------------------------------------------------------------------------
