/*
**	Copyright (c) 2003-2004 National Institute of Multimedia Education. All rights reserved.
**	2-12 Wakaba, Mihama, Chiba, 261-0014 JAPAN
**	http://www.nime.ac.jp/
*/
//------------------------------------------------------------------------------
#ifndef __MulticastReceiverRejectProp_h__
#define __MulticastReceiverRejectProp_h__
//------------------------------------------------------------------------------
#include <initguid.h>
#include <olectl.h>
#if (1100 > _MSC_VER)
#include <olectlid.h>
#endif
#include <flTypes/flUIDs.h>
#include <flTypes/IMulticastReceiver.h>
#include <flBase/flString.h>
//------------------------------------------------------------------------------
class CMulticastReceiverRejectProp : public CBasePropertyPage
{

public:
    static CUnknown * WINAPI CreateInstance(LPUNKNOWN lpunk, HRESULT *phr);

private:
    CMulticastReceiverRejectProp(LPUNKNOWN lpunk, HRESULT *phr);

private:
    void		SetDirty();

	BOOL		OnReceiveMessage(HWND hwnd,UINT uMsg,WPARAM wParam,LPARAM lParam);
    HRESULT		OnConnect(IUnknown *pUnknown);
    HRESULT		OnDisconnect();
    HRESULT		OnDeactivate();
    HRESULT		OnApplyChanges();

private:
	void		setupControls();
	void		shutdownControls();

	void		writeRejectAddressList();
	void		readRejectAddressList();

	void		addRejectAddress();
	void		removeRejectAddress();
	void		resetRejectAddressList();

private:
    IMulticastReceiver*	_multicastReceiver;
	UINT_PTR			_timer;

	flStringArray		_rejectAddressList;

	flInt				_currentRejectAddress;
};
//------------------------------------------------------------------------------
#endif //__MulticastReceiverRejectProp_h__
