/*
**	Copyright (c) 2003-2004 National Institute of Multimedia Education. All rights reserved.
**	2-12 Wakaba, Mihama, Chiba, 261-0014 JAPAN
**	http://www.nime.ac.jp/
*/
//------------------------------------------------------------------------------
#define WIN32_LEAN_AND_MEAN

#include <windows.h>
#include <streams.h>
#include <initguid.h>
#include <olectl.h>
#if (1100 > _MSC_VER)
#include <olectlid.h>
#endif

#include <flTypes/flUIDs.h>
#include <flTypes/IMulticastReceiver.h>
#include <flMulticastReceiver/MulticastReceiver.h>
#include <flMulticastReceiver/MulticastReceiverStream.h>
//------------------------------------------------------------------------------
#define RECEIVE_TIMEOUT		1000
//------------------------------------------------------------------------------
CMulticastReceiverStream::CMulticastReceiverStream
					(HRESULT *phr, CMulticastReceiver *pParent, LPCWSTR pPinName) :
CFLSourceStream(NAME("MulticastReceiverStream"), phr, pParent, pPinName)
{
}
//------------------------------------------------------------------------------
CMulticastReceiverStream::~CMulticastReceiverStream()
{}
//------------------------------------------------------------------------------
HRESULT
CMulticastReceiverStream::FillBuffer(IMediaSample *pms)
{
	CAutoLock lock(&_streamLock);

	CMulticastReceiver *receiver = (CMulticastReceiver *)m_pFilter;
	flMediaSample* sample;

	// Fill Buffer by Preroll
	if (_playPreroll)
	{
		CAutoLock lock2(&receiver->_prerollSampleLock);

		if (_prerollIndex < receiver->_prerollSamples.getSize())
		{
			sample = receiver->_prerollSamples[_prerollIndex++];
			assert(sample != NULL);

			if ((sample->getMediaType() != receiver->_actualOutputMediaType) == TRUE)
				return S_FALSE;

			fillBuffer(sample, pms);
			return S_OK;
		}
		else
		{
			_playPreroll = false;
			return S_FALSE;
		}
	}

	// Fill Buffer by Received Data
	flULong receiveTimeStart = timeGetTime();

	while(true)
	{
		Sleep(1);

		{
			CAutoLock lock3(&receiver->_receiveSampleLock);
			sample = receiver->_receiveSamples.removeIndex(0);
			if (sample != NULL)
				break;
		}

		if (RECEIVE_TIMEOUT < timeGetTime() - receiveTimeStart || !receiver->_isRunning)
		{
			receiver->_isStreaming = false;
			return S_FALSE;
		}
	}

	receiver->_isStreaming = true;
	receiver->_absTime = sample->getAbsoluteTime();

	fillBuffer(sample, pms);

	sample->release();

	return S_OK;
}
//------------------------------------------------------------------------------
// CFLSourceStream override
HRESULT
CMulticastReceiverStream::DecideBufferSize(IMemAllocator *pAlloc,
                            ALLOCATOR_PROPERTIES *pProp)
{
    CAutoLock cAutoLock(_source->pStateLock());
    ASSERT(pAlloc);
    ASSERT(pProp);
    HRESULT hr = NOERROR;

	if (m_mt.IsFixedSize() == TRUE)
	{
		pProp->cBuffers = 1;
		pProp->cbBuffer = m_mt.GetSampleSize();
	}
	else
	{
		pProp->cBuffers = 1;
		pProp->cbBuffer = 2097152;	// 2Mbyte
	}

    ASSERT(pProp->cbBuffer != 0);

    ALLOCATOR_PROPERTIES Actual;
    hr = pAlloc->SetProperties(pProp, &Actual);
    if (FAILED(hr))
        return hr;

    if (Actual.cbBuffer < pProp->cbBuffer)
        return E_FAIL;

    return NOERROR;
}
//------------------------------------------------------------------------------
HRESULT
CMulticastReceiverStream::SetMediaType(const CMediaType *pmt)
{
    CAutoLock cAutoLock(_source->pStateLock());
	
    // Pass the call up to my base class
    HRESULT hr = CFLSourceStream::SetMediaType(pmt);
	
	return hr;
	
}
//------------------------------------------------------------------------------
HRESULT
CMulticastReceiverStream::GetMediaType(CMediaType *pmt)
{
	CMulticastReceiver *receiver  = (CMulticastReceiver *)m_pFilter;

	if (receiver->_enableConnectReceiveMediaType)
		*pmt = receiver->_receivedMediaType;
	else
		*pmt = receiver->_outputMediaType;

	if (IsEqualGUID(pmt->majortype, GUID_NULL))
		return E_UNEXPECTED;

	receiver->_actualOutputMediaType = *pmt;

	return NOERROR;
}
//------------------------------------------------------------------------------
HRESULT
CMulticastReceiverStream::CompleteConnect(IPin *pReceivePin)
{
	_playPreroll	= true;
	_prerollIndex	= 0;
	return CFLSourceStream::CompleteConnect(pReceivePin);
}
//------------------------------------------------------------------------------
// Handler
HRESULT
CMulticastReceiverStream::OnThreadDestroy()
{
	return NOERROR;
}
//------------------------------------------------------------------------------
HRESULT
CMulticastReceiverStream::OnThreadCreate()
{
	CAutoLock lock(&_streamLock);
	CMulticastReceiver *receiver = (CMulticastReceiver *)m_pFilter;

	CAutoLock lock2(&receiver->_receiveSampleLock);
	for(flUInt i = 0; i < receiver->_receiveSamples.getSize(); i++)
		receiver->_receiveSamples[i]->release();
	receiver->_receiveSamples.clear();

	return NOERROR;
}
//------------------------------------------------------------------------------
HRESULT
CMulticastReceiverStream::OnThreadStartPlay()
{
	return NOERROR;
}
//------------------------------------------------------------------------------
STDMETHODIMP
CMulticastReceiverStream::Notify(IBaseFilter * pSender, Quality q)
{
	return NOERROR;
}
//------------------------------------------------------------------------------
void
CMulticastReceiverStream::fillBuffer(const flMediaSample* sample, IMediaSample *pms)
{
	flUInt dataLength = sample->getDataLength();
	pms->SetActualDataLength((LONG)dataLength);

	BYTE *pointer;
	pms->GetPointer(&pointer);

	flLong actDataLength = pms->GetActualDataLength();
	if ((flUInt)actDataLength < dataLength)
		dataLength = (flUInt)actDataLength;

	CopyMemory(pointer, sample->getDataPointer(), (SIZE_T)dataLength);

	pms->SetSyncPoint(sample->getSyncPoint());
	pms->SetDiscontinuity(sample->getDiscontinuity());
	pms->SetPreroll(sample->getPreroll());
	pms->SetMediaTime(sample->getMediaTimeStart(), sample->getMediaTimeEnd());

	switch(((CMulticastReceiver *)m_pFilter)->_timeStampMode)
	{
	case IMulticastReceiver::MRTM_INVALIDATE:
		{
			pms->SetTime(NULL, NULL);
		}
		break;
	case IMulticastReceiver::MRTM_USESTREAMTIME:
		{
			pms->SetTime(sample->getStreamTimeStart(), 
						 sample->getStreamTimeEnd());
		}
		break;
	case IMulticastReceiver::MRTM_USEABSOLUTETIME:
		{
			flInt64 absoluteTime = sample->getAbsoluteTime();
			pms->SetTime(&absoluteTime, NULL);
		}
		break;
	}
}
//------------------------------------------------------------------------------
