/*
**	Copyright (c) 2003-2004 National Institute of Multimedia Education. All rights reserved.
**	2-12 Wakaba, Mihama, Chiba, 261-0014 JAPAN
**	http://www.nime.ac.jp/
*/
//------------------------------------------------------------------------------
#ifndef __MulticastReceiverStream_h__
#define __MulticastReceiverStream_h__
//------------------------------------------------------------------------------
#include <flFilterCommon/flSourceStream.h>
#include <flBase/flBase.h>
//------------------------------------------------------------------------------
class CMulticastReceiverStream : public CFLSourceStream
{

public:
    CMulticastReceiverStream(HRESULT *phr, CMulticastReceiver *pParent, LPCWSTR pPinName);
    ~CMulticastReceiverStream();

public:
	// CFLSourceStream pure virtual
    HRESULT			FillBuffer(IMediaSample *pms);

	// CFLSourceStream override
    HRESULT			DecideBufferSize(IMemAllocator *pAlloc,
                             ALLOCATOR_PROPERTIES *pProp);

    HRESULT			SetMediaType(const CMediaType *pmt);
	HRESULT			GetMediaType(CMediaType *pmt);

	// CBasePin override
	HRESULT			CompleteConnect(IPin *pReceivePin);

	// Handler
	HRESULT			OnThreadDestroy();
    HRESULT			OnThreadCreate();
	HRESULT			OnThreadStartPlay();

    STDMETHODIMP	Notify(IBaseFilter * pSender, Quality q);
	
private:
	void			fillBuffer(const flMediaSample* sample, IMediaSample *pms);

protected:
    CCritSec		_streamLock;
	flBool			_playPreroll;
	flUInt			_prerollIndex;
};
//------------------------------------------------------------------------------
#endif //__MulticastReceiverStream_h__
