/*
**	Copyright (c) 2003-2004 National Institute of Multimedia Education. All rights reserved.
**	2-12 Wakaba, Mihama, Chiba, 261-0014 JAPAN
**	http://www.nime.ac.jp/
*/
//------------------------------------------------------------------------------
#ifndef __MulticastSender_h__
#define __MulticastSender_h__
//------------------------------------------------------------------------------
#include <flFilterCommon/flMediaType.h>
#include <flTypes/flUIDs.h>
#include <flTypes/IMulticastSender.h>
#include <flBase/flByteStream.h>
#include <flBase/flBase.h>
//------------------------------------------------------------------------------
class flFMTSender;
class flAbsoluteTime;
//------------------------------------------------------------------------------
class CMulticastSender : 
		public CBaseRenderer,
		public CPersistStream, 
		public ISpecifyPropertyPages,
		public IMulticastSender
{
public:
    static CUnknown * WINAPI CreateInstance(LPUNKNOWN punk, HRESULT *phr);

    DECLARE_IUNKNOWN;

private:
    CMulticastSender(TCHAR *tszName, LPUNKNOWN pUnk, HRESULT *phr);
    ~CMulticastSender();

public:
	// Reveals IMulticastSender & ISpecifyPropertyPages
    STDMETHODIMP	NonDelegatingQueryInterface(REFIID riid, void ** ppv);

public:
	HRESULT			BreakConnect();
    HRESULT			DoRenderSample(IMediaSample *pMediaSample);

	HRESULT			CheckMediaType(const CMediaType *pmt);
	HRESULT			SetMediaType(const CMediaType *pmt);

	// IMediaFilter
	STDMETHODIMP	Run(REFERENCE_TIME startTime);
    STDMETHODIMP	Pause();
	STDMETHODIMP	Stop();

	// IPersistStream
    STDMETHODIMP	GetClassID(CLSID *pClsid);
	HRESULT			WriteToStream(IStream *pStream);
    HRESULT			ReadFromStream(IStream *pStream);
	DWORD			GetSoftwareVersion(void);
	int				SizeMax();

    // ISpecifyPropertyPages method
    STDMETHODIMP	GetPages(CAUUID *pPages);

	// IMulticastSender
	STDMETHODIMP	is_SocketOpen(flBool *flag);
	STDMETHODIMP	get_AbsoluteTime(flInt64 *absoluteTime);
	STDMETHODIMP	get_TransmissionRate(flUInt *rate);
	STDMETHODIMP	get_FrameRate(flUInt *rate);
	STDMETHODIMP	get_NumTotalPackets(flUInt *numPackets);
	STDMETHODIMP	get_NumTotalFrames(flUInt *numFrames);
	STDMETHODIMP	get_MediaType(flInt *type);
	STDMETHODIMP	put_MediaType(flInt type);
	STDMETHODIMP	get_InputMediaType(flInt *type);
	STDMETHODIMP	get_VideoFormat(flInt *videoFormat);
	STDMETHODIMP	put_VideoFormat(flInt videoFormat);
	STDMETHODIMP	get_InputVideoFormat(flInt *videoFormat);
	STDMETHODIMP	get_VideoResolution(flInt *videoResolution);
	STDMETHODIMP	put_VideoResolution(flInt videoResolution);
	STDMETHODIMP	get_InputVideoResolution(flInt *videoResolution);
	STDMETHODIMP	get_AudioFormat(flInt *audioFormat);
	STDMETHODIMP	put_AudioFormat(flInt audioFormat);
	STDMETHODIMP	get_InputAudioFormat(flInt *audioFormat);
	STDMETHODIMP	get_AudioFrequency(flInt *audioFrequency);
	STDMETHODIMP	put_AudioFrequency(flInt audioFrequency);
	STDMETHODIMP	get_InputAudioFrequency(flInt *audioFrequency);
	STDMETHODIMP	get_AudioStereo(flInt *audioStereo);
	STDMETHODIMP	put_AudioStereo(flInt audioStereo);
	STDMETHODIMP	get_InputAudioStereo(flInt *audioStereo);
	STDMETHODIMP	get_AudioBitCount(flInt *audioBitCount);
	STDMETHODIMP	put_AudioBitCount(flInt audioBitCount);
	STDMETHODIMP	get_InputAudioBitCount(flInt *audioBitCount);
	STDMETHODIMP	get_Address(flChar *address);
	STDMETHODIMP	put_Address(const flChar *address);
	STDMETHODIMP	get_Port(flUShort *port);
	STDMETHODIMP	put_Port(flUShort port);
	STDMETHODIMP	get_TimeToLive(flULong *ttl);
	STDMETHODIMP	put_TimeToLive(flULong ttl);
	STDMETHODIMP	get_EnableTransmit(flBool *flag);
	STDMETHODIMP	put_EnableTransmit(flBool flag);
	STDMETHODIMP	get_TransmissionCount(flUInt *count);
	STDMETHODIMP	put_TransmissionCount(flUInt count);
	STDMETHODIMP	get_MaximumTransmissionRate(flUInt *maximumTransmissionRate);
	STDMETHODIMP	put_MaximumTransmissionRate(flUInt maximumTransmissionRate);
	STDMETHODIMP	get_SystemBufferSize(flUInt *bit);
	STDMETHODIMP	put_SystemBufferSize(flUInt bit);
	STDMETHODIMP	get_ClockMinimumPeriod(flFloat *millisecond);
	STDMETHODIMP	put_ClockMinimumPeriod(flFloat millisecond);
	STDMETHODIMP	compute_ClockMinimumPeriod();
	STDMETHODIMP	get_MaximumPacketSize(flUInt *byte);
	STDMETHODIMP	put_MaximumPacketSize(flUInt byte);
	STDMETHODIMP	get_UserData(flByte *userData, flUInt *size);
	STDMETHODIMP	put_UserData(const flByte *userData, flUInt size);

/*
private:
	void	checkMediaSample2Properties(IMediaSample *pms);
*/
protected:
	CPosPassThru			*_mediaPosition;

protected:
	// Critical Section
	CCritSec				_filterLock;

	// FMT Sender
	flFMTSender*			_fmtSender;

	// AbsoluteTime
	flAbsoluteTime*			_absTime;

	// OutputByteStream
	flOutputByteStream		_oStream;

	// Status
	flUInt					_frameId;

	// Property
	flBool					_enableTransmit;
	flUInt					_userDataSize;
	flByte					_userData[MS_MAXIMUM_USERDATA_SIZE];

	// Media Type
	flMediaType				_inputMediaType;
	CMediaType				_sendMediaType;
};
//------------------------------------------------------------------------------
#endif //__MulticastSender_h__
