/*
**	Copyright (c) 2003-2004 National Institute of Multimedia Education. All rights reserved.
**	2-12 Wakaba, Mihama, Chiba, 261-0014 JAPAN
**	http://www.nime.ac.jp/
*/
//------------------------------------------------------------------------------
#define WIN32_LEAN_AND_MEAN
#include <streams.h>

#include <flMulticastSender/MulticastSenderComProp.h>
#include <commctrl.h>
#include <tchar.h>
#include "resource.h"
//------------------------------------------------------------------------------
CUnknown * WINAPI
CMulticastSenderComProp::CreateInstance(LPUNKNOWN lpunk, HRESULT *phr)
{
    CUnknown *punk = new CMulticastSenderComProp(lpunk, phr);
    if (punk == NULL)
	{
		*phr = E_OUTOFMEMORY;
    }
    return punk;
}
//------------------------------------------------------------------------------
CMulticastSenderComProp::CMulticastSenderComProp(LPUNKNOWN pUnk, HRESULT *phr) :
    CBasePropertyPage(NAME("MulticastSenderComProp"),pUnk,
                      IDD_MULTICASTSENDERCOMPROP,
                      IDS_MULTICASTSENDERCOMPROPTITLE),
    _multicastSender(NULL)
{
    InitCommonControls();

}
//------------------------------------------------------------------------------
void
CMulticastSenderComProp::SetDirty()
{
    m_bDirty = TRUE;
    if (m_pPageSite)
	{
        m_pPageSite->OnStatusChange(PROPPAGESTATUS_DIRTY);
    }

}
//------------------------------------------------------------------------------
BOOL
CMulticastSenderComProp::OnReceiveMessage(HWND hwnd,
                                        UINT uMsg,
                                        WPARAM wParam,
                                        LPARAM lParam)
{
    switch (uMsg)
    {
        case WM_INITDIALOG:
        {
			setupControls();
			return (LRESULT) 1;
        }
        case WM_COMMAND:
        {
			switch(LOWORD(wParam))
			{
			case IDC_COM_ADDR_EDIT:
				if (HIWORD(wParam) == EN_CHANGE)
				{
					TCHAR sz[MS_MAXIMUM_ADDRESS_LENGTH];
					Edit_GetText(GetDlgItem(m_Dlg, IDC_COM_ADDR_EDIT), sz, MS_MAXIMUM_ADDRESS_LENGTH);
					strcpy(_address, sz);
					SetDirty();
				}
				break;
			case IDC_COM_PORT_EDIT:
				if (HIWORD(wParam) == EN_CHANGE)
				{
					TCHAR sz[STR_MAX_LENGTH];
					Edit_GetText(GetDlgItem(m_Dlg, IDC_COM_PORT_EDIT), sz, STR_MAX_LENGTH);
					_port = atoi(sz);
					SetDirty();
				}
				break;
			case IDC_COM_TTL_EDIT:
				if (HIWORD(wParam) == EN_CHANGE)
				{
					TCHAR sz[STR_MAX_LENGTH];
					Edit_GetText(GetDlgItem(m_Dlg, IDC_COM_TTL_EDIT), sz, STR_MAX_LENGTH);
					_ttl = atoi(sz);
					SetDirty();
				}
				break;
			}
			return (LRESULT) 1;
		}
        case WM_DESTROY:
        {
			shutdownControls();
            return (LRESULT) 1;
        }
		case WM_TIMER:
		{
			TCHAR sz[STR_MAX_LENGTH];
			flBool isOpen = false;
			_multicastSender->is_SocketOpen(&isOpen);
			strcpy(sz, isOpen ? "" : "~");
			Edit_SetText(GetDlgItem(m_Dlg, IDC_COM_OPENSTATUS_VALUE), sz);

			Sleep(0);

			return (LRESULT) 1;
		}

    }
    return CBasePropertyPage::OnReceiveMessage(hwnd,uMsg,wParam,lParam);
}
//------------------------------------------------------------------------------
HRESULT
CMulticastSenderComProp::OnConnect(IUnknown *pUnknown)
{
    ASSERT(_multicastSender == NULL);

    HRESULT hr = pUnknown->QueryInterface(IID_IMulticastSender, (void **) &_multicastSender);
    if (FAILED(hr))
	{
        return E_NOINTERFACE;
    }

    ASSERT(_multicastSender);

	_multicastSender->get_Address(_address);
	_multicastSender->get_Port(&_port);
	_multicastSender->get_TimeToLive(&_ttl);

    return NOERROR;
}
//------------------------------------------------------------------------------
HRESULT
CMulticastSenderComProp::OnDisconnect()
{
    if (_multicastSender == NULL)
	{
        return E_UNEXPECTED;
    }

    _multicastSender->Release();
    _multicastSender = NULL;

	return NOERROR;
}
//------------------------------------------------------------------------------
HRESULT
CMulticastSenderComProp::OnDeactivate(void)
{
	return NOERROR;
}
//------------------------------------------------------------------------------
HRESULT
CMulticastSenderComProp::OnApplyChanges()
{
	_multicastSender->put_Address(_address);
	_multicastSender->put_Port(_port);
	_multicastSender->put_TimeToLive(_ttl);

	m_bDirty = FALSE;
    return NOERROR;
}
//------------------------------------------------------------------------------
void
CMulticastSenderComProp::setupControls()
{
	// Setup Controls
	TCHAR   sz[32];
	
	Edit_SetText(GetDlgItem(m_Dlg, IDC_COM_ADDR_EDIT), _address);
	_stprintf(sz, "%d", _port);
	Edit_SetText(GetDlgItem(m_Dlg, IDC_COM_PORT_EDIT), sz);
	_stprintf(sz, "%d", _ttl);
	Edit_SetText(GetDlgItem(m_Dlg, IDC_COM_TTL_EDIT), sz);

	// Setup Timer
	_timer = SetTimer(m_Dlg, 0, 100, NULL);
}
//------------------------------------------------------------------------------
void
CMulticastSenderComProp::shutdownControls()
{
	// Shutdown Timer
	KillTimer(m_Dlg, _timer);
}
//------------------------------------------------------------------------------
