/*
**	Copyright (c) 2003-2004 National Institute of Multimedia Education. All rights reserved.
**	2-12 Wakaba, Mihama, Chiba, 261-0014 JAPAN
**	http://www.nime.ac.jp/
*/
//------------------------------------------------------------------------------
#ifndef __MulticastSenderComProp_h__
#define __MulticastSenderComProp_h__
//------------------------------------------------------------------------------
#include <initguid.h>
#include <olectl.h>
#if (1100 > _MSC_VER)
#include <olectlid.h>
#endif
#include <flTypes/flUIDs.h>
#include <flTypes/IMulticastSender.h>
#include <flBase/flBase.h>
//------------------------------------------------------------------------------
class CMulticastSenderComProp : public CBasePropertyPage
{

public:
    static CUnknown * WINAPI CreateInstance(LPUNKNOWN lpunk, HRESULT *phr);

private:
    CMulticastSenderComProp(LPUNKNOWN lpunk, HRESULT *phr);

private:
    void		SetDirty();

	BOOL		OnReceiveMessage(HWND hwnd,UINT uMsg,WPARAM wParam,LPARAM lParam);
    HRESULT		OnConnect(IUnknown *pUnknown);
    HRESULT		OnDisconnect();
    HRESULT		OnDeactivate();
    HRESULT		OnApplyChanges();

private:
	void		setupControls();
	void		shutdownControls();

private:
    IMulticastSender*	_multicastSender;
	UINT_PTR			_timer;

	flChar				_address[MS_MAXIMUM_ADDRESS_LENGTH];
	flUShort			_port;
	flULong				_ttl;
};
//------------------------------------------------------------------------------
#endif //__MulticastSenderComProp_h__
