/*
**	Copyright (c) 2003-2004 National Institute of Multimedia Education. All rights reserved.
**	2-12 Wakaba, Mihama, Chiba, 261-0014 JAPAN
**	http://www.nime.ac.jp/
*/
//------------------------------------------------------------------------------
#define WIN32_LEAN_AND_MEAN
#include <streams.h>

#include <flMulticastSender/MulticastSenderFrameProp.h>
#include <commctrl.h>
#include <tchar.h>
#include "resource.h"
//------------------------------------------------------------------------------
CUnknown * WINAPI CMulticastSenderFrameProp::CreateInstance(LPUNKNOWN lpunk, HRESULT *phr)
{
    CUnknown *punk = new CMulticastSenderFrameProp(lpunk, phr);
    if (punk == NULL)
	{
		*phr = E_OUTOFMEMORY;
    }
    return punk;
}
//------------------------------------------------------------------------------
CMulticastSenderFrameProp::CMulticastSenderFrameProp(LPUNKNOWN pUnk, HRESULT *phr) :
    CBasePropertyPage(NAME("MulticastSenderFrameProp"),pUnk,
                      IDD_MULTICASTSENDERFRAMEPROP,
                      IDS_MULTICASTSENDERFRAMEPROPTITLE),
    _multicastSender(NULL)
{
    InitCommonControls();
}
//------------------------------------------------------------------------------
void
CMulticastSenderFrameProp::SetDirty()
{
    m_bDirty = TRUE;
    if (m_pPageSite)
	{
        m_pPageSite->OnStatusChange(PROPPAGESTATUS_DIRTY);
    }
}
//------------------------------------------------------------------------------
BOOL
CMulticastSenderFrameProp::OnReceiveMessage(HWND hwnd,
                                           UINT uMsg,
                                           WPARAM wParam,
                                           LPARAM lParam)
{
    switch (uMsg)
    {
        case WM_INITDIALOG:
        {
			setupControls();
			return (LRESULT) 1;
        }
        case WM_COMMAND:
        {
			switch(LOWORD(wParam))
			{
			case IDC_STOPTRANSMIT_CHECK:
				if (HIWORD(wParam) == BN_CLICKED)
				{
					flInt checked = Button_GetCheck(GetDlgItem(m_Dlg, 
												IDC_STOPTRANSMIT_CHECK));
					_enableTransmit = (checked ? false : true);
					SetDirty();
				}
				break;
			case IDC_FRAME_PACKETSIZE_VALUE:
				if (HIWORD(wParam) == EN_CHANGE)
				{
					TCHAR sz[STR_MAX_LENGTH];
					Edit_GetText(GetDlgItem(m_Dlg, IDC_FRAME_PACKETSIZE_VALUE),
															sz, STR_MAX_LENGTH);
					_packetSize = atoi(sz);
					SetDirty();
				}
				break;
			case IDC_FRAME_MAXTRANSMITRATE_VALUE:
				if (HIWORD(wParam) == EN_CHANGE)
				{
					TCHAR sz[STR_MAX_LENGTH];
					Edit_GetText(GetDlgItem(m_Dlg, IDC_FRAME_MAXTRANSMITRATE_VALUE),
															sz, STR_MAX_LENGTH);
					_maximumTransmissionRate = atoi(sz);
					SetDirty();
				}
				break;
			case IDC_FRAME_REPEAT_VALUE:
				if (HIWORD(wParam) == EN_CHANGE)
				{
					TCHAR sz[STR_MAX_LENGTH];
					Edit_GetText(GetDlgItem(m_Dlg, IDC_FRAME_REPEAT_VALUE),
															sz, STR_MAX_LENGTH);
					_transmissionCount = atoi(sz);
					SetDirty();
				}
				break;
			case IDC_FRAME_SUSTEMBUFFER_VALUE:
				if (HIWORD(wParam) == EN_CHANGE)
				{
					TCHAR sz[STR_MAX_LENGTH];
					Edit_GetText(GetDlgItem(m_Dlg, IDC_FRAME_SUSTEMBUFFER_VALUE),
															sz, STR_MAX_LENGTH);
					_systemBufferSize = atoi(sz);
					SetDirty();
				}
				break;
			case IDC_FRAME_CLOCKPERIOD_VALUE:
				if (HIWORD(wParam) == EN_CHANGE)
				{
					TCHAR sz[STR_MAX_LENGTH];
					Edit_GetText(GetDlgItem(m_Dlg, IDC_FRAME_CLOCKPERIOD_VALUE),
															sz, STR_MAX_LENGTH);
					_clockMinimumPeriod = (flFloat)atof(sz);
					SetDirty();
				}
				break;
			case IDC_FRAME_GETCLOCKPERIOD_BUTTON:
				{
					flFloat clockMinimumPeriodOld;
					flFloat clockMinimumPeriod;

					_multicastSender->get_ClockMinimumPeriod(&clockMinimumPeriodOld);
					_multicastSender->compute_ClockMinimumPeriod();

					_multicastSender->get_ClockMinimumPeriod(&clockMinimumPeriod);
					TCHAR sz[STR_MAX_LENGTH];
					_stprintf(sz, "%5.5f", clockMinimumPeriod);
					Edit_SetText(GetDlgItem(m_Dlg, IDC_FRAME_CLOCKPERIOD_VALUE), sz);

					_multicastSender->put_ClockMinimumPeriod(clockMinimumPeriodOld);

					SetDirty();
				}
				break;
			}
			return (LRESULT) 1;
		}
        case WM_DESTROY:
        {
			shutdownControls();
            return (LRESULT) 1;
        }
		case WM_TIMER:
		{
			TCHAR sz[STR_MAX_LENGTH];

			LONGLONG absoluteTime;
			_multicastSender->get_AbsoluteTime(&absoluteTime);
			_stprintf(sz, "%I64d", (absoluteTime / 10000));
			Edit_SetText(GetDlgItem(m_Dlg, IDC_FRAME_ABSTIME_VALUE), sz);

			flUInt value;
			_multicastSender->get_TransmissionRate(&value);
			_stprintf(sz, "%d", (value / 1024));
			Edit_SetText(GetDlgItem(m_Dlg, IDC_FRAME_TRANSMITRATE_VALUE), sz);

			_multicastSender->get_FrameRate(&value);
			_stprintf(sz, "%d", value);
			Edit_SetText(GetDlgItem(m_Dlg, IDC_FRAME_FRAMERATE_VALUE), sz);

			_multicastSender->get_NumTotalPackets(&value);
			_stprintf(sz, "%d", value);
			Edit_SetText(GetDlgItem(m_Dlg, IDC_FRAME_TRANSMITPACKET_VALUE), sz);

			_multicastSender->get_NumTotalFrames(&value);
			_stprintf(sz, "%d", value);
			Edit_SetText(GetDlgItem(m_Dlg, IDC_FRAME_TRANSMITFRAME_VALUE), sz);

			Sleep(0);

			return (LRESULT) 1;
		}
    }
    return CBasePropertyPage::OnReceiveMessage(hwnd,uMsg,wParam,lParam);
}
//------------------------------------------------------------------------------
HRESULT
CMulticastSenderFrameProp::OnConnect(IUnknown *pUnknown)
{
    ASSERT(_multicastSender == NULL);

    HRESULT hr = pUnknown->QueryInterface(IID_IMulticastSender, (void **) &_multicastSender);
    if (FAILED(hr))
	{
        return E_NOINTERFACE;
    }

    ASSERT(_multicastSender);

	_multicastSender->get_EnableTransmit(&_enableTransmit);
	_multicastSender->get_MaximumPacketSize(&_packetSize);
	_multicastSender->get_MaximumTransmissionRate(&_maximumTransmissionRate);
	_multicastSender->get_TransmissionCount(&_transmissionCount);
	_multicastSender->get_SystemBufferSize(&_systemBufferSize);
	_multicastSender->get_ClockMinimumPeriod(&_clockMinimumPeriod);

	_maximumTransmissionRate /= 1024;
	_systemBufferSize /= 1024;

    return NOERROR;
}
//------------------------------------------------------------------------------
HRESULT
CMulticastSenderFrameProp::OnDisconnect()
{
    if (_multicastSender == NULL)
	{
        return E_UNEXPECTED;
    }

    _multicastSender->Release();
    _multicastSender = NULL;

	return NOERROR;
}
//------------------------------------------------------------------------------
HRESULT
CMulticastSenderFrameProp::OnDeactivate(void)
{
	return NOERROR;
}
//------------------------------------------------------------------------------
HRESULT
CMulticastSenderFrameProp::OnApplyChanges()
{
	_multicastSender->put_EnableTransmit(_enableTransmit);
	_multicastSender->put_MaximumPacketSize(_packetSize);
	_multicastSender->put_MaximumTransmissionRate(_maximumTransmissionRate * 1024);
	_multicastSender->put_TransmissionCount(_transmissionCount);
	_multicastSender->put_SystemBufferSize(_systemBufferSize * 1024);
	_multicastSender->put_ClockMinimumPeriod(_clockMinimumPeriod);

	m_bDirty = FALSE;
    return NOERROR;
}
//------------------------------------------------------------------------------
void
CMulticastSenderFrameProp::setupControls()
{
	// Setup Controls
	TCHAR   sz[128];

	Button_SetCheck(GetDlgItem(m_Dlg, IDC_STOPTRANSMIT_CHECK), !_enableTransmit);

	_stprintf(sz, "%d", _packetSize);
	Edit_SetText(GetDlgItem(m_Dlg, IDC_FRAME_PACKETSIZE_VALUE), sz);

	_stprintf(sz, "%d", _maximumTransmissionRate);
	Edit_SetText(GetDlgItem(m_Dlg, IDC_FRAME_MAXTRANSMITRATE_VALUE), sz);

	_stprintf(sz, "%d", _transmissionCount);
	Edit_SetText(GetDlgItem(m_Dlg, IDC_FRAME_REPEAT_VALUE), sz);

	_stprintf(sz, "%d", _systemBufferSize);
	Edit_SetText(GetDlgItem(m_Dlg, IDC_FRAME_SUSTEMBUFFER_VALUE), sz);

	_stprintf(sz, "%5.5f", _clockMinimumPeriod);
	Edit_SetText(GetDlgItem(m_Dlg, IDC_FRAME_CLOCKPERIOD_VALUE), sz);

	// Setup Timer
	_timer = SetTimer(m_Dlg, 0, 200, NULL);
}
//------------------------------------------------------------------------------
void
CMulticastSenderFrameProp::shutdownControls()
{
	// Shutdown Timer
	KillTimer(m_Dlg, _timer);
}
//------------------------------------------------------------------------------
