/*
**	Copyright (c) 2003-2004 National Institute of Multimedia Education. All rights reserved.
**	2-12 Wakaba, Mihama, Chiba, 261-0014 JAPAN
**	http://www.nime.ac.jp/
*/
//------------------------------------------------------------------------------
#define WIN32_LEAN_AND_MEAN
#include <streams.h>

#include <flMulticastSender/MulticastSenderMediaProp.h>
#include <commctrl.h>
#include "resource.h"
//------------------------------------------------------------------------------
CUnknown * WINAPI
CMulticastSenderMediaProp::CreateInstance(LPUNKNOWN lpunk, HRESULT *phr)
{
    CUnknown *punk = new CMulticastSenderMediaProp(lpunk, phr);
    if (punk == NULL)
	{
		*phr = E_OUTOFMEMORY;
    }
    return punk;
}
//------------------------------------------------------------------------------
CMulticastSenderMediaProp::CMulticastSenderMediaProp(LPUNKNOWN pUnk, HRESULT *phr) :
    CBasePropertyPage(NAME("MulticastSenderMediaProp"),pUnk,
                      IDD_MULTICASTSENDERMEDIAPROP,
                      IDS_MULTICASTSENDERMEDIAPROPTITLE),
    _multicastSender(NULL)
{
    InitCommonControls();
}
//------------------------------------------------------------------------------
void
CMulticastSenderMediaProp::SetDirty()
{
    m_bDirty = TRUE;
    if (m_pPageSite)
	{
        m_pPageSite->OnStatusChange(PROPPAGESTATUS_DIRTY);
    }
}
//------------------------------------------------------------------------------
BOOL
CMulticastSenderMediaProp::OnReceiveMessage(HWND hwnd,
                                           UINT uMsg,
                                           WPARAM wParam,
                                           LPARAM lParam)
{
    switch (uMsg)
    {
        case WM_INITDIALOG:
        {
			setupControls();
			return (LRESULT) 1;
        }
        case WM_COMMAND:
        {
			switch(LOWORD(wParam))
			{
			case IDC_MEDIA_ALLINPUT_RADIO:
				if(Button_GetCheck(GetDlgItem(m_Dlg, IDC_MEDIA_ALLINPUT_RADIO)))
				{
					_mediaType = IMulticastSender::MSMT_ALL;
					updateControlsEnabled();
					SetDirty();
				}
				break;
			case IDC_MEDIA_VIDEOINPUT_RADIO:
				if(Button_GetCheck(GetDlgItem(m_Dlg, IDC_MEDIA_VIDEOINPUT_RADIO)))
				{
					_mediaType = IMulticastSender::MSMT_VIDEO;
					updateControlsEnabled();
					SetDirty();
				}
				break;
			case IDC_MEDIA_AUDIOINPUT_RADIO:
				if(Button_GetCheck(GetDlgItem(m_Dlg, IDC_MEDIA_AUDIOINPUT_RADIO)))
				{
					_mediaType = IMulticastSender::MSMT_AUDIO;
					updateControlsEnabled();
					SetDirty();
				}
				break;
			case IDC_MEDIA_POINTERINPUT_RADIO:
				if(Button_GetCheck(GetDlgItem(m_Dlg, IDC_MEDIA_POINTERINPUT_RADIO)))
				{
					_mediaType = IMulticastSender::MSMT_POINTER;
					updateControlsEnabled();
					SetDirty();
				}
				break;
			case IDC_MEDIA_VIDEOFORMAT_COMBO:
				if (HIWORD(wParam) == CBN_SELCHANGE)
				{
					_videoFormat = ComboBox_GetCurSel(GetDlgItem(m_Dlg, 
												IDC_MEDIA_VIDEOFORMAT_COMBO));
					SetDirty();
				}
				break;
			case IDC_MEDIA_VIDEORESOLUTION_COMBO:
				if (HIWORD(wParam) == CBN_SELCHANGE)
				{
					_videoResolution = ComboBox_GetCurSel(GetDlgItem(m_Dlg, 
												IDC_MEDIA_VIDEORESOLUTION_COMBO));
					SetDirty();
				}
				break;
			case IDC_MEDIA_AUDIOFORMAT_COMBO:
				if (HIWORD(wParam) == CBN_SELCHANGE)
				{
					_audioFormat = ComboBox_GetCurSel(GetDlgItem(m_Dlg, 
												IDC_MEDIA_AUDIOFORMAT_COMBO));
					SetDirty();
				}
				break;
			case IDC_MEDIA_AUDIOFREQ_COMBO:
				if (HIWORD(wParam) == CBN_SELCHANGE)
				{
					_audioFrequency = ComboBox_GetCurSel(GetDlgItem(m_Dlg, 
												IDC_MEDIA_AUDIOFREQ_COMBO));
					SetDirty();
				}
				break;
			case IDC_MEDIA_AUDIOSTEREO_COMBO:
				if (HIWORD(wParam) == CBN_SELCHANGE)
				{
					_audioStereo = ComboBox_GetCurSel(GetDlgItem(m_Dlg, 
												IDC_MEDIA_AUDIOSTEREO_COMBO));
					SetDirty();
				}
				break;
			case IDC_MEDIA_AUDIOBITCOUNT_COMBO:
				if (HIWORD(wParam) == CBN_SELCHANGE)
				{
					_audioBitCount = ComboBox_GetCurSel(GetDlgItem(m_Dlg, 
												IDC_MEDIA_AUDIOBITCOUNT_COMBO));
					SetDirty();
				}
				break;
			}
			return (LRESULT) 1;
		}
        case WM_DESTROY:
        {
			shutdownControls();
            return (LRESULT) 1;
        }

    }
    return CBasePropertyPage::OnReceiveMessage(hwnd,uMsg,wParam,lParam);
}
//------------------------------------------------------------------------------
HRESULT
CMulticastSenderMediaProp::OnConnect(IUnknown *pUnknown)
{
    ASSERT(_multicastSender == NULL);

    HRESULT hr = pUnknown->QueryInterface(IID_IMulticastSender, (void **) &_multicastSender);
    if (FAILED(hr))
	{
        return E_NOINTERFACE;
    }

    ASSERT(_multicastSender);

	_multicastSender->get_MediaType(&_mediaType);
	_multicastSender->get_VideoFormat(&_videoFormat);
	_multicastSender->get_VideoResolution(&_videoResolution);
	_multicastSender->get_AudioFormat(&_audioFormat);
	_multicastSender->get_AudioFrequency(&_audioFrequency);
	_multicastSender->get_AudioStereo(&_audioStereo);
	_multicastSender->get_AudioBitCount(&_audioBitCount);

	return NOERROR;
}
//------------------------------------------------------------------------------
HRESULT
CMulticastSenderMediaProp::OnDisconnect()
{
    if (_multicastSender == NULL)
	{
        return E_UNEXPECTED;
    }

    _multicastSender->Release();
    _multicastSender = NULL;

	return NOERROR;
}
//------------------------------------------------------------------------------
HRESULT
CMulticastSenderMediaProp::OnDeactivate(void)
{
	return NOERROR;
}
//------------------------------------------------------------------------------
HRESULT
CMulticastSenderMediaProp::OnApplyChanges()
{
	_multicastSender->put_MediaType(_mediaType);

	_multicastSender->put_VideoFormat(_videoFormat);
	_multicastSender->put_VideoResolution(_videoResolution);

	_multicastSender->put_AudioFormat(_audioFormat);
	_multicastSender->put_AudioFrequency(_audioFrequency);
	_multicastSender->put_AudioStereo(_audioStereo);
	_multicastSender->put_AudioBitCount(_audioBitCount);

    m_bDirty = FALSE;
    return NOERROR;
}
//------------------------------------------------------------------------------
void
CMulticastSenderMediaProp::setupControls()
{
	// Setup Combo Box
	HWND dlgItem = GetDlgItem(m_Dlg, IDC_MEDIA_VIDEOFORMAT_COMBO);
	ComboBox_ResetContent(dlgItem);
	ComboBox_AddString(dlgItem, "RGB555(16bit)");
	ComboBox_AddString(dlgItem, "RGB24");
	ComboBox_AddString(dlgItem, "MPEG4 v2");
	ComboBox_AddString(dlgItem, "MPEG4 v3");
	ComboBox_AddString(dlgItem, "dvsd");
	ComboBox_AddString(dlgItem, "H.261");
	ComboBox_AddString(dlgItem, "H.263");
	ComboBox_AddString(dlgItem, "MJPEG");
	ComboBox_AddString(dlgItem, "S");
	ComboBox_SetCurSel(dlgItem, _videoFormat);

	dlgItem = GetDlgItem(m_Dlg, IDC_MEDIA_VIDEORESOLUTION_COMBO);
	ComboBox_ResetContent(dlgItem);
	ComboBox_AddString(dlgItem, "SQCIF(128x96)");
	ComboBox_AddString(dlgItem, "QCIF(176x144)");
	ComboBox_AddString(dlgItem, "CIF(352x288)");
	ComboBox_AddString(dlgItem, "160x120");
	ComboBox_AddString(dlgItem, "180x120");
	ComboBox_AddString(dlgItem, "320x240");
	ComboBox_AddString(dlgItem, "360x240");
	ComboBox_AddString(dlgItem, "640x480");
	ComboBox_AddString(dlgItem, "720x480");
	ComboBox_AddString(dlgItem, "800x600");
	ComboBox_AddString(dlgItem, "1024x768");
	ComboBox_AddString(dlgItem, "1280x1024");
	ComboBox_AddString(dlgItem, "1600x1200");
	ComboBox_AddString(dlgItem, "HDTV 720p");
	ComboBox_AddString(dlgItem, "HDTV 1080i");
	ComboBox_AddString(dlgItem, "SDTV 480p");
	ComboBox_AddString(dlgItem, "SDTV 480i");
	ComboBox_AddString(dlgItem, "S");
	ComboBox_SetCurSel(dlgItem, _videoResolution);

	dlgItem = GetDlgItem(m_Dlg, IDC_MEDIA_AUDIOFORMAT_COMBO);
	ComboBox_ResetContent(dlgItem);
	ComboBox_AddString(dlgItem, "MP3");
	ComboBox_AddString(dlgItem, "PCM");
	ComboBox_AddString(dlgItem, "MPEG1");
	ComboBox_AddString(dlgItem, "S");
	ComboBox_SetCurSel(dlgItem, _audioFormat);

	dlgItem = GetDlgItem(m_Dlg, IDC_MEDIA_AUDIOFREQ_COMBO);
	ComboBox_ResetContent(dlgItem);
	ComboBox_AddString(dlgItem, "8KHz");
	ComboBox_AddString(dlgItem, "11KHz");
	ComboBox_AddString(dlgItem, "16KHz");
	ComboBox_AddString(dlgItem, "22KHz");
	ComboBox_AddString(dlgItem, "44.1KHz");
	ComboBox_AddString(dlgItem, "48KHz");
	ComboBox_AddString(dlgItem, "S");
	ComboBox_SetCurSel(dlgItem, _audioFrequency);

	dlgItem = GetDlgItem(m_Dlg, IDC_MEDIA_AUDIOSTEREO_COMBO);
	ComboBox_ResetContent(dlgItem);
	ComboBox_AddString(dlgItem, "Stereo");
	ComboBox_AddString(dlgItem, "Monaural");
	ComboBox_AddString(dlgItem, "S");
	ComboBox_SetCurSel(dlgItem, _audioStereo);

	dlgItem = GetDlgItem(m_Dlg, IDC_MEDIA_AUDIOBITCOUNT_COMBO);
	ComboBox_ResetContent(dlgItem);
	ComboBox_AddString(dlgItem, "0bit");
	ComboBox_AddString(dlgItem, "8bit");
	ComboBox_AddString(dlgItem, "16bit");
	ComboBox_AddString(dlgItem, "S");
	ComboBox_SetCurSel(dlgItem, _audioBitCount);

	// Setup media type
	switch(_mediaType)
	{
	case IMulticastSender::MSMT_ALL:
		Button_SetCheck(GetDlgItem(m_Dlg, IDC_MEDIA_ALLINPUT_RADIO), true);
		break;
	case IMulticastSender::MSMT_VIDEO:
		Button_SetCheck(GetDlgItem(m_Dlg, IDC_MEDIA_VIDEOINPUT_RADIO), true);
		break;
	case IMulticastSender::MSMT_AUDIO:
		Button_SetCheck(GetDlgItem(m_Dlg, IDC_MEDIA_AUDIOINPUT_RADIO), true);
		break;
	case IMulticastSender::MSMT_POINTER:
		Button_SetCheck(GetDlgItem(m_Dlg, IDC_MEDIA_POINTERINPUT_RADIO), true);
		break;
	};

	updateControlsEnabled();
}
//------------------------------------------------------------------------------
void
CMulticastSenderMediaProp::shutdownControls()
{
}
//------------------------------------------------------------------------------
void
CMulticastSenderMediaProp::updateControlsEnabled()
{
	switch(_mediaType)
	{
	case IMulticastSender::MSMT_ALL:
		setEnableVideoControls(false);
		setEnableAudioControls(false);
		setEnablePointerInfoControls(false);
		break;
	case IMulticastSender::MSMT_VIDEO:
		setEnableVideoControls(true);
		setEnableAudioControls(false);
		setEnablePointerInfoControls(false);
		break;
	case IMulticastSender::MSMT_AUDIO:
		setEnableVideoControls(false);
		setEnableAudioControls(true);
		setEnablePointerInfoControls(false);
		break;
	case IMulticastSender::MSMT_POINTER:
		setEnableVideoControls(false);
		setEnableAudioControls(false);
		setEnablePointerInfoControls(true);
		break;
	}
}
//------------------------------------------------------------------------------
void
CMulticastSenderMediaProp::setEnableVideoControls(flBool flag)
{
	ComboBox_Enable(GetDlgItem(m_Dlg, IDC_MEDIA_VIDEOFORMAT_COMBO), flag);
	ComboBox_Enable(GetDlgItem(m_Dlg, IDC_MEDIA_VIDEORESOLUTION_COMBO), flag);
	Static_Enable(GetDlgItem(m_Dlg, IDC_MEDIA_VIDEOFORMAT_LABEL), flag);
	Static_Enable(GetDlgItem(m_Dlg, IDC_MEDIA_VIDEORESOLUTION_LABEL), flag);
}
//------------------------------------------------------------------------------
void
CMulticastSenderMediaProp::setEnableAudioControls(flBool flag)
{
	ComboBox_Enable(GetDlgItem(m_Dlg, IDC_MEDIA_AUDIOFORMAT_COMBO), flag);
	ComboBox_Enable(GetDlgItem(m_Dlg, IDC_MEDIA_AUDIOFREQ_COMBO), flag);
	ComboBox_Enable(GetDlgItem(m_Dlg, IDC_MEDIA_AUDIOSTEREO_COMBO), flag);
	ComboBox_Enable(GetDlgItem(m_Dlg, IDC_MEDIA_AUDIOBITCOUNT_COMBO), flag);
	Static_Enable(GetDlgItem(m_Dlg, IDC_MEDIA_AUDIOFORMAT_LABEL), flag);
	Static_Enable(GetDlgItem(m_Dlg, IDC_MEDIA_AUDIOFREQ_LABEL), flag);
	Static_Enable(GetDlgItem(m_Dlg, IDC_MEDIA_AUDIOSTEREO_LABEL), flag);
	Static_Enable(GetDlgItem(m_Dlg, IDC_MEDIA_AUDIOBITCOUNT_LABEL), flag);
}
//------------------------------------------------------------------------------
void
CMulticastSenderMediaProp::setEnablePointerInfoControls(flBool flag)
{
}
//------------------------------------------------------------------------------

