/*
**	Copyright (c) 2003-2004 National Institute of Multimedia Education. All rights reserved.
**	2-12 Wakaba, Mihama, Chiba, 261-0014 JAPAN
**	http://www.nime.ac.jp/
*/
//------------------------------------------------------------------------------
#ifndef __MulticastSenderMediaProp_h__
#define __MulticastSenderMediaProp_h__
//------------------------------------------------------------------------------
#include <initguid.h>
#include <olectl.h>
#if (1100 > _MSC_VER)
#include <olectlid.h>
#endif
#include <flTypes/flUIDs.h>
#include <flTypes/IMulticastSender.h>
#include <flBase/flBase.h>
//------------------------------------------------------------------------------
class CMulticastSenderMediaProp : public CBasePropertyPage
{

public:
    static CUnknown * WINAPI CreateInstance(LPUNKNOWN lpunk, HRESULT *phr);

private:
    CMulticastSenderMediaProp(LPUNKNOWN lpunk, HRESULT *phr);

private:
    void		SetDirty();

    BOOL		OnReceiveMessage(HWND hwnd,UINT uMsg,WPARAM wParam,LPARAM lParam);
    HRESULT		OnConnect(IUnknown *pUnknown);
    HRESULT		OnDisconnect();
    HRESULT		OnDeactivate();
    HRESULT		OnApplyChanges();

private:
	void		setupControls();
	void		shutdownControls();

	void		updateControlsEnabled();
	void		setEnableVideoControls(flBool flag);
	void		setEnableAudioControls(flBool flag);
	void		setEnablePointerInfoControls(flBool flag);

private:
    IMulticastSender*	_multicastSender;

	flInt				_mediaType;
	flInt				_videoFormat;
	flInt				_videoResolution;
	flInt				_audioFormat;
	flInt				_audioFrequency;
	flInt				_audioStereo;
	flInt				_audioBitCount;
};
//------------------------------------------------------------------------------
#endif //__MulticastSenderMediaProp_h__
