/*
**	Copyright (c) 2003-2004 National Institute of Multimedia Education. All rights reserved.
**	2-12 Wakaba, Mihama, Chiba, 261-0014 JAPAN
**	http://www.nime.ac.jp/
*/
//------------------------------------------------------------------------------
#define WIN32_LEAN_AND_MEAN
#include <streams.h>

#include <flMulticastSender/MulticastSenderUserProp.h>
#include <commctrl.h>
#include <tchar.h>
#include "resource.h"
//------------------------------------------------------------------------------
CUnknown * WINAPI CMulticastSenderUserProp::CreateInstance(LPUNKNOWN lpunk, HRESULT *phr)
{
    CUnknown *punk = new CMulticastSenderUserProp(lpunk, phr);
    if (punk == NULL)
	{
		*phr = E_OUTOFMEMORY;
    }
    return punk;
}
//------------------------------------------------------------------------------
CMulticastSenderUserProp::CMulticastSenderUserProp(LPUNKNOWN pUnk, HRESULT *phr) :
    CBasePropertyPage(NAME("MulticastSenderUserProp"),pUnk,
                      IDD_MULTICASTSENDERUSERPROP,
                      IDS_MULTICASTSENDERUSERPROPTITLE),
    _multicastSender(NULL)
{
    InitCommonControls();
}
//------------------------------------------------------------------------------
void
CMulticastSenderUserProp::SetDirty()
{
    m_bDirty = TRUE;
    if (m_pPageSite)
	{
        m_pPageSite->OnStatusChange(PROPPAGESTATUS_DIRTY);
    }
}
//------------------------------------------------------------------------------
BOOL
CMulticastSenderUserProp::OnReceiveMessage(HWND hwnd,
                                           UINT uMsg,
                                           WPARAM wParam,
                                           LPARAM lParam)
{
    switch (uMsg)
    {
        case WM_INITDIALOG:
        {
			setupControls();
			return (LRESULT) 1;
        }
        case WM_COMMAND:
        {
			switch(LOWORD(wParam))
			{
			case IDC_USER_USERDATA_EDIT:
				if (HIWORD(wParam) == EN_CHANGE)
				{
					TCHAR sz[1024];
					Edit_GetText(GetDlgItem(m_Dlg, IDC_USER_USERDATA_EDIT), sz, 1024);
					sz[1023] = 0;

					_userDataSize = sizeof(TCHAR) * _tcslen(sz) + 1;
					if (MS_MAXIMUM_USERDATA_SIZE < _userDataSize)
						_userDataSize = MS_MAXIMUM_USERDATA_SIZE;
					memcpy(_userData, sz, _userDataSize);
					
					SetDirty();
				}
				break;
			}
			return (LRESULT) 1;
		}
        case WM_DESTROY:
        {
			shutdownControls();
            return (LRESULT) 1;
        }
    }
    return CBasePropertyPage::OnReceiveMessage(hwnd,uMsg,wParam,lParam);
}
//------------------------------------------------------------------------------
HRESULT
CMulticastSenderUserProp::OnConnect(IUnknown *pUnknown)
{
    ASSERT(_multicastSender == NULL);

    HRESULT hr = pUnknown->QueryInterface(IID_IMulticastSender, (void **) &_multicastSender);
    if (FAILED(hr))
	{
        return E_NOINTERFACE;
    }

    ASSERT(_multicastSender);

	memset((void *)_userData, 0, MS_MAXIMUM_USERDATA_SIZE);
	_multicastSender->get_UserData(_userData, &_userDataSize);

    return NOERROR;
}
//------------------------------------------------------------------------------
HRESULT
CMulticastSenderUserProp::OnDisconnect()
{
    if (_multicastSender == NULL)
	{
        return E_UNEXPECTED;
    }

    _multicastSender->Release();
    _multicastSender = NULL;

	return NOERROR;
}
//------------------------------------------------------------------------------
HRESULT
CMulticastSenderUserProp::OnDeactivate(void)
{
	return NOERROR;
}
//------------------------------------------------------------------------------
HRESULT
CMulticastSenderUserProp::OnApplyChanges()
{
	_multicastSender->put_UserData(_userData, _userDataSize);

	m_bDirty = FALSE;
    return NOERROR;
}
//------------------------------------------------------------------------------
void
CMulticastSenderUserProp::setupControls()
{
	// Setup Controls
	TCHAR   sz[1024];

	memcpy(sz, _userData, MS_MAXIMUM_USERDATA_SIZE);
	sz[MS_MAXIMUM_USERDATA_SIZE] = 0;
	Edit_SetText(GetDlgItem(m_Dlg, IDC_USER_USERDATA_EDIT), sz);

	_stprintf(sz, "[Uf[^ (ő%d)", MS_MAXIMUM_USERDATA_SIZE);
	Static_SetText(GetDlgItem(m_Dlg, IDC_USER_USERDATA_LABEL), sz);
}
//------------------------------------------------------------------------------
void
CMulticastSenderUserProp::shutdownControls()
{
}
//------------------------------------------------------------------------------
