/*
**	Copyright (c) 2003-2004 National Institute of Multimedia Education. All rights reserved.
**	2-12 Wakaba, Mihama, Chiba, 261-0014 JAPAN
**	http://www.nime.ac.jp/
*/
//------------------------------------------------------------------------------
#ifndef __MulticastSenderUserProp_h__
#define __MulticastSenderUserProp_h__
//------------------------------------------------------------------------------
#include <initguid.h>
#include <olectl.h>
#if (1100 > _MSC_VER)
#include <olectlid.h>
#endif
#include <flTypes/flUIDs.h>
#include <flTypes/IMulticastSender.h>
#include <flBase/flBase.h>
//------------------------------------------------------------------------------
class CMulticastSenderUserProp : public CBasePropertyPage
{

public:
    static CUnknown * WINAPI CreateInstance(LPUNKNOWN lpunk, HRESULT *phr);

private:
    CMulticastSenderUserProp(LPUNKNOWN lpunk, HRESULT *phr);

private:
    void		SetDirty();

    BOOL		OnReceiveMessage(HWND hwnd,UINT uMsg,WPARAM wParam,LPARAM lParam);
    HRESULT		OnConnect(IUnknown *pUnknown);
    HRESULT		OnDisconnect();
    HRESULT		OnDeactivate();
    HRESULT		OnApplyChanges();

private:
	void		setupControls();
	void		shutdownControls();

private:
    IMulticastSender*	_multicastSender;

	flByte				_userData[MS_MAXIMUM_USERDATA_SIZE];
	flUInt				_userDataSize;
};
//------------------------------------------------------------------------------
#endif //__MulticastSenderUserProp_h__
