/*
**	Copyright (c) 2003-2004 National Institute of Multimedia Education. All rights reserved.
**	2-12 Wakaba, Mihama, Chiba, 261-0014 JAPAN
**	http://www.nime.ac.jp/
*/
//------------------------------------------------------------------------------
#ifndef __flFMT_h__
#define __flFMT_h__
//------------------------------------------------------------------------------
#include <flBase/flBase.h>
//------------------------------------------------------------------------------
#define FMT_APPID_ANY					0
//------------------------------------------------------------------------------
#define FMT_DATA_PACKET_MIN_SIZE		128			// in byte
#define FMT_DATA_PACKET_MAX_SIZE		8192		// in byte
#define FMT_COMMAND_PACKET_SIZE			64			// in byte
//------------------------------------------------------------------------------
#pragma pack(push, for_pack_1)
#pragma pack(1)
//------------------------------------------------------------------------------
#define FMT_PACKET_ID1			0xfdfdfdfd
#define FMT_PACKET_ID2			0xdfdfdfdf
//------------------------------------------------------------------------------
#define FMT_SENDBEGIN_CMD		0xaaaaaaaa
#define FMT_DATA				0xeeeeeeee
//------------------------------------------------------------------------------
#define IS_FMT_PACKET(__data)						\
	(												\
	((flUInt *)__data)[0] == FMT_PACKET_ID1 &&		\
	((flUInt *)__data)[1] == FMT_PACKET_ID2			\
	)
//------------------------------------------------------------------------------
#define IS_SENDBEGIN_CMD(__data)					\
	(												\
	((flUInt *)__data)[0] == FMT_PACKET_ID1 &&		\
	((flUInt *)__data)[1] == FMT_PACKET_ID2 &&		\
	((flUInt *)__data)[2] == FMT_SENDBEGIN_CMD		\
	)
//------------------------------------------------------------------------------
#define IS_DATA(__data)								\
	(												\
	((flUInt *)__data)[0] == FMT_PACKET_ID1 &&		\
	((flUInt *)__data)[1] == FMT_PACKET_ID2 &&		\
	((flUInt *)__data)[2] == FMT_DATA				\
	)
//------------------------------------------------------------------------------
struct FMTPacketHeader
{
	flUInt FMTPacketID1;
	flUInt FMTPacketID2;

	flUInt	_commandId;

public:
	FMTPacketHeader()
	{
		FMTPacketID1 = FMT_PACKET_ID1;
		FMTPacketID2 = FMT_PACKET_ID2;
	}
};
//------------------------------------------------------------------------------
struct FMTSendBeginCmd
{
	FMTPacketHeader _header;

	flUInt	_appId;

	flUInt	_dataId;
	flUInt	_dataSize;
	flUInt	_dataPacketSize;
	flUInt	_numPackets;

public:
	FMTSendBeginCmd()
	{
		_header._commandId = FMT_SENDBEGIN_CMD;

		_appId = 0;

		_dataId = 0;
		_dataSize = 0;
		_dataPacketSize = 0;
		_numPackets = 0;
	}
};
//------------------------------------------------------------------------------
struct FMTDataPacket
{
	FMTPacketHeader _header;
	flUInt			_dataId;
	flUInt			_numPackets;
	flUInt			_packetId;
	flUInt			_pos;
	flUInt			_size;
	flBool			_end;

public:
	FMTDataPacket()
	{
		_header._commandId = FMT_DATA;

		_dataId = 0;
		_numPackets = 0;
		_packetId = 0;
		_pos = 0;
		_size = 0;
		_end = false;
	}
};
//------------------------------------------------------------------------------
#pragma pack(pop, for_pack_1)
//------------------------------------------------------------------------------
#endif	//__flFMT_h__
