/*
**	Copyright (c) 2003-2004 National Institute of Multimedia Education. All rights reserved.
**	2-12 Wakaba, Mihama, Chiba, 261-0014 JAPAN
**	http://www.nime.ac.jp/
*/
//------------------------------------------------------------------------------
#include "Stdafx.h"
#include <flNetwork/flFMTData.h>
//------------------------------------------------------------------------------
#define DEF_ID				0
#define DEF_PACKETSIZE		1024
//------------------------------------------------------------------------------
flFMTDataEncoder::flFMTDataEncoder()
{
	_id = DEF_ID;
	_packetSize = DEF_PACKETSIZE;

	_numPackets	= 0;
	_packets.setSize(0);
	_packets.setBufferSize(1024);
	_packets.setGrowSize(1024);
}
//------------------------------------------------------------------------------
flFMTDataEncoder::~flFMTDataEncoder()
{
	for(flUInt i = 0; i < _packets.getSize(); i++)
		delete _packets[i];
	_packets.clear();
}
//------------------------------------------------------------------------------
void
flFMTDataEncoder::setPacketSize(flUInt packetSize)
{
	_packetSize = packetSize;

	if (_packetSize < FMT_DATA_PACKET_MIN_SIZE)
		_packetSize = FMT_DATA_PACKET_MIN_SIZE;
	else if (FMT_DATA_PACKET_MAX_SIZE < _packetSize)
		_packetSize = FMT_DATA_PACKET_MAX_SIZE;

	for(flUInt i = 0; i < _packets.getSize(); i++)
		delete _packets[i];
	_packets.setSize(0);
}
//------------------------------------------------------------------------------
flUInt
flFMTDataEncoder::getPacketSize() const
{
	return _packetSize;
}
//------------------------------------------------------------------------------
void
flFMTDataEncoder::setData(const flChar* data, flUInt dataSize)
{
	_id++;

	FMTDataPacket dataPacket;

	flUInt packetHeaderSize = sizeof(FMTDataPacket);
	flUInt packetDataSize = _packetSize - packetHeaderSize;

	const flChar* srcPtr = data;
	flChar* destPtr = NULL;

	_numPackets = 0;

	while(srcPtr < data + dataSize)
	{
		if (data + dataSize <= srcPtr + packetDataSize)
			packetDataSize = data + dataSize - srcPtr;

		// Get Current Data Packet
		if (_packets.getSize() <= _numPackets)
			_packets.add(new flChar[_packetSize]);
		destPtr = _packets[_numPackets];

		// Setup Data Header
		dataPacket._dataId = _id;
		dataPacket._packetId = _numPackets;
		dataPacket._pos = srcPtr - data;
		dataPacket._size = packetDataSize;
		dataPacket._end = false;

		// copy Header
		memcpy(destPtr, &dataPacket, packetHeaderSize);

		destPtr += packetHeaderSize;

		// copy Data
		memcpy(destPtr, srcPtr, packetDataSize);

		_numPackets++;
		srcPtr += packetDataSize;
	}

	for(flUInt i = 0; i < _numPackets; i++)
		((FMTDataPacket *)_packets[i])->_numPackets = _numPackets;
}
//------------------------------------------------------------------------------
flUInt
flFMTDataEncoder::getId() const
{
	return _id;
}
//------------------------------------------------------------------------------
flUInt
flFMTDataEncoder::getNumPackets() const
{
	return _numPackets;
}
//------------------------------------------------------------------------------
flChar*
flFMTDataEncoder::getPacket(flUInt index)
{
	assert(index < _numPackets);
	return _packets[index];
}
//------------------------------------------------------------------------------

//------------------------------------------------------------------------------
flFMTDataDecoder::flFMTDataDecoder()
{
	_id = 0;
	_size = 0;
	_numPackets = 0;

	_array = NULL;
	_arraySize = 0;

	_checks.setBufferSize(256);
	_checks.setGrowSize(256);
	_checks.setSize(0);
	_numSetPackets = 0;
}
//------------------------------------------------------------------------------
flFMTDataDecoder::~flFMTDataDecoder()
{
	delete _array;
}
//------------------------------------------------------------------------------
void
flFMTDataDecoder::getData(flChar*& data, flUInt& dataSize)
{
	data = _array;
	dataSize = _size;
}
//------------------------------------------------------------------------------
void
flFMTDataDecoder::reset(flUInt id, flUInt size, flUInt numPackets)
{
	_id = id;
	_size = size;
	_numPackets = numPackets;

	if (_arraySize < size)
	{
		delete _array;

		_arraySize = size;
		_array = new flChar[_arraySize];
	}

	memset(_array, 0, sizeof(flChar) * _size);

	_checks.setSize(_numPackets);
	for(flUInt i = 0; i < _checks.getSize(); i++)
		_checks[i] = false;
	_numSetPackets = 0;
}
//------------------------------------------------------------------------------
void
flFMTDataDecoder::setPacket(flChar* packet)
{
	FMTDataPacket *dataPacket = (FMTDataPacket *)packet;
	flUInt packetId = dataPacket->_packetId;

	if (_id != dataPacket->_dataId ||
		_checks.getSize() < packetId)
		return ;

	if (!_checks[packetId])
	{
		_checks[packetId] = true;
		memcpy(_array + dataPacket->_pos, packet + sizeof(FMTDataPacket), dataPacket->_size);

		_numSetPackets++;
	}
}
//------------------------------------------------------------------------------
flBool
flFMTDataDecoder::completeData()
{
	return (_numSetPackets == _numPackets);
}
//------------------------------------------------------------------------------
flUInt
flFMTDataDecoder::getId() const
{
	return _id;
}
//------------------------------------------------------------------------------
flUInt
flFMTDataDecoder::getNumSetPacket() const
{
	return _numSetPackets;
}
//------------------------------------------------------------------------------
