/*
**	Copyright (c) 2003-2004 National Institute of Multimedia Education. All rights reserved.
**	2-12 Wakaba, Mihama, Chiba, 261-0014 JAPAN
**	http://www.nime.ac.jp/
*/
//------------------------------------------------------------------------------
#ifndef __flFMTData_h__
#define __flFMTData_h__
//------------------------------------------------------------------------------
#include <flNetwork/flFMT.h>
#include <flBase/flArray.h>
#include <flBase/flCriticalSection.h>
//------------------------------------------------------------------------------
class flFMTDataEncoder
{
public:
	flFMTDataEncoder();
	virtual ~flFMTDataEncoder();

public:
	void		setData(const flChar* data, flUInt dataSize);

public:
	void		setPacketSize(flUInt packetSize);
	flUInt		getPacketSize() const;

public:
	flUInt		getId() const;
	flUInt		getNumPackets() const;
	flChar*		getPacket(flUInt index);

protected:
	flUInt				_id;
	flUInt				_packetSize;

	flUInt				_numPackets;
	flArray<flChar*>	_packets;
};
//------------------------------------------------------------------------------
class flFMTDataDecoderPool;
//------------------------------------------------------------------------------
class flFMTDataDecoder
{
	friend class flFMTDataDecoderPool;

public:
	flFMTDataDecoder();
	virtual ~flFMTDataDecoder();

public:
	void		getData(flChar*& data, flUInt& dataSize);

public:
	void		reset(flUInt id, flUInt size, flUInt numPackets);

	void		setPacket(flChar* packet);
	flBool		completeData();

public:
	flUInt		getId() const;
	flUInt		getNumSetPacket() const;

protected:
	flUInt				_id;
	flUInt				_size;
	flUInt				_numPackets;

	flChar*				_array;
	flUInt				_arraySize;

	flArray<flBool>		_checks;
	flUInt				_numSetPackets;
};
//------------------------------------------------------------------------------
#endif //__flFMTData_h__
