/*
**	Copyright (c) 2003-2004 National Institute of Multimedia Education. All rights reserved.
**	2-12 Wakaba, Mihama, Chiba, 261-0014 JAPAN
**	http://www.nime.ac.jp/
*/
//------------------------------------------------------------------------------
#ifndef __flFMTReceiver_h__
#define __flFMTReceiver_h__
//------------------------------------------------------------------------------
#include <flNetwork/flMulticastGroup.h>
#include <flNetwork/flFMTTimeKeeper.h>
#include <flNetwork/flFMTValueRate.h>
#include <flNetwork/flFMTData.h>
#include <flBase/flString.h>
#include <flBase/flCriticalSection.h>
#include <flBase/flThread.h>
#include <flBase/flHash.h>
//------------------------------------------------------------------------------
class flFMTReceiver
{
public:
	typedef void (__stdcall *ReceiveProc)(flChar *data, flUInt dataSize, void* receiveParam);

public:
	flFMTReceiver(flUInt appID = FMT_APPID_ANY);
	virtual ~flFMTReceiver();

public:
	void			setReceiveProc(ReceiveProc receiveProc, void *receiveParam);

public:
	flBool			receive(flChar*& data, flUInt& dataSize);

public:
	// Parameters
	void			setAddress(const flString& address);
	const flString&	getAddress() const;

	void			setPort(flUShort port);
	flUShort		getPort() const;

	void			setTimeToLive(flULong ttl);
	flULong			getTimeToLive() const;

	void			setTryUnicast(flBool flag);
	flBool			getTryUnicast() const;

	flUInt			getNumRejectionAddress() const;
	const flString&	getRejectionAddress(const flUInt index);
	void			addRejectionAddress(const flString& address);
	void			removeRejectionAddress(flUInt index);
	void			removeAllRejectionAddress();

public:
	// Multicast group Status
	flBool			isOpen() const;
	flBool			open();
	flBool			close();

public:
	// Monitor
	flString		getSenderAddress();
	flUInt			getPacketSize() const;
	flUInt			getReceiveBitRate();
	flUInt			getReceiveDataRate();
	flUInt			getNumReceivedDatas() const;
	flUInt			getNumReceivedPackets() const;
	flUInt			getNumDropDatas() const;
	flUInt			getNumDropPackets() const;
	void			resetMonitorVariables();

private:
	flUInt			receiveLoop();
	static flUInt __stdcall	receiveLoopProc(void* data);

protected:
	// Multicast group
	flMulticastGroup*			_multicastGroup;

	// Multicast group Parameters
	flString					_address;
	flUShort					_port;
	flULong						_ttl;
	flBool						_tryUnicast;

	// Multicast group Status
	flBool						_isOpen;

	// Monitor
	flString					_senderAddress;
	flUInt						_packetSize;
	flFMTValueRate				_bytesRate;
	flFMTValueRate				_datasRate;
	flUInt						_numReceivedDatas;
	flUInt						_numReceivedPackets;
	flUInt						_numDropDatas;
	flUInt						_numDropPackets;

	// Receive Thread
	flThread*					_receiveThread;
	flBool						_receiveThreadRun;

	// Callback function
	ReceiveProc					_receiveProc;
	void*						_receiveParam;

	// Data
	flFMTDataDecoder*			_dataDecoder;

	// Application ID
	flUInt						_appID;

	// Rejection address list
	flHashMap<flString,flString>	_rejectAddressList;
	flBool							_rejectOn;
};
//------------------------------------------------------------------------------
#endif //__flFMTReceiver_h__
