/*
**	Copyright (c) 2003-2004 National Institute of Multimedia Education. All rights reserved.
**	2-12 Wakaba, Mihama, Chiba, 261-0014 JAPAN
**	http://www.nime.ac.jp/
*/
//------------------------------------------------------------------------------
#ifndef __flFMTSender_h__
#define __flFMTSender_h__
//------------------------------------------------------------------------------
#include <flNetwork/flMulticastGroup.h>
#include <flNetwork/flFMTTimeKeeper.h>
#include <flNetwork/flFMTValueRate.h>
#include <flNetwork/flFMTData.h>
#include <flBase/flString.h>
#include <flBase/flCriticalSection.h>
#include <flBase/flThread.h>
#include <flBase/flArray.h>
//------------------------------------------------------------------------------
class flFMTSender
{
public:
	flFMTSender(flUInt appID = FMT_APPID_ANY);
	virtual ~flFMTSender();

public:
	// Multicast group Parameters
	void			setAddress(const flString& address);
	const flString&	getAddress() const;

	void			setPort(flUShort port);
	flUShort		getPort() const;

	void			setTimeToLive(flULong ttl);
	flULong			getTimeToLive() const;

	void			setTryUnicast(flBool flag);
	flBool			getTryUnicast() const;

public:
	// Multicast group Status
	flBool			isOpen() const;
	flBool			open();
	flBool			close();

public:
	// Flow Control Parameters
	void			setTransmissionCount(flUInt count);
	flUInt			getTransmissionCount() const;

	void			setMaximumTransmissionRate(flUInt bitPerSec);
	flUInt			getMaximumTransmissionRate() const;

	void			setSystemBufferSize(flUInt bit);
	flUInt			getSystemBufferSize() const;

	void			setClockMinimumPeriod(flFloat second);
	flFloat			getClockMinimumPeriod() const;
	void			computeClockMinimumPeriod();

	void			setPacketSize(flUInt byte);
	flUInt			getPacketSize() const;

public:
	// Monitor
	flUInt			getTransmissionBitRate();
	flUInt			getTransmissionDataRate();
	flUInt			getNumSendDatas() const;
	flUInt			getNumSendPackets() const;
	void			resetMonitorVariables();

public:
	flBool			send(const flChar* data, flUInt dataSize);

protected:
	// Multicast group
	flMulticastGroup*		_multicastGroup;

	// Multicast group Parameters
	flString				_address;
	flUShort				_port;
	flULong					_ttl;
	flBool					_tryUnicast;

	// Multicast group Status
	flBool					_isOpen;

	// Flow Control Parameters
	flUInt					_transmissionCount;
	flFMTTimeKeeper			_timeKeeper;

	// Monitor
	flFMTValueRate			_bytesRate;
	flFMTValueRate			_datasRate;
	flUInt					_numSendDatas;
	flUInt					_numSendPackets;

	// Commands
	FMTSendBeginCmd			_sendBeginCmd;

	// Data
	flFMTDataEncoder*		_dataEncoder;
};
//------------------------------------------------------------------------------
#endif //__flFMTSender_h__
