/*
**	Copyright (c) 2003-2004 National Institute of Multimedia Education. All rights reserved.
**	2-12 Wakaba, Mihama, Chiba, 261-0014 JAPAN
**	http://www.nime.ac.jp/
*/
//------------------------------------------------------------------------------
#include "Stdafx.h"
#include <flNetwork/flFMTTimeKeeper.h>
//------------------------------------------------------------------------------
#define DEF_MAXIMUMTRANSMISSIONRATE	10485760
#define DEF_SYSTEMBUFFERSIZE		131072
#define DEF_CLOCKMINIMUMPERIOD		1
//------------------------------------------------------------------------------
flFMTTimeKeeper::flFMTTimeKeeper()
{
	_maximumTransmissionRate	= DEF_MAXIMUMTRANSMISSIONRATE;
	_systemBufferSize			= DEF_SYSTEMBUFFERSIZE;
	_clockMinimumPeriod			= DEF_CLOCKMINIMUMPERIOD;

	_counter					= 0;
	_t0							= 0.0;

	_absTime					= new flSystemTime();

#ifndef USE_BUSYWAIT
	_acc						= 0.0;
#endif
}
//------------------------------------------------------------------------------
flFMTTimeKeeper::~flFMTTimeKeeper()
{
	delete _absTime;
}
//------------------------------------------------------------------------------
void
flFMTTimeKeeper::setMaximumTransmissionRate(flUInt bitPerSec)
{
	if (bitPerSec < 1)
		bitPerSec = 1;

	_maximumTransmissionRate = bitPerSec;
}
//------------------------------------------------------------------------------
flUInt
flFMTTimeKeeper::getMaximumTransmissionRate() const
{
	return _maximumTransmissionRate;
}
//------------------------------------------------------------------------------
void
flFMTTimeKeeper::setSystemBufferSize(flUInt bit)
{
	if (bit < 1)
		bit = 1;

	_systemBufferSize = bit;
}
//------------------------------------------------------------------------------
flUInt
flFMTTimeKeeper::getSystemBufferSize() const
{
	return _systemBufferSize;
}
//------------------------------------------------------------------------------
void
flFMTTimeKeeper::setClockMinimumPeriod(flDouble second)
{
	_clockMinimumPeriod = second;
}
//------------------------------------------------------------------------------
flDouble
flFMTTimeKeeper::getClockMinimumPeriod() const
{
	return _clockMinimumPeriod;
}
//------------------------------------------------------------------------------
void
flFMTTimeKeeper::computeClockMinimumPeriod()
{
	_absTime->update();
	flInt64 beginTime = _absTime->getTime();
	for(flUInt i = 0; i < 100; i++)
		Sleep(1);

	_absTime->update();
	flDouble dval = flDouble(_absTime->getTime() - beginTime);

	_clockMinimumPeriod = dval / (10.0 * 1000.0 * 1000.0 * 1000.0) * 10.0;
	if (_clockMinimumPeriod < 0.001)
		_clockMinimumPeriod = 0.001;
}
//------------------------------------------------------------------------------
void
flFMTTimeKeeper::start()
{
	_counter = 0;

#ifdef USE_BUSYWAIT
	_absTime->update();
	_t0 = flDouble(_absTime->getTime()) / 10000000.0;
#else
	_acc = 0.0;
	_t0 = (flDouble)timeGetTime() / 1000.0;
#endif
}
//------------------------------------------------------------------------------
