/*
**	Copyright (c) 2003-2004 National Institute of Multimedia Education. All rights reserved.
**	2-12 Wakaba, Mihama, Chiba, 261-0014 JAPAN
**	http://www.nime.ac.jp/
*/
//------------------------------------------------------------------------------
#ifndef __flFMTTimeKeeper_h__
#define __flFMTTimeKeeper_h__
//------------------------------------------------------------------------------
#define USE_BUSYWAIT
//------------------------------------------------------------------------------
#include <flNetwork/flNetwork.h>
#include <flBase/flSystemTime.h>
#include <flBase/flBase.h>
#include <math.h>
#ifndef USE_BUSYWAIT
#include <mmsystem.h>
#endif
//------------------------------------------------------------------------------
#define IP_HEADER_SIZE			160		// bit
#define UDP_HEADER_SIZE			64		// bit
//------------------------------------------------------------------------------
class flFMTTimeKeeper
{
public:
	flFMTTimeKeeper();
	virtual ~flFMTTimeKeeper();

public:
	void		setMaximumTransmissionRate(flUInt bitPerSec);
	flUInt		getMaximumTransmissionRate() const;

	void		setSystemBufferSize(flUInt bit);
	flUInt		getSystemBufferSize() const;

	void		setClockMinimumPeriod(flDouble second);
	flDouble	getClockMinimumPeriod() const;
	void		computeClockMinimumPeriod();

public:
	void		start();
	void		adjustRate(flUInt packetSizeByte);

protected:
	flUInt			_maximumTransmissionRate;			// bit per sec
	flUInt			_systemBufferSize;					// bit
	flDouble		_clockMinimumPeriod;				// sec

	flUInt			_counter;
	flDouble		_t0;

	flAbsoluteTime*	_absTime;

#ifndef USE_BUSYWAIT
	flDouble		_acc;
#endif
};
//------------------------------------------------------------------------------
#include <flNetwork/flFMTTimeKeeper.inl>
//------------------------------------------------------------------------------
#endif //__flFMTTimeKeeper_h__
