/*
**	Copyright (c) 2003-2004 National Institute of Multimedia Education. All rights reserved.
**	2-12 Wakaba, Mihama, Chiba, 261-0014 JAPAN
**	http://www.nime.ac.jp/
*/
//------------------------------------------------------------------------------
#ifndef __flFMTTimeKeeper_inl__
#define __flFMTTimeKeeper_inl__
//------------------------------------------------------------------------------
#ifdef USE_BUSYWAIT
//------------------------------------------------------------------------------
#define TO_100NANOSECOND(__second)	flInt64((__second) * 10000000.0)
#define TO_SECOND(__100nanosec)		(flDouble(__100nanosec) / 10000000.0)
//------------------------------------------------------------------------------
inline void
flFMTTimeKeeper::adjustRate(flUInt packetSizeByte)
{
	flDouble ipDgram = flDouble(IP_HEADER_SIZE + UDP_HEADER_SIZE + packetSizeByte * 8);
	flDouble maxRate = (flDouble)_maximumTransmissionRate;

	// Get Current time
	_absTime->update();
	flDouble t = TO_SECOND(_absTime->getTime());

	// Compute Sleep time
	flDouble sleepTime = (ipDgram / maxRate) - (t - _t0);

	if (0.0 < sleepTime)
	{
		flDouble fval = floor(sleepTime * 1000.0);

		// Sleep 
		Sleep((flULong)fval);

		fval *= 0.001;
		flInt64 sval = TO_100NANOSECOND(sleepTime - fval);

		// Busy Wait
		_absTime->update();
		flInt64 busyBegin = _absTime->getTime();
		do {
			_absTime->update();
			Sleep(0);
		}
		while(_absTime->getTime() - busyBegin < sval);
	}
	else
	{
		for(flUInt i = 0; i < 10; i++)
			Sleep(0);
	}

	_absTime->update();
	_t0 = TO_SECOND(_absTime->getTime());
}
//------------------------------------------------------------------------------
#else
//------------------------------------------------------------------------------
#define TO_MILLISECOND(__second)	flULong((__second) * 1000.0)
#define TO_SECOND(__millisecond)	(flDouble(__millisecond) / 1000.0)
//------------------------------------------------------------------------------
inline void
flFMTTimeKeeper::adjustRate(flUInt packetSizeByte)
{
	flUInt packetSizeBit = packetSizeByte * 8;

	flDouble ipDgram = flDouble(IP_HEADER_SIZE + UDP_HEADER_SIZE + packetSizeBit);
	flDouble maxRate = (flDouble)_maximumTransmissionRate;

	flDouble t = TO_SECOND(timeGetTime());

	flDouble sleepTime = (ipDgram / maxRate) - (t - _t0);

	if (_clockMinimumPeriod < sleepTime)
	{
		Sleep(TO_MILLISECOND(sleepTime));
	}
	else if (0.0 < sleepTime && sleepTime <= _clockMinimumPeriod)
	{
		_acc += sleepTime;
		if (_clockMinimumPeriod < _acc)
		{
			Sleep(TO_MILLISECOND(_clockMinimumPeriod));
			_acc = 0.0;
		}
	}
	else
	{
		Sleep(0);
	}

	_t0 = TO_SECOND(timeGetTime());
}
//------------------------------------------------------------------------------
#endif //USE_BUSYWAIT
//------------------------------------------------------------------------------
#endif //__flFMTTimeKeeper_inl__
