/*
**	Copyright (c) 2003-2004 National Institute of Multimedia Education. All rights reserved.
**	2-12 Wakaba, Mihama, Chiba, 261-0014 JAPAN
**	http://www.nime.ac.jp/
*/
//------------------------------------------------------------------------------
#include "Stdafx.h"
#include <flNetwork/flFMTValueRate.h>
//------------------------------------------------------------------------------
flFMTValueRate::flFMTValueRate()
{
	init();
}
//------------------------------------------------------------------------------
flFMTValueRate::~flFMTValueRate()
{
}
//------------------------------------------------------------------------------
void
flFMTValueRate::init()
{
	_prevTime	= 0;
	_index		= 0;
	memset(_timeTable, 0, sizeof(_timeTable));
	memset(_valueTable, 0, sizeof(_valueTable));
}
//------------------------------------------------------------------------------
void
flFMTValueRate::nextTerm()
{
	if (_prevTime == 0)
	{
		_prevTime = timeGetTime();
		return ;
	}

	flULong currentTime = timeGetTime();
	_timeTable[_index] = currentTime - _prevTime;

	_index = (_index < RATE_REFERENCE_COUNT - 1) ? _index + 1 : 0;
	
	_timeTable[_index] = 0;
	_valueTable[_index] = 0;

	_prevTime = currentTime;
}
//------------------------------------------------------------------------------
void
flFMTValueRate::record(flInt value)
{
	_valueTable[_index] += value;
}
//------------------------------------------------------------------------------
flFloat
flFMTValueRate::getRate() const
{
	flULong totalTime = 0;
	flInt totalValue = 0;

	for(flUInt i = 0; i < RATE_REFERENCE_COUNT; i++)
	{
		if (_timeTable[i] == 0)
			continue;

		totalTime += _timeTable[i];
		totalValue += _valueTable[i];
	}

	if (totalTime == 0)
		return 0.0f;

	return flFloat(totalValue) / flFloat(totalTime) / 0.001f;
}
//------------------------------------------------------------------------------
