/*
**	Copyright (c) 2003-2004 National Institute of Multimedia Education. All rights reserved.
**	2-12 Wakaba, Mihama, Chiba, 261-0014 JAPAN
**	http://www.nime.ac.jp/
*/
//------------------------------------------------------------------------------
#ifndef __flMulticastGroup_h__
#define __flMulticastGroup_h__
//------------------------------------------------------------------------------
#include <flBase/flTimer.h>
#include <flBase/flString.h>
#include <winsock2.h>
#include <ws2tcpip.h>
//------------------------------------------------------------------------------
#define USE_OVERLAPPED
//------------------------------------------------------------------------------
#define FLS_FAILED		0
#define FLS_SUCCEEDED	1
#define FLS_CANCELED	-1
//------------------------------------------------------------------------------
class flMulticastGroup 
{

public:
	enum MultiPointOptEnum {
		MPO_SENDER_ONLY,
		MPO_RECEIVER_ONLY,
		MPO_BOTH
	};

public:
	flMulticastGroup();
	virtual ~flMulticastGroup();

public:
	flBool		initialize(const flString& address,
							flUShort port,
							flULong ttl,
							flBool loopBackOn = false,
							flUInt socketBufSize = 8192,
							MultiPointOptEnum multiPointOpt = MPO_BOTH,
							flBool tryUnicast = true);
	flBool		shutdown();
	flBool		isInitialized() const;

	flInt		send(const flChar* buffer, flUInt bufferSize);
	flInt		sendResponse(const flChar* buffer, flUInt bufferSize);
	flInt		receive(flChar* buffer, flUInt bufferSize);

	flString	getSenderAddress() const;

	flBool		breakSend(flLong millisecond = 1);
	flBool		breakReceive(flLong millisecond = 1);

private:
	flBool		_initializeMulticast(const flString& address,
							flUShort port,
							flULong ttl,
							flBool loopBackOn,
							flUInt socketBufSize,
							MultiPointOptEnum multiPointOpt);
	flBool		_initializeUnicast(const flString& address,
							flUShort port,
							flULong ttl,
							flUInt socketBufSize);

	flInt		_send(SOCKADDR* sockAddr, flInt sizeofSockAddr, 
							const flChar* buffer, flUInt bufferSize);
	flInt		_receive(SOCKADDR* sockAddr, flInt& sizeofSockAddr, 
							flChar* buffer, flUInt bufferSize);

protected:
	flBool				_isInit;

	SOCKET				_socket;
	HANDLE				_sendEvents[2];
	HANDLE				_receiveEvents[2];
	flTimer				_breakSendTimer;
	flTimer				_breakReceiveTimer;

	SOCKADDR_STORAGE	_sockAddr;
	SOCKADDR_STORAGE	_destSockAddr;

	size_t				_sockAddrLen;
	size_t				_destSockAddrLen;

	flBool				_destSockAddrIsValid;
};
//------------------------------------------------------------------------------
#endif	//__flMulticastGroup_h__
